"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaNetworkAccessControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmedianetworkaccesscontrol.html

    **Detailed Description**

    The functionality provided by this control allows the setting of a Network
    Access Point.

    This control can be used to set a network access for various network related
    activities. The exact nature is dependent on the underlying usage by the
    supported **QMediaObject** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        ...

    def currentConfiguration(self) -> QtNetwork.QNetworkConfiguration:
        """
        https://doc.qt.io/qt-5/qmedianetworkaccesscontrol.html#currentConfigurat
        ion

        **[pure virtual] QNetworkConfiguration
        QMediaNetworkAccessControl::currentConfiguration() const**

        Returns the current active configuration in use. A default constructed
        QNetworkConfigration is returned if no user supplied configuration are
        in use.
        """
        ...

    def setConfigurations(
        self, configuration: typing.Iterable[QtNetwork.QNetworkConfiguration]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmedianetworkaccesscontrol.html#setConfigurations

        **[pure virtual] void
        QMediaNetworkAccessControl::setConfigurations(const
        QList<QNetworkConfiguration> & configurations )**

        The **configurations** parameter contains a list of network
        configurations to be used for network access.

        It is assumed the list is given in highest to lowest preference order.
        By calling this function all previous configurations will be invalidated
        and replaced with the new list.
        """
        ...

    @property
    def configurationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmedianetworkaccesscontrol.html#configurationChan
        ged

        **[signal] void QMediaNetworkAccessControl::configurationChanged(const
        QNetworkConfiguration & configuration )**

        This signal is emitted when the current active network configuration
        changes to **configuration**.
        """
        ...
