"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QMediaContent(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmediacontent.html

    **Detailed Description**

    QMediaContent is used within the multimedia framework as the logical handle
    to media content. A QMediaContent object contains a **QNetworkRequest**
    which provides the URL of the content.

    A non-null QMediaContent will always have a reference to the content
    available through the **request** () method.

    Alternatively QMediaContent can represent a playlist and contain a pointer
    to a valid **QMediaPlaylist**  object. In this case URL is optional and can
    either be empty or point to the playlist URL.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent

        **QMediaContent::QMediaContent()**

        Constructs a null QMediaContent.
        """
        ...

    @typing.overload
    def __init__(self, contentUrl: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent-1

        **QMediaContent::QMediaContent(const QUrl & url )**

        Constructs a media content with **url** providing a reference to the
        content.
        """
        ...

    @typing.overload
    def __init__(self, contentRequest: QtNetwork.QNetworkRequest) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent-2

        **QMediaContent::QMediaContent(const QNetworkRequest & request )**

        Constructs a media content with **request** providing a reference to the
        content.

        This constructor can be used to reference media content via network
        protocols such as HTTP. This may include additional information required
        to obtain the resource, such as Cookies or HTTP headers.
        """
        ...

    @typing.overload
    def __init__(self, contentResource: "QMediaResource") -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent-5

        **QMediaContent::QMediaContent(const QMediaContent & other )**

        Constructs a copy of the media content **other**.
        """
        ...

    @typing.overload
    def __init__(self, resources: typing.Iterable["QMediaResource"]) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent-6

        **QMediaContent::QMediaContent(QMediaPlaylist * playlist , const QUrl &
        contentUrl = QUrl(), bool takeOwnership = false)**

        Constructs a media content with **playlist**.

        **contentUrl** of a playlist is an optional parameter and can be empty.

        Set **takeOwnership** to true if you want QMediaContent to take
        ownership of the playlist. **takeOwnership** is set to false by default.
        """
        ...

    @typing.overload
    def __init__(self, other: "QMediaContent") -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent

        **QMediaContent::QMediaContent()**

        Constructs a null QMediaContent.
        """
        ...

    @typing.overload
    def __init__(
        self, playlist: "QMediaPlaylist", contentUrl: QtCore.QUrl = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#QMediaContent

        **QMediaContent::QMediaContent()**

        Constructs a null QMediaContent.
        """
        ...

    def request(self) -> QtNetwork.QNetworkRequest:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#request

        **QNetworkRequest QMediaContent::request() const**

        Returns a **QNetworkRequest**  that represents the resource for this
        media content.

        This function was introduced in Qt 5.14.
        """
        ...

    def playlist(self) -> "QMediaPlaylist":
        """
        https://doc.qt.io/qt-5/qmediacontent.html#playlist

        **QMediaPlaylist *QMediaContent::playlist() const**

        Returns a playlist for this media content or 0 if this **QMediaContent**
        is not a playlist.
        """
        ...

    def resources(self) -> typing.List["QMediaResource"]:
        ...

    def canonicalResource(self) -> "QMediaResource":
        ...

    def canonicalRequest(self) -> QtNetwork.QNetworkRequest:
        ...

    def canonicalUrl(self) -> QtCore.QUrl:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediacontent.html#isNull

        **bool QMediaContent::isNull() const**

        Returns true if this media content is null (uninitialized); false
        otherwise.
        """
        ...
