"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QImageEncoderControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qimageencodercontrol.html

    **Detailed Description**

    If a **QMediaService**  supports encoding image data it will implement
    QImageEncoderControl. This control allows to **set image encoding settings**
    and provides functions for quering supported image **codecs**  and
    **resolutions** .

    The interface name of QImageEncoderControl is `org.qt-
    project.qt.imageencodercontrol/5.0` as defined in
    **QImageEncoderControl_iid** .

    **See also** **QImageEncoderSettings**  and
    **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qimageencodercontrol.html#QImageEncoderControl

        **[protected] QImageEncoderControl::QImageEncoderControl(QObject *
        parent = nullptr)**

        Constructs a new image encoder control object with the given **parent**
        """
        ...

    def setImageSettings(self, settings: "QImageEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qimageencodercontrol.html#setImageSettings

        **[pure virtual] void QImageEncoderControl::setImageSettings(const
        QImageEncoderSettings & settings )**

        Sets the selected image encoder **settings**.

        **See also** **imageSettings** ().
        """
        ...

    def imageSettings(self) -> "QImageEncoderSettings":
        """
        https://doc.qt.io/qt-5/qimageencodercontrol.html#imageSettings

        **[pure virtual] QImageEncoderSettings
        QImageEncoderControl::imageSettings() const**

        Returns the currently used image encoder settings.

        The returned value may be different tha passed to
        **QImageEncoderControl::setImageSettings** () if the settings contains
        the default or undefined parameters. In this case if the undefined
        parameters are already resolved, they should be returned.

        **See also** **setImageSettings** ().
        """
        ...

    def supportedResolutions(
        self, settings: "QImageEncoderSettings"
    ) -> typing.Tuple[typing.List[QtCore.QSize], bool]:
        """
        https://doc.qt.io/qt-5/qimageencodercontrol.html#supportedResolutions

        **[pure virtual] QList<QSize>
        QImageEncoderControl::supportedResolutions(const QImageEncoderSettings &
        settings , bool * continuous = nullptr) const**

        Returns a list of supported resolutions.

        If non null image **settings** parameter is passed, the returned list is
        reduced to resolutions supported with partial settings applied. It can
        be used to query the list of resolutions, supported by specific image
        codec.

        If the encoder supports arbitrary resolutions within the supported
        resolutions range, * **continuous** is set to true, otherwise *
        **continuous** is set to false.
        """
        ...

    def imageCodecDescription(self, codec: str) -> str:
        """
        https://doc.qt.io/qt-5/qimageencodercontrol.html#imageCodecDescription

        **[pure virtual] QString
        QImageEncoderControl::imageCodecDescription(const QString & codec )
        const**

        Returns a description of an image **codec**.
        """
        ...

    def supportedImageCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qimageencodercontrol.html#supportedImageCodecs

        **[pure virtual] QStringList
        QImageEncoderControl::supportedImageCodecs() const**

        Returns a list of supported image codecs.
        """
        ...
