"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCameraViewfinderSettings(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcameraviewfindersettings.html

    **Detailed Description**

    A viewfinder settings object is used to specify the viewfinder settings used
    by **QCamera** . Viewfinder settings are selected by constructing a
    QCameraViewfinderSettings object, setting the desired properties and then
    passing it to a **QCamera**  instance using the
    **QCamera::setViewfinderSettings** () function.

    **QCameraViewfinderSettings**  viewfinderSettings;
    viewfinderSettings.setResolution(640, 480);
    viewfinderSettings.setMinimumFrameRate(15.0);
    viewfinderSettings.setMaximumFrameRate(30.0);
    camera->setViewfinderSettings(viewfinderSettings);

    Different cameras may have different capabilities. The application should
    query the camera capabilities before setting parameters. For example, the
    application should call **QCamera::supportedViewfinderResolutions** ()
    before calling **setResolution** ().

    **See also** **QCamera** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#QCameraViewfinderS
        ettings

        **QCameraViewfinderSettings::QCameraViewfinderSettings()**

        Constructs a null viewfinder settings object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QCameraViewfinderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#QCameraViewfinderS
        ettings-1

        **QCameraViewfinderSettings::QCameraViewfinderSettings(const
        QCameraViewfinderSettings & other )**

        Constructs a copy of the viewfinder settings object **other**.
        """
        ...

    @typing.overload
    def setPixelAspectRatio(self, ratio: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setPixelAspectRati
        o

        **void QCameraViewfinderSettings::setPixelAspectRatio(const QSize &
        ratio )**

        Sets the viewfinder pixel aspect **ratio**.

        **See also** **pixelAspectRatio** ().
        """
        ...

    @typing.overload
    def setPixelAspectRatio(self, horizontal: int, vertical: int) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setPixelAspectRati
        o-1

        **void QCameraViewfinderSettings::setPixelAspectRatio(int horizontal ,
        int vertical )**

        This is an overloaded function.

        Sets the **horizontal** and **vertical** elements of the viewfinder's
        pixel aspect ratio.
        """
        ...

    def pixelAspectRatio(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#pixelAspectRatio

        **QSize QCameraViewfinderSettings::pixelAspectRatio() const**

        Returns the viewfinder pixel aspect ratio.

        **See also** **setPixelAspectRatio** ().
        """
        ...

    def setPixelFormat(self, format: "QVideoFrame.PixelFormat") -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setPixelFormat

        **void
        QCameraViewfinderSettings::setPixelFormat(QVideoFrame::PixelFormat
        format )**

        Sets the viewfinder pixel **format**.

        If the given **format** is equal to **QVideoFrame::Format_Invalid** ,
        the backend uses the default format.

        **See also** **pixelFormat** () and
        **QCamera::supportedViewfinderPixelFormats** ().
        """
        ...

    def pixelFormat(self) -> "QVideoFrame.PixelFormat":
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#pixelFormat

        **QVideoFrame::PixelFormat QCameraViewfinderSettings::pixelFormat()
        const**

        Returns the viewfinder pixel format.

        **See also** **setPixelFormat** ().
        """
        ...

    def setMaximumFrameRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setMaximumFrameRat
        e

        **void QCameraViewfinderSettings::setMaximumFrameRate(qreal rate )**

        Sets the viewfinder maximum frame **rate** in frames per second.

        If the maximum frame **rate** is equal to the minimum frame rate, the
        frame rate is fixed. If not, the actual frame rate fluctuates between
        the minimum and the maximum.

        If the given **rate** equals to `0`, the backend makes an optimal choice
        based on the supported frame rates and the other viewfinder settings.

        **See also** **maximumFrameRate** (), **setMinimumFrameRate** (), and
        **QCamera::supportedViewfinderFrameRateRanges** ().
        """
        ...

    def maximumFrameRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#maximumFrameRate

        **qreal QCameraViewfinderSettings::maximumFrameRate() const**

        Returns the viewfinder maximum frame rate in frames per second.

        **See also** **setMaximumFrameRate** () and **minimumFrameRate** ().
        """
        ...

    def setMinimumFrameRate(self, rate: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setMinimumFrameRat
        e

        **void QCameraViewfinderSettings::setMinimumFrameRate(qreal rate )**

        Sets the viewfinder minimum frame **rate** in frames per second.

        If the minimum frame **rate** is equal to the maximum frame rate, the
        frame rate is fixed. If not, the actual frame rate fluctuates between
        the minimum and the maximum.

        If the given **rate** equals to `0`, the backend makes an optimal choice
        based on the supported frame rates and the other viewfinder settings.

        **See also** **minimumFrameRate** (), **setMaximumFrameRate** (), and
        **QCamera::supportedViewfinderFrameRateRanges** ().
        """
        ...

    def minimumFrameRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#minimumFrameRate

        **qreal QCameraViewfinderSettings::minimumFrameRate() const**

        Returns the viewfinder minimum frame rate in frames per second.

        **See also** **setMinimumFrameRate** () and **maximumFrameRate** ().
        """
        ...

    @typing.overload
    def setResolution(self, a0: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setResolution

        **void QCameraViewfinderSettings::setResolution(const QSize & resolution
        )**

        Sets the viewfinder **resolution**.

        If the given **resolution** is empty, the backend makes an optimal
        choice based on the supported resolutions and the other viewfinder
        settings.

        If the camera is used to capture videos or images, the viewfinder
        resolution might be ignored if it conflicts with the capture resolution.

        **See also** **resolution** (), **QVideoEncoderSettings::setResolution**
        (), **QImageEncoderSettings::setResolution** (), and
        **QCamera::supportedViewfinderResolutions** ().
        """
        ...

    @typing.overload
    def setResolution(self, width: int, height: int) -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#setResolution-1

        **void QCameraViewfinderSettings::setResolution(int width , int height
        )**

        This is an overloaded function.

        Sets the **width** and **height** of the viewfinder resolution.
        """
        ...

    def resolution(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#resolution

        **QSize QCameraViewfinderSettings::resolution() const**

        Returns the viewfinder resolution.

        **See also** **setResolution** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#isNull

        **bool QCameraViewfinderSettings::isNull() const**

        Identifies if a viewfinder settings object is uninitalized.

        Returns true if the settings are null, and false if they are not.
        """
        ...

    def swap(self, other: "QCameraViewfinderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qcameraviewfindersettings.html#swap

        **void QCameraViewfinderSettings::swap(QCameraViewfinderSettings & other
        )**

        Swaps this viewfinder settings object with **other**. This function is
        very fast and never fails.
        """
        ...
