"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraLocksControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameralockscontrol.html

    **Detailed Description**

    This service is provided by a **QMediaService**  object via
    QMediaService::control(). It is used by **QCamera** .

    The interface name of QCameraLocksControl is `org.qt-
    project.qt.cameralockscontrol/5.0` as defined in **QCameraLocksControl_iid**
    .

    **See also** **QMediaService::requestControl** () and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameralockscontrol.html#QCameraLocksControl

        **[protected] QCameraLocksControl::QCameraLocksControl(QObject * parent
        = nullptr)**

        Constructs a camera locks control object with **parent**.
        """
        ...

    def unlock(self, locks: typing.Union[QCamera.LockTypes, QCamera.LockType]) -> None:
        """
        https://doc.qt.io/qt-5/qcameralockscontrol.html#unlock

        **[pure virtual] void QCameraLocksControl::unlock(QCamera::LockTypes
        locks )**

        Unlock camera **locks**.
        """
        ...

    def searchAndLock(
        self, locks: typing.Union[QCamera.LockTypes, QCamera.LockType]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameralockscontrol.html#searchAndLock

        **[pure virtual] void
        QCameraLocksControl::searchAndLock(QCamera::LockTypes locks )**

        Request camera **locks**.
        """
        ...

    def lockStatus(self, lock: QCamera.LockType) -> QCamera.LockStatus:
        """
        https://doc.qt.io/qt-5/qcameralockscontrol.html#lockStatus

        **[pure virtual] QCamera::LockStatus
        QCameraLocksControl::lockStatus(QCamera::LockType lock ) const**

        Returns the camera **lock** status.
        """
        ...

    def supportedLocks(self) -> QCamera.LockTypes:
        """
        https://doc.qt.io/qt-5/qcameralockscontrol.html#supportedLocks

        **[pure virtual] QCamera::LockTypes
        QCameraLocksControl::supportedLocks() const**

        Returns the lock types, the camera supports.
        """
        ...

    @property
    def lockStatusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameralockscontrol.html#lockStatusChanged

        **[signal] void QCameraLocksControl::lockStatusChanged(QCamera::LockType
        type , QCamera::LockStatus status , QCamera::LockChangeReason reason )**

        Signals the lock **type** **status** was changed with the specified
        **reason**.
        """
        ...
