"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraInfoControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcamerainfocontrol.html

    **Detailed Description**

    The QCameraInfoControl class provides information about the camera devices
    available on the system.

    The interface name of QCameraInfoControl is `org.qt-
    project.qt.camerainfocontrol/5.3` as defined in **QCameraInfoControl_iid** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcamerainfocontrol.html#QCameraInfoControl

        **[protected] QCameraInfoControl::QCameraInfoControl(QObject * parent =
        nullptr)**

        Constructs a camera info control with the given **parent**.
        """
        ...

    def cameraOrientation(self, deviceName: str) -> int:
        """
        https://doc.qt.io/qt-5/qcamerainfocontrol.html#cameraOrientation

        **[pure virtual] int QCameraInfoControl::cameraOrientation(const QString
        & deviceName ) const**

        Returns the physical orientation of the sensor for the camera named
        **deviceName**.

        The value is the orientation angle (clockwise, in steps of 90 degrees)
        of the camera sensor in relation to the display in its natural
        orientation.
        """
        ...

    def cameraPosition(self, deviceName: str) -> QCamera.Position:
        """
        https://doc.qt.io/qt-5/qcamerainfocontrol.html#cameraPosition

        **[pure virtual] QCamera::Position
        QCameraInfoControl::cameraPosition(const QString & deviceName ) const**

        Returns the physical position of the camera named **deviceName** on the
        hardware system.
        """
        ...
