"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCameraImageCapture(QtCore.QObject, QMediaBindableInterface):
    """
    https://doc.qt.io/qt-5/qcameraimagecapture.html

    **Detailed Description**

    The QCameraImageCapture class is a high level images recording class. It's
    not intended to be used alone but for accessing the media recording
    functions of other media objects, like **QCamera** .

    camera = new **QCamera** ;

        viewfinder = new **QCameraViewfinder**
    ();
        viewfinder->show();

        camera->setViewfinder(viewfinder);
    imageCapture = new **QCameraImageCapture** (camera);
    camera->setCaptureMode(**QCamera** ::CaptureStillImage);
    camera->start();
        //on half pressed shutter button
    camera->searchAndLock();

        //on shutter button pressed
    imageCapture->capture();

        //on shutter button released
    camera->unlock();

    **See also** **QCamera** .
    """

    class CaptureDestination(int):
        CaptureToFile: QCameraImageCapture = ...
        CaptureToBuffer: QCameraImageCapture = ...

    class DriveMode(int):
        SingleImageCapture: QCameraImageCapture = ...

    class Error(int):
        NoError: QCameraImageCapture = ...
        NotReadyError: QCameraImageCapture = ...
        ResourceError: QCameraImageCapture = ...
        OutOfSpaceError: QCameraImageCapture = ...
        NotSupportedFeatureError: QCameraImageCapture = ...
        FormatError: QCameraImageCapture = ...

    class CaptureDestinations(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QCameraImageCapture.CaptureDestinations",
                "QCameraImageCapture.CaptureDestination",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QCameraImageCapture.CaptureDestinations") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QCameraImageCapture.CaptureDestinations":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self, mediaObject: QMediaObject, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#QCameraImageCapture

        **QCameraImageCapture::QCameraImageCapture(QMediaObject * mediaObject ,
        QObject * parent = nullptr)**

        Constructs a media recorder which records the media produced by
        **mediaObject**.

        The **parent** is passed to **QMediaObject** .
        """
        ...

    def setMediaObject(self, a0: QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#setMediaObject

        **[override virtual protected] bool
        QCameraImageCapture::setMediaObject(QMediaObject * mediaObject )**

        Reimplements: **QMediaBindableInterface::setMediaObject** (QMediaObject
        *object).

        **See also** **mediaObject** ().
        """
        ...

    def cancelCapture(self) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#cancelCapture

        **[slot] void QCameraImageCapture::cancelCapture()**

        Cancel incomplete capture requests. Already captured and queused for
        proicessing images may be discarded.
        """
        ...

    def capture(self, file: str = ...) -> int:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#capture

        **[slot] int QCameraImageCapture::capture(const QString & file =
        QString())**

        Capture the image and save it to **file**. This operation is
        asynchronous in majority of cases, followed by signals
        **QCameraImageCapture::imageExposed** (),
        **QCameraImageCapture::imageCaptured** (),
        **QCameraImageCapture::imageSaved** () or **QCameraImageCapture::error**
        ().

        If an empty **file** is passed, the camera backend choses the default
        location and naming scheme for photos on the system, if only file name
        without full path is specified, the image will be saved to the default
        directory, with a full path reported with **imageCaptured** () and
        **imageSaved** () signals.

        **QCamera**  saves all the capture parameters like exposure settings or
        image processing parameters, so changes to camera parameters after
        capture() is called do not affect previous capture requests.

        QCameraImageCapture::capture returns the capture Id parameter, used with
        **imageExposed** (), **imageCaptured** () and **imageSaved** () signals.

        **See also** **isReadyForCapture** ().
        """
        ...

    def setCaptureDestination(
        self,
        destination: typing.Union[
            "QCameraImageCapture.CaptureDestinations",
            "QCameraImageCapture.CaptureDestination",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#setCaptureDestination

        **void QCameraImageCapture::setCaptureDestination(QCameraImageCapture::C
        aptureDestinations destination )**

        Sets the capture **destination** to be used.

        **See also** **isCaptureDestinationSupported** () and
        **captureDestination** ().
        """
        ...

    def captureDestination(self) -> "QCameraImageCapture.CaptureDestinations":
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#captureDestination

        **QCameraImageCapture::CaptureDestinations
        QCameraImageCapture::captureDestination() const**

        Returns the image capture destination being used.

        **See also** **isCaptureDestinationSupported** () and
        **setCaptureDestination** ().
        """
        ...

    def isCaptureDestinationSupported(
        self,
        destination: typing.Union[
            "QCameraImageCapture.CaptureDestinations",
            "QCameraImageCapture.CaptureDestination",
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#isCaptureDestinationSupp
        orted

        **bool QCameraImageCapture::isCaptureDestinationSupported(QCameraImageCa
        pture::CaptureDestinations destination ) const**

        Returns true if the image capture **destination** is supported;
        otherwise returns false.

        **See also** **captureDestination** () and **setCaptureDestination** ().
        """
        ...

    def setBufferFormat(self, format: "QVideoFrame.PixelFormat") -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#setBufferFormat

        **void QCameraImageCapture::setBufferFormat(const
        QVideoFrame::PixelFormat format )**

        Sets the buffer image capture **format** to be used.

        **See also** **bufferFormat** (), **supportedBufferFormats** (), and
        **captureDestination** ().
        """
        ...

    def bufferFormat(self) -> "QVideoFrame.PixelFormat":
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#bufferFormat

        **QVideoFrame::PixelFormat QCameraImageCapture::bufferFormat() const**

        Returns the buffer image capture format being used.

        **See also** **supportedBufferFormats** () and **setBufferFormat** ().
        """
        ...

    def supportedBufferFormats(self) -> typing.List["QVideoFrame.PixelFormat"]:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#supportedBufferFormats

        **QList<QVideoFrame::PixelFormat>
        QCameraImageCapture::supportedBufferFormats() const**

        Returns the list of supported buffer image capture formats.

        **See also** **bufferFormat** () and **setBufferFormat** ().
        """
        ...

    def setEncodingSettings(self, settings: "QImageEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#setEncodingSettings

        **void QCameraImageCapture::setEncodingSettings(const
        QImageEncoderSettings & settings )**

        Sets the image encoding **settings**.

        If some parameters are not specified, or null settings are passed, the
        encoder choose the default encoding parameters.

        **See also** **encodingSettings** ().
        """
        ...

    def encodingSettings(self) -> "QImageEncoderSettings":
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#encodingSettings

        **QImageEncoderSettings QCameraImageCapture::encodingSettings() const**

        Returns the image encoder settings being used.

        **See also** **setEncodingSettings** ().
        """
        ...

    def supportedResolutions(
        self, settings: "QImageEncoderSettings" = ...
    ) -> typing.Tuple[typing.List[QtCore.QSize], bool]:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#supportedResolutions

        **QList<QSize> QCameraImageCapture::supportedResolutions(const
        QImageEncoderSettings & settings = QImageEncoderSettings(), bool *
        continuous = nullptr) const**

        Returns a list of resolutions images can be encoded at.

        If non null image **settings** parameter is passed, the returned list is
        reduced to resolution supported with partial settings like image codec
        or quality applied.

        If the encoder supports arbitrary resolutions within the supported
        range, * **continuous** is set to true, otherwise * **continuous** is
        set to false.

        **See also** **QImageEncoderSettings::resolution** ().
        """
        ...

    def imageCodecDescription(self, codecName: str) -> str:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#imageCodecDescription

        **QString QCameraImageCapture::imageCodecDescription(const QString &
        codec ) const**

        Returns a description of an image **codec**.
        """
        ...

    def supportedImageCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#supportedImageCodecs

        **QStringList QCameraImageCapture::supportedImageCodecs() const**

        Returns a list of supported image codecs.
        """
        ...

    def isReadyForCapture(self) -> bool:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#errorString

        **QString QCameraImageCapture::errorString() const**

        Returns a string describing the current error state.

        **See also** **error** ().
        """
        ...

    def mediaObject(self) -> QMediaObject:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#mediaObject

        **[override virtual] QMediaObject *QCameraImageCapture::mediaObject()
        const**

        Reimplements: **QMediaBindableInterface::mediaObject** () const.

        **See also** **setMediaObject** ().
        """
        ...

    def availability(self) -> "QMultimedia.AvailabilityStatus":
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#availability

        **QMultimedia::AvailabilityStatus QCameraImageCapture::availability()
        const**

        Returns the availability of this functionality.
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#isAvailable

        **bool QCameraImageCapture::isAvailable() const**

        Returns true if the images capture service ready to use.
        """
        ...

    @property
    def bufferFormatChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#bufferFormatChanged

        **[signal] void
        QCameraImageCapture::bufferFormatChanged(QVideoFrame::PixelFormat format
        )**

        Signal emitted when the buffer **format** for the buffer image capture
        has changed.
        """
        ...

    @property
    def captureDestinationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#captureDestinationChange
        d

        **[signal] void QCameraImageCapture::captureDestinationChanged(QCameraIm
        ageCapture::CaptureDestinations destination )**

        Signal emitted when the capture **destination** has changed.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#error

        **QCameraImageCapture::Error QCameraImageCapture::error() const**

        Returns the current error state.

        **See also** **errorString** ().
        """
        ...

    @property
    def imageAvailable(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#imageAvailable

        **[signal] void QCameraImageCapture::imageAvailable(int id , const
        QVideoFrame & frame )**

        Signal emitted when **QCameraImageCapture::CaptureToBuffer**  is set and
        the **frame** with request **id** is available.
        """
        ...

    @property
    def imageCaptured(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#imageCaptured

        **[signal] void QCameraImageCapture::imageCaptured(int id , const QImage
        & preview )**

        Signal emitted when **QAbstractVideoSurface**  is used as a viewfinder
        and the frame with request **id** was captured, but not processed and
        saved yet. Frame **preview** can be displayed to user.
        """
        ...

    @property
    def imageExposed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#imageExposed

        **[signal] void QCameraImageCapture::imageExposed(int id )**

        Signal emitted when the frame with request **id** was exposed.
        """
        ...

    @property
    def imageMetadataAvailable(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#imageMetadataAvailable

        **[signal] void QCameraImageCapture::imageMetadataAvailable(int id ,
        const QString & key , const QVariant & value )**

        Signals that a metadata for an image with request **id** is available.
        Also includes the **key** and **value** of the metadata.

        This signal is emitted between **imageExposed**  and **imageSaved**
        signals.
        """
        ...

    @property
    def imageSaved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#imageSaved

        **[signal] void QCameraImageCapture::imageSaved(int id , const QString &
        fileName )**

        Signal emitted when **QCameraImageCapture::CaptureToFile**  is set and
        the frame with request **id** was saved to **fileName**.
        """
        ...

    @property
    def readyForCaptureChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameraimagecapture.html#readyForCaptureChanged

        **[signal] void QCameraImageCapture::readyForCaptureChanged(bool ready
        )**

        Signals that a camera's **ready** for capture state has changed.

        **Note:** Notifier signal for property **readyForCapture** .
        """
        ...
