"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraFocusControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcamerafocuscontrol.html

    **Detailed Description**

    The interface name of QCameraFocusControl is `org.qt-
    project.qt.camerafocuscontrol/5.0` as defined in **QCameraFocusControl_iid**
    .

    **See also** **QMediaService::requestControl** () and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#QCameraFocusControl

        **[protected] QCameraFocusControl::QCameraFocusControl(QObject * parent
        = nullptr)**

        Constructs a camera control object with **parent**.
        """
        ...

    def focusZones(self) -> typing.List[QCameraFocusZone]:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#focusZones

        **[pure virtual] QCameraFocusZoneList QCameraFocusControl::focusZones()
        const**

        Returns the list of zones, the camera is using for focusing or focused
        on.
        """
        ...

    def setCustomFocusPoint(
        self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#setCustomFocusPoint

        **[pure virtual] void QCameraFocusControl::setCustomFocusPoint(const
        QPointF & point )**

        Sets the custom focus **point**.

        If camera supports fixed set of focus points, it should use the nearest
        supported focus point, and return the actual focus point with
        **QCameraFocusControl::focusZones** ().

        **See also** **QCameraFocusControl::customFocusPoint** () and
        **QCameraFocusControl::focusZones** ().
        """
        ...

    def customFocusPoint(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#customFocusPoint

        **[pure virtual] QPointF QCameraFocusControl::customFocusPoint() const**

        Return the position of custom focus point, in relative frame
        coordinates: **QPointF** (0,0) points to the left top frame point,
        **QPointF** (0.5,0.5) points to the frame center.

        Custom focus point is used only in FocusPointCustom focus mode.

        **See also** **setCustomFocusPoint** ().
        """
        ...

    def isFocusPointModeSupported(self, mode: QCameraFocus.FocusPointMode) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#isFocusPointModeSupporte
        d

        **[pure virtual] bool QCameraFocusControl::isFocusPointModeSupported(QCa
        meraFocus::FocusPointMode mode ) const**

        Returns true if the camera focus point **mode** is supported.
        """
        ...

    def setFocusPointMode(self, mode: QCameraFocus.FocusPointMode) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#setFocusPointMode

        **[pure virtual] void
        QCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode
        )**

        Sets the camera focus point selection **mode**.

        **See also** **focusPointMode** ().
        """
        ...

    def focusPointMode(self) -> QCameraFocus.FocusPointMode:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#focusPointMode

        **[pure virtual] QCameraFocus::FocusPointMode
        QCameraFocusControl::focusPointMode() const**

        Returns the camera focus point selection mode.

        **See also** **setFocusPointMode** ().
        """
        ...

    def isFocusModeSupported(
        self, mode: typing.Union[QCameraFocus.FocusModes, QCameraFocus.FocusMode]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#isFocusModeSupported

        **[pure virtual] bool
        QCameraFocusControl::isFocusModeSupported(QCameraFocus::FocusModes mode
        ) const**

        Returns true if focus **mode** is supported.
        """
        ...

    def setFocusMode(
        self, mode: typing.Union[QCameraFocus.FocusModes, QCameraFocus.FocusMode]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#setFocusMode

        **[pure virtual] void
        QCameraFocusControl::setFocusMode(QCameraFocus::FocusModes mode )**

        Set the focus mode to **mode**.

        **See also** **focusMode** ().
        """
        ...

    def focusMode(self) -> QCameraFocus.FocusModes:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#focusMode

        **[pure virtual] QCameraFocus::FocusModes
        QCameraFocusControl::focusMode() const**

        Returns the focus mode being used.

        **See also** **setFocusMode** ().
        """
        ...

    @property
    def customFocusPointChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#customFocusPointChanged

        **[signal] void QCameraFocusControl::customFocusPointChanged(const
        QPointF & point )**

        Signal is emitted when the custom focus **point** is changed.

        **See also** **QCameraFocusControl::customFocusPoint** () and
        **QCameraFocusControl::setCustomFocusPoint** ().
        """
        ...

    @property
    def focusModeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#focusModeChanged

        **[signal] void
        QCameraFocusControl::focusModeChanged(QCameraFocus::FocusModes mode )**

        Signal is emitted when the focus **mode** is changed, usually in result
        of **QCameraFocusControl::setFocusMode**  call or capture mode changes.

        **See also** **QCameraFocusControl::focusMode** () and
        **QCameraFocusControl::setFocusMode** ().
        """
        ...

    @property
    def focusPointModeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#focusPointModeChanged

        **[signal] void
        QCameraFocusControl::focusPointModeChanged(QCameraFocus::FocusPointMode
        mode )**

        Signal is emitted when the focus point **mode** is changed, usually in
        result of **QCameraFocusControl::setFocusPointMode**  call or capture
        mode changes.

        **See also** **QCameraFocusControl::focusPointMode** () and
        **QCameraFocusControl::setFocusPointMode** ().
        """
        ...

    @property
    def focusZonesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocuscontrol.html#focusZonesChanged

        **[signal] void QCameraFocusControl::focusZonesChanged()**

        Signal is emitted when the set of zones, camera focused on is changed.

        Usually the zones list is changed when the camera is focused.

        **See also** **QCameraFocusControl::focusZones** ().
        """
        ...
