"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioRoleControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qaudiorolecontrol.html

    **Detailed Description**

    If a **QMediaService**  supports audio roles it will implement
    QAudioRoleControl.

    The functionality provided by this control is exposed to application code
    through the **QMediaPlayer**  class.

    The interface name of QAudioRoleControl is `org.qt-
    project.qt.audiorolecontrol/5.6` as defined in **QAudioRoleControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaPlayer** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudiorolecontrol.html#QAudioRoleControl

        **[protected] QAudioRoleControl::QAudioRoleControl(QObject * parent =
        nullptr)**

        Construct a QAudioRoleControl with the given **parent**.
        """
        ...

    def supportedAudioRoles(self) -> typing.List[QAudio.Role]:
        """
        https://doc.qt.io/qt-5/qaudiorolecontrol.html#supportedAudioRoles

        **[pure virtual] QList<QAudio::Role>
        QAudioRoleControl::supportedAudioRoles() const**

        Returns a list of audio roles that the media service supports.
        """
        ...

    def setAudioRole(self, role: QAudio.Role) -> None:
        """
        https://doc.qt.io/qt-5/qaudiorolecontrol.html#setAudioRole

        **[pure virtual] void QAudioRoleControl::setAudioRole(QAudio::Role role
        )**

        Sets the audio **role** of the media played by the media service.

        **See also** **audioRole** ().
        """
        ...

    def audioRole(self) -> QAudio.Role:
        """
        https://doc.qt.io/qt-5/qaudiorolecontrol.html#audioRole

        **[pure virtual] QAudio::Role QAudioRoleControl::audioRole() const**

        Returns the audio role of the media played by the media service.

        **See also** **setAudioRole** ().
        """
        ...

    @property
    def audioRoleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiorolecontrol.html#audioRoleChanged

        **[signal] void QAudioRoleControl::audioRoleChanged(QAudio::Role role
        )**

        Signal emitted when the audio **role** has changed.
        """
        ...
