"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioProbe(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qaudioprobe.html

    **Detailed Description**

    **QAudioRecorder**  *recorder = new **QAudioRecorder** ();
    **QAudioProbe**  *probe = new **QAudioProbe** ;

        // ... configure
    the audio recorder (skipped)

        connect(probe,
    SIGNAL(audioBufferProbed(**QAudioBuffer** )), this,
    SLOT(processBuffer(**QAudioBuffer** )));
    probe->setSource(recorder); // Returns true, hopefully.
    recorder->record(); // Now we can do things like calculating levels or
    performing an FFT

    **See also** **QVideoProbe** , **QMediaPlayer** , and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudioprobe.html#QAudioProbe

        **QAudioProbe::QAudioProbe(QObject * parent = nullptr)**

        Creates a new QAudioProbe class with a **parent**. After setting the
        source to monitor with **setSource** (), the **audioBufferProbed** ()
        signal will be emitted when audio buffers are flowing in the source
        media object.
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudioprobe.html#isActive

        **bool QAudioProbe::isActive() const**

        Returns true if this probe is monitoring something, or false otherwise.

        The source being monitored does not need to be active.
        """
        ...

    @typing.overload
    def setSource(self, source: QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qaudioprobe.html#setSource

        **bool QAudioProbe::setSource(QMediaObject * source )**

        Sets the media object to monitor to **source**.

        If **source** is zero, this probe will be deactivated and this function
        wil return true.

        If the media object does not support monitoring audio, this function
        will return false.

        The previous object will no longer be monitored. Passing in the same
        object will be ignored, but monitoring will continue.
        """
        ...

    @typing.overload
    def setSource(self, source: "QMediaRecorder") -> bool:
        """
        https://doc.qt.io/qt-5/qaudioprobe.html#setSource-1

        **bool QAudioProbe::setSource(QMediaRecorder * mediaRecorder )**

        Starts monitoring the given **mediaRecorder**.

        Returns true on success.

        If there is no mediaObject associated with **mediaRecorder** , or if it
        is zero, this probe will be deactivated and this function wil return
        true.

        If the media recorder instance does not support monitoring audio, this
        function will return false.

        Any previously monitored objects will no longer be monitored. Passing in
        the same (valid) object will be ignored, but monitoring will continue.
        """
        ...

    @property
    def audioBufferProbed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudioprobe.html#audioBufferProbed

        **[signal] void QAudioProbe::audioBufferProbed(const QAudioBuffer &
        buffer )**

        This signal should be emitted when an audio **buffer** is processed in
        the media service.
        """
        ...

    @property
    def flush(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudioprobe.html#flush

        **[signal] void QAudioProbe::flush()**

        This signal should be emitted when it is required to release all
        buffers. Application must release all outstanding references to audio
        buffers.
        """
        ...
