"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioOutputSelectorControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html

    **Detailed Description**

    The QAudioOutputSelectorControl class provides descriptions of the audio
    outputs available on a system and allows one to be selected as the audio
    output of a media service.

    The interface name of QAudioOutputSelectorControl is `org.qt-
    project.qt.audiooutputselectorcontrol/5.0` as defined in
    **QAudioOutputSelectorControl_iid** .

    **See also** **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#QAudioOutputSele
        ctorControl

        **[protected]
        QAudioOutputSelectorControl::QAudioOutputSelectorControl(QObject *
        parent = nullptr)**

        Constructs a new audio output selector control with the given
        **parent**.
        """
        ...

    def setActiveOutput(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#setActiveOutput

        **[pure virtual slot] void
        QAudioOutputSelectorControl::setActiveOutput(const QString & name )**

        Set the active audio output to **name**.

        **See also** **activeOutput** ().
        """
        ...

    def activeOutput(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#activeOutput

        **[pure virtual] QString QAudioOutputSelectorControl::activeOutput()
        const**

        Returns the name of the currently selected audio output.

        **See also** **setActiveOutput** ().
        """
        ...

    def defaultOutput(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#defaultOutput

        **[pure virtual] QString QAudioOutputSelectorControl::defaultOutput()
        const**

        Returns the name of the default audio output.
        """
        ...

    def outputDescription(self, name: str) -> str:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#outputDescriptio
        n

        **[pure virtual] QString
        QAudioOutputSelectorControl::outputDescription(const QString & name )
        const**

        Returns the description of the output **name**.
        """
        ...

    def availableOutputs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#availableOutputs

        **[pure virtual] QList<QString>
        QAudioOutputSelectorControl::availableOutputs() const**

        Returns a list of the names of the available audio outputs.
        """
        ...

    @property
    def activeOutputChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#activeOutputChan
        ged

        **[signal] void QAudioOutputSelectorControl::activeOutputChanged(const
        QString & name )**

        Signals that the audio output has changed to **name**.
        """
        ...

    @property
    def availableOutputsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiooutputselectorcontrol.html#availableOutputs
        Changed

        **[signal] void QAudioOutputSelectorControl::availableOutputsChanged()**

        Signals that list of available outputs has changed.
        """
        ...
