"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QAudioEncoderSettings(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qaudioencodersettings.html

    **Detailed Description**

    A audio encoder settings object is used to specify the audio encoder
    settings used by **QMediaRecorder** . Audio encoder settings are selected by
    constructing a QAudioEncoderSettings object, setting the desired properties
    and then passing it to a **QMediaRecorder**  instance using the
    **QMediaRecorder::setEncodingSettings** () function.

    **QAudioEncoderSettings**  audioSettings;
    audioSettings.setCodec("audio/mpeg");
        audioSettings.setChannelCount(2);
    recorder->setAudioSettings(audioSettings);

    **See also** **QMediaRecorder**  and **QAudioEncoderSettingsControl** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#QAudioEncoderSettings

        **QAudioEncoderSettings::QAudioEncoderSettings()**

        Construct a null audio encoder settings object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QAudioEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#QAudioEncoderSettings-
        1

        **QAudioEncoderSettings::QAudioEncoderSettings(const
        QAudioEncoderSettings & other )**

        Constructs a copy of the audio encoder settings object **other**.
        """
        ...

    def setEncodingOptions(self, options: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setEncodingOptions

        **void QAudioEncoderSettings::setEncodingOptions(const QVariantMap &
        options )**

        Replace all the encoding options with **options**.

        The supported set and meaning of encoding options are system and
        selected codec specific.

        **See also** **encodingOptions** (), **encodingOption** (), and
        **setEncodingOption** ().
        """
        ...

    def setEncodingOption(self, option: str, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setEncodingOption

        **void QAudioEncoderSettings::setEncodingOption(const QString & option ,
        const QVariant & value )**

        Set the encoding **option** to **value**.

        The supported set and meaning of encoding options are system and
        selected codec specific.

        **See also** **encodingOption** () and **setEncodingOptions** ().
        """
        ...

    def encodingOptions(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#encodingOptions

        **QVariantMap QAudioEncoderSettings::encodingOptions() const**

        Returns the all the encoding options as **QVariantMap** .

        **See also** **encodingOption** () and **setEncodingOptions** ().
        """
        ...

    def encodingOption(self, option: str) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#encodingOption

        **QVariant QAudioEncoderSettings::encodingOption(const QString & option
        ) const**

        Returns the value of encoding **option**.

        **See also** **setEncodingOption** () and **encodingOptions** ().
        """
        ...

    def setQuality(self, quality: "QMultimedia.EncodingQuality") -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setQuality

        **void QAudioEncoderSettings::setQuality(QMultimedia::EncodingQuality
        quality )**

        Set the audio encoding **quality**.

        Setting the audio quality parameter allows backend to choose the
        balanced set of encoding parameters to achieve the desired quality
        level.

        The **quality** settings parameter is only used in the **constant
        quality**  **encoding mode** .

        **See also** **quality** ().
        """
        ...

    def quality(self) -> "QMultimedia.EncodingQuality":
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#quality

        **QMultimedia::EncodingQuality QAudioEncoderSettings::quality() const**

        Returns the audio encoding quality.

        **See also** **setQuality** ().
        """
        ...

    def setSampleRate(self, rate: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setSampleRate

        **void QAudioEncoderSettings::setSampleRate(int rate )**

        Sets the audio sample **rate** in Hz.

        A value of -1 indicates the encoder should make an optimal choice based
        on what is avaialbe from the audio source and the limitations of the
        codec.

        **See also** **sampleRate** ().
        """
        ...

    def sampleRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#sampleRate

        **int QAudioEncoderSettings::sampleRate() const**

        Returns the audio sample rate in Hz.

        **See also** **setSampleRate** ().
        """
        ...

    def setChannelCount(self, channels: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setChannelCount

        **void QAudioEncoderSettings::setChannelCount(int channels )**

        Sets the number of audio **channels**.

        A value of -1 indicates the encoder should make an optimal choice based
        on what is available from the audio source and the limitations of the
        codec.

        **See also** **channelCount** ().
        """
        ...

    def channelCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#channelCount

        **int QAudioEncoderSettings::channelCount() const**

        Returns the number of audio channels.

        **See also** **setChannelCount** ().
        """
        ...

    def setBitRate(self, bitrate: int) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setBitRate

        **void QAudioEncoderSettings::setBitRate(int rate )**

        Sets the audio bit **rate** in bits per second.

        **See also** **bitRate** ().
        """
        ...

    def bitRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#bitRate

        **int QAudioEncoderSettings::bitRate() const**

        Returns the bit rate of the compressed audio stream in bits per second.

        **See also** **setBitRate** ().
        """
        ...

    def setCodec(self, codec: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setCodec

        **void QAudioEncoderSettings::setCodec(const QString & codec )**

        Sets the audio **codec**.

        **See also** **codec** ().
        """
        ...

    def codec(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#codec

        **QString QAudioEncoderSettings::codec() const**

        Returns the audio codec.

        **See also** **setCodec** ().
        """
        ...

    def setEncodingMode(self, a0: "QMultimedia.EncodingMode") -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#setEncodingMode

        **void QAudioEncoderSettings::setEncodingMode(QMultimedia::EncodingMode
        mode )**

        Sets the audio encoding **mode** setting.

        If **QMultimedia::ConstantQualityEncoding**  is set, the quality
        encoding parameter is used and bit rate is ignored, otherwise the
        bitrate is used.

        The audio codec, channels count and sample rate settings are used in all
        the encoding modes.

        **See also** **encodingMode** () and **QMultimedia::EncodingMode** .
        """
        ...

    def encodingMode(self) -> "QMultimedia.EncodingMode":
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#encodingMode

        **QMultimedia::EncodingMode QAudioEncoderSettings::encodingMode()
        const**

        Returns the audio encoding mode.

        **See also** **setEncodingMode** () and **QMultimedia::EncodingMode** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudioencodersettings.html#isNull

        **bool QAudioEncoderSettings::isNull() const**

        Identifies if an audio settings object is initialized.

        Returns true if the settings object is null, and false if it is not.
        """
        ...
