"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import PyQt5.sip
from PyQt5.QtMultimedia import *


class QAudio(PyQt5.sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qaudio.html

    **Detailed Description**
    """

    class VolumeScale(int):
        LinearVolumeScale: QAudio = ...
        CubicVolumeScale: QAudio = ...
        LogarithmicVolumeScale: QAudio = ...
        DecibelVolumeScale: QAudio = ...

    class Role(int):
        UnknownRole: QAudio = ...
        MusicRole: QAudio = ...
        VideoRole: QAudio = ...
        VoiceCommunicationRole: QAudio = ...
        AlarmRole: QAudio = ...
        NotificationRole: QAudio = ...
        RingtoneRole: QAudio = ...
        AccessibilityRole: QAudio = ...
        SonificationRole: QAudio = ...
        GameRole: QAudio = ...
        CustomRole: QAudio = ...

    class Mode(int):
        AudioInput: QAudio = ...
        AudioOutput: QAudio = ...

    class State(int):
        ActiveState: QAudio = ...
        SuspendedState: QAudio = ...
        StoppedState: QAudio = ...
        IdleState: QAudio = ...
        InterruptedState: QAudio = ...

    class Error(int):
        NoError: QAudio = ...
        OpenError: QAudio = ...
        IOError: QAudio = ...
        UnderrunError: QAudio = ...
        FatalError: QAudio = ...

    def convertVolume(
        self, volume: float, from_: "QAudio.VolumeScale", to: "QAudio.VolumeScale"
    ) -> float:
        """
        https://doc.qt.io/qt-5/qaudio.html#convertVolume

        **qreal QAudio::convertVolume(qreal volume , QAudio::VolumeScale from ,
        QAudio::VolumeScale to )**

        Converts an audio **volume** **from** a volume scale **to** another, and
        returns the result.

        Depending on the context, different scales are used to represent audio
        volume. All Qt Multimedia classes that have an audio volume use a linear
        scale, the reason is that the loudness of a speaker is controlled by
        modulating its voltage on a linear scale. The human ear on the other
        hand, perceives loudness in a logarithmic way. Using a logarithmic scale
        for volume controls is therefore appropriate in most applications. The
        decibel scale is logarithmic by nature and is commonly used to define
        sound levels, it is usually used for UI volume controls in professional
        audio applications. The cubic scale is a computationally cheap
        approximation of a logarithmic scale, it provides more control over
        lower volume levels.

        The following example shows how to convert the volume value from a
        slider control before passing it to a **QMediaPlayer** . As a result,
        the perceived increase in volume is the same when increasing the volume
        slider from 20 to 30 as it is from 50 to 60:

        void applyVolume(int volumeSliderValue)
            {
                //
        volumeSliderValue is in the range [0..100]

                **qreal**
        linearVolume = QAudio::convertVolume(volumeSliderValue / **qreal**
        (100.0),
        QAudio::LogarithmicVolumeScale,
        QAudio::LinearVolumeScale);

                player.setVolume(**qRound**
        (linearVolume * 100));
            }

        This function was introduced in Qt 5.8.

        **See also** **VolumeScale** , **QMediaPlayer::setVolume** (),
        **QAudioOutput::setVolume** (), **QAudioInput::setVolume** (),
        **QSoundEffect::setVolume** (), and **QMediaRecorder::setVolume** ().
        """
        ...
