"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceMatchReply(QPlaceReply):
    """
    https://doc.qt.io/qt-5/qplacematchreply.html

    **Detailed Description**

    If the operation is successful, the number of places in the reply matches
    those in the request. If a particular place in the request is not found, a
    default constructed place is used as a place holder in the reply. In this
    way, there is always a one is to one relationship between input places in
    the request, and output places in the reply.

    If the operation is not successful the number of places is always zero.

    See **Matching places between managers**  for an example on how to use a
    match reply.

    **See also** **QPlaceMatchRequest**  and **QPlaceManager** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchreply.html#QPlaceMatchReply

        **QPlaceMatchReply::QPlaceMatchReply(QObject * parent = nullptr)**

        Constructs a match reply with a given **parent**.
        """
        ...

    def setRequest(self, request: "QPlaceMatchRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacematchreply.html#setRequest

        **[protected] void QPlaceMatchReply::setRequest(const QPlaceMatchRequest
        & request )**

        Sets the match **request** used to generate this reply.

        **See also** **request** ().
        """
        ...

    def setPlaces(self, results: typing.Iterable[QPlace]) -> None:
        """
        https://doc.qt.io/qt-5/qplacematchreply.html#setPlaces

        **[protected] void QPlaceMatchReply::setPlaces(const QList<QPlace> &
        places )**

        Sets the list of matching **places**.

        **See also** **places** ().
        """
        ...

    def request(self) -> "QPlaceMatchRequest":
        """
        https://doc.qt.io/qt-5/qplacematchreply.html#request

        **QPlaceMatchRequest QPlaceMatchReply::request() const**

        Returns the match request that was used to generate this reply.

        **See also** **setRequest** ().
        """
        ...

    def places(self) -> typing.List[QPlace]:
        """
        https://doc.qt.io/qt-5/qplacematchreply.html#places

        **QList<QPlace> QPlaceMatchReply::places() const**

        Returns a list of matching places;

        **See also** **setPlaces** ().
        """
        ...

    def type(self) -> QPlaceReply.Type:
        """
        https://doc.qt.io/qt-5/qplacematchreply.html#type

        **[override virtual] QPlaceReply::Type QPlaceMatchReply::type() const**

        Reimplements: **QPlaceReply::type** () const.

        Returns the type of reply.
        """
        ...
