"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QPlaceContactDetail(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacecontactdetail.html

    **Detailed Description**

    The detail consists of a label and value. The label is a localized string
    that can be presented to the end user that describes that detail value which
    is the actual phone number, email address and so on.

    **Contact Types**

    The QPlaceContactDetail class defines some constant strings which
    characterize standard **contact types**.

    * **QPlaceContactDetail::Phone**
      * **QPlaceContactDetail::Email**
      *
    **QPlaceContactDetail::Website**
      * **QPlaceContactDetail::Fax**

    These types are used to access and modify contact details in **QPlace**
    via:

    * **QPlace::contactDetails** ()
      * **QPlace::setContactDetails** ()
      *
    **QPlace::appendContactDetail** ()
      * **QPlace::contactTypes** ()

    The **contact type** is intended to be a string type so that providers are
    able to introduce new contact types if necessary.
    """

    Email: str = ...
    Fax: str = ...
    Phone: str = ...
    Website: str = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#QPlaceContactDetail

        **QPlaceContactDetail::QPlaceContactDetail()**

        Constructs a contact detail.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceContactDetail") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#QPlaceContactDetail-1

        **QPlaceContactDetail::QPlaceContactDetail(const QPlaceContactDetail &
        other )**

        Creates a copy of **other**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#clear

        **void QPlaceContactDetail::clear()**

        Clears the contact detail.
        """
        ...

    def setValue(self, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#setValue

        **void QPlaceContactDetail::setValue(const QString & value )**

        Sets the **value** of this contact detail.

        **See also** **value** ().
        """
        ...

    def value(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#value

        **QString QPlaceContactDetail::value() const**

        Returns the value of the contact detail.

        **See also** **setValue** ().
        """
        ...

    def setLabel(self, label: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#setLabel

        **void QPlaceContactDetail::setLabel(const QString & label )**

        Sets the **label** of the contact detail.

        **See also** **label** ().
        """
        ...

    def label(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacecontactdetail.html#label

        **QString QPlaceContactDetail::label() const**

        Returns a label describing the contact detail.

        The label can potentially be localized. The language is dependent on the
        entity that sets it, typically this is the manager from which the places
        are sourced. The **QPlaceManager::locales** () field defines what
        language is used.

        **See also** **setLabel** ().
        """
        ...
