"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtPositioning
from PyQt5.QtLocation import *
from PyQt5 import sip


class QGeoRouteSegment(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qgeoroutesegment.html

    **Detailed Description**

    A QGeoRouteSegment instance has information about the physical layout of the
    route segment, the length of the route and estimated time required to
    traverse the route segment and an optional **QGeoManeuver**  associated with
    the beginning of the route segment.

    QGeoRouteSegment instances can be thought of as edges on a routing graph,
    with **QGeoManeuver**  instances as optional labels attached to the vertices
    of the graph.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#QGeoRouteSegment

        **QGeoRouteSegment::QGeoRouteSegment()**

        Constructs an invalid route segment object.

        The route segment will remain invalid until one of
        **setNextRouteSegment** (), **setTravelTime** (), **setDistance** (),
        **setPath** () or **setManeuver** () is called.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoRouteSegment") -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#QGeoRouteSegment-1

        **QGeoRouteSegment::QGeoRouteSegment(const QGeoRouteSegment & other )**

        Constructs a route segment object from the contents of **other**.
        """
        ...

    def isLegLastSegment(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#isLegLastSegment

        **bool QGeoRouteSegment::isLegLastSegment() const**

        Returns whether this route segment is the last segment of a route leg.

        This function was introduced in Qt 5.12.
        """
        ...

    def maneuver(self) -> QGeoManeuver:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#maneuver

        **QGeoManeuver QGeoRouteSegment::maneuver() const**

        Returns the maneuver for this route segment.

        Will return an invalid **QGeoManeuver**  if no information has been
        attached to the starting point of this route segment.

        **See also** **setManeuver** ().
        """
        ...

    def setManeuver(self, maneuver: QGeoManeuver) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#setManeuver

        **void QGeoRouteSegment::setManeuver(const QGeoManeuver & maneuver )**

        Sets the maneuver for this route segment to **maneuver**.

        **See also** **maneuver** ().
        """
        ...

    def path(self) -> typing.List[QtPositioning.QGeoCoordinate]:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#path

        **QList<QGeoCoordinate> QGeoRouteSegment::path() const**

        Returns the geometric shape of this route segment of the route.

        The coordinates should be listed in the order in which they would be
        traversed by someone traveling along this segment of the route.

        **See also** **setPath** ().
        """
        ...

    def setPath(self, path: typing.Iterable[QtPositioning.QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#setPath

        **void QGeoRouteSegment::setPath(const QList<QGeoCoordinate> & path )**

        Sets the geometric shape of this segment of the route to **path**.

        The coordinates in **path** should be listed in the order in which they
        would be traversed by someone traveling along this segment of the route.

        **See also** **path** ().
        """
        ...

    def distance(self) -> float:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#distance

        **qreal QGeoRouteSegment::distance() const**

        Returns the distance covered by this segment of the route, in meters.

        **See also** **setDistance** ().
        """
        ...

    def setDistance(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#setDistance

        **void QGeoRouteSegment::setDistance(qreal distance )**

        Sets the distance covered by this segment of the route, in meters, to
        **distance**.

        **See also** **distance** ().
        """
        ...

    def travelTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#travelTime

        **int QGeoRouteSegment::travelTime() const**

        Returns the estimated amount of time it will take to traverse this
        segment of the route, in seconds.

        **See also** **setTravelTime** ().
        """
        ...

    def setTravelTime(self, secs: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#setTravelTime

        **void QGeoRouteSegment::setTravelTime(int secs )**

        Sets the estimated amount of time it will take to traverse this segment
        of the route, in seconds, to **secs**.

        **See also** **travelTime** ().
        """
        ...

    def nextRouteSegment(self) -> "QGeoRouteSegment":
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#nextRouteSegment

        **QGeoRouteSegment QGeoRouteSegment::nextRouteSegment() const**

        Returns the next route segment in the route.

        Will return an invalid route segment if this is the last route segment
        in the route.

        **See also** **setNextRouteSegment** ().
        """
        ...

    def setNextRouteSegment(self, routeSegment: "QGeoRouteSegment") -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#setNextRouteSegment

        **void QGeoRouteSegment::setNextRouteSegment(const QGeoRouteSegment &
        routeSegment )**

        Sets the next route segment in the route to **routeSegment**.

        **See also** **nextRouteSegment** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoroutesegment.html#isValid

        **bool QGeoRouteSegment::isValid() const**

        Returns whether this route segment is valid or not.

        If **nextRouteSegment** () is called on the last route segment of a
        route, the returned value will be an invalid route segment.
        """
        ...
