"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtPositioning
from PyQt5.QtLocation import *
from PyQt5 import sip


class QGeoManeuver(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qgeomaneuver.html

    **Detailed Description**

    **QGeoRouteSegment**  instances can be thought of as edges on a routing
    graph, with QGeoManeuver instances as optional labels attached to the
    vertices of the graph.

    The most interesting information help in a QGeoManeuver instance is normally
    the textual navigation to provide and the position at which to provide it,
    accessible by **instructionText** () and **position** () respectively.

    It is also possible to determine if a routing waypoint has been passed by
    checking if **waypoint** () returns a valid **QGeoCoordinate** .
    """

    class InstructionDirection(int):
        NoDirection: QGeoManeuver = ...
        DirectionForward: QGeoManeuver = ...
        DirectionBearRight: QGeoManeuver = ...
        DirectionLightRight: QGeoManeuver = ...
        DirectionRight: QGeoManeuver = ...
        DirectionHardRight: QGeoManeuver = ...
        DirectionUTurnRight: QGeoManeuver = ...
        DirectionUTurnLeft: QGeoManeuver = ...
        DirectionHardLeft: QGeoManeuver = ...
        DirectionLeft: QGeoManeuver = ...
        DirectionLightLeft: QGeoManeuver = ...
        DirectionBearLeft: QGeoManeuver = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#QGeoManeuver

        **QGeoManeuver::QGeoManeuver()**

        Constructs a invalid maneuver object.

        The maneuver will remain invalid until one of **setPosition** (),
        **setInstructionText** (), **setDirection** (),
        **setTimeToNextInstruction** (), **setDistanceToNextInstruction** () or
        **setWaypoint** () is called.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoManeuver") -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#QGeoManeuver-1

        **QGeoManeuver::QGeoManeuver(const QGeoManeuver & other )**

        Constructs a maneuver object from the contents of **other**.
        """
        ...

    def extendedAttributes(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#extendedAttributes

        **QVariantMap QGeoManeuver::extendedAttributes() const**

        Returns the extended attributes associated with this maneuver.

        This function was introduced in QtLocation 5.11.

        **See also** **setExtendedAttributes** ().
        """
        ...

    def setExtendedAttributes(
        self, extendedAttributes: typing.Dict[str, typing.Any]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setExtendedAttributes

        **void QGeoManeuver::setExtendedAttributes(const QVariantMap &
        extendedAttributes )**

        Sets the extended attributes **extendedAttributes** associated with this
        maneuver.

        This function was introduced in QtLocation 5.11.

        **See also** **extendedAttributes** ().
        """
        ...

    def waypoint(self) -> QtPositioning.QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#waypoint

        **QGeoCoordinate QGeoManeuver::waypoint() const**

        Returns the waypoint associated with this maneuver.

        If there is not waypoint associated with this maneuver an invalid
        **QGeoCoordinate**  will be returned.

        **See also** **setWaypoint** ().
        """
        ...

    def setWaypoint(self, coordinate: QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setWaypoint

        **void QGeoManeuver::setWaypoint(const QGeoCoordinate & coordinate )**

        Sets the waypoint associated with this maneuver to **coordinate**.

        **See also** **waypoint** ().
        """
        ...

    def distanceToNextInstruction(self) -> float:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#distanceToNextInstruction

        **qreal QGeoManeuver::distanceToNextInstruction() const**

        Returns the distance, in meters, between the point at which the
        associated instruction was issued and the point that the next
        instruction should be issued.

        **See also** **setDistanceToNextInstruction** ().
        """
        ...

    def setDistanceToNextInstruction(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setDistanceToNextInstruction

        **void QGeoManeuver::setDistanceToNextInstruction(qreal distance )**

        Sets the distance, in meters, between the point at which the associated
        instruction was issued and the point that the next instruction should be
        issued to **distance**.

        **See also** **distanceToNextInstruction** ().
        """
        ...

    def timeToNextInstruction(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#timeToNextInstruction

        **int QGeoManeuver::timeToNextInstruction() const**

        Returns the estimated time it will take to travel from the point at
        which the associated instruction was issued and the point that the next
        instruction should be issued, in seconds.

        **See also** **setTimeToNextInstruction** ().
        """
        ...

    def setTimeToNextInstruction(self, secs: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setTimeToNextInstruction

        **void QGeoManeuver::setTimeToNextInstruction(int secs )**

        Sets the estimated time it will take to travel from the point at which
        the associated instruction was issued and the point that the next
        instruction should be issued, in seconds, to **secs**.

        **See also** **timeToNextInstruction** ().
        """
        ...

    def direction(self) -> "QGeoManeuver.InstructionDirection":
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#direction

        **QGeoManeuver::InstructionDirection QGeoManeuver::direction() const**

        Returns the direction associated with the associated instruction.

        **See also** **setDirection** ().
        """
        ...

    def setDirection(self, direction: "QGeoManeuver.InstructionDirection") -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setDirection

        **void QGeoManeuver::setDirection(QGeoManeuver::InstructionDirection
        direction )**

        Sets the direction associated with the associated instruction to
        **direction**.

        **See also** **direction** ().
        """
        ...

    def instructionText(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#instructionText

        **QString QGeoManeuver::instructionText() const**

        Returns the textual navigation instructions.

        **See also** **setInstructionText** ().
        """
        ...

    def setInstructionText(self, instructionText: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setInstructionText

        **void QGeoManeuver::setInstructionText(const QString & instructionText
        )**

        Sets the textual navigation instructions to **instructionText**.

        **See also** **instructionText** ().
        """
        ...

    def position(self) -> QtPositioning.QGeoCoordinate:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#position

        **QGeoCoordinate QGeoManeuver::position() const**

        Returns the position where **instructionText** () should be displayed.

        **See also** **setPosition** ().
        """
        ...

    def setPosition(self, position: QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#setPosition

        **void QGeoManeuver::setPosition(const QGeoCoordinate & position )**

        Sets the position where **instructionText** () should be displayed to
        **position**.

        **See also** **position** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeomaneuver.html#isValid

        **bool QGeoManeuver::isValid() const**

        Returns whether this maneuver is valid or not.

        Invalid maneuvers are used when there is no information that needs to be
        attached to the endpoint of a **QGeoRouteSegment**  instance.
        """
        ...
