"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtPositioning
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QGeoCodeReply(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgeocodereply.html

    **Detailed Description**

    Instances of QGeoCodeReply manage the state and results of these operations.

    The **isFinished** (), **error** () and **errorString** () methods provide
    information on whether the operation has completed and if it completed
    successfully.

    The **finished** () and error(**QGeoCodeReply::Error** ,**QString** )
    signals can be used to monitor the progress of the operation.

    It is possible that a newly created QGeoCodeReply may be in a finished
    state, most commonly because an error has occurred. Since such an instance
    will never emit the **finished** () or error(**QGeoCodeReply::Error**
    ,**QString** ) signals, it is important to check the result of
    **isFinished** () before making the connections to the signals. The
    documentation for **QGeoCodingManager**  demonstrates how this might be
    carried out.

    If the operation completes successfully the results will be able to be
    accessed with **locations** ().
    """

    class Error(int):
        NoError: QGeoCodeReply = ...
        EngineNotSetError: QGeoCodeReply = ...
        CommunicationError: QGeoCodeReply = ...
        ParseError: QGeoCodeReply = ...
        UnsupportedOptionError: QGeoCodeReply = ...
        CombinationError: QGeoCodeReply = ...
        UnknownError: QGeoCodeReply = ...

    @typing.overload
    def __init__(
        self,
        error: "QGeoCodeReply.Error",
        errorString: str,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#QGeoCodeReply

        **QGeoCodeReply::QGeoCodeReply(QGeoCodeReply::Error error , const
        QString & errorString , QObject * parent = nullptr)**

        Constructs a geocode reply with a given **error** and **errorString**
        and the specified **parent**.
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#QGeoCodeReply-1

        **[protected] QGeoCodeReply::QGeoCodeReply(QObject * parent = nullptr)**

        Constructs a geocode reply with the specified **parent**.
        """
        ...

    def setOffset(self, offset: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#setOffset

        **[protected] void QGeoCodeReply::setOffset(int offset )**

        Sets the offset in the entire result set at which to start fetching
        result to **offset**.

        **See also** **offset** ().
        """
        ...

    def setLimit(self, limit: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#setLimit

        **[protected] void QGeoCodeReply::setLimit(int limit )**

        Sets the limit on the number of responses from each data source to
        **limit**.

        If **limit** is -1 then all available responses will be returned.

        **See also** **limit** ().
        """
        ...

    def setLocations(
        self, locations: typing.Iterable[QtPositioning.QGeoLocation]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#setLocations

        **[protected] void QGeoCodeReply::setLocations(const QList<QGeoLocation>
        & locations )**

        Sets the list of **locations** in the reply.

        **See also** **locations** ().
        """
        ...

    def addLocation(self, location: QtPositioning.QGeoLocation) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#addLocation

        **[protected] void QGeoCodeReply::addLocation(const QGeoLocation &
        location )**

        Adds **location** to the list of locations in this reply.
        """
        ...

    def setViewport(self, viewport: QtPositioning.QGeoShape) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#setViewport

        **[protected] void QGeoCodeReply::setViewport(const QGeoShape & viewport
        )**

        Sets the viewport which contains the results to **viewport**.

        **See also** **viewport** ().
        """
        ...

    def setFinished(self, finished: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#setFinished

        **[protected] void QGeoCodeReply::setFinished(bool finished )**

        Sets whether or not this reply has finished to **finished**.

        If **finished** is true, this will cause the **finished** () signal to
        be emitted.

        If the operation completed successfully, **QGeoCodeReply::setLocations**
        () should be called before this function. If an error occurred,
        **QGeoCodeReply::setError** () should be used instead.

        **See also** **finished** ().
        """
        ...

    def setError(self, error: "QGeoCodeReply.Error", errorString: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#setError

        **[protected] void QGeoCodeReply::setError(QGeoCodeReply::Error error ,
        const QString & errorString )**

        Sets the error state of this reply to **error** and the textual
        representation of the error to **errorString**.

        This will also cause **error** () and **finished** () signals to be
        emitted, in that order.

        **See also** **error** ().
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#abort

        **[virtual] void QGeoCodeReply::abort()**

        Cancels the operation immediately.

        This will do nothing if the reply is finished.

        **See also** **aborted** ().
        """
        ...

    def offset(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#offset

        **int QGeoCodeReply::offset() const**

        Returns the offset into the entire result set at which to start fetching
        results.

        **See also** **setOffset** ().
        """
        ...

    def limit(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#limit

        **int QGeoCodeReply::limit() const**

        Returns the limit on the number of responses from each data source.

        If no limit was set this function will return -1.

        This may be more than **locations** ().length() if the number of
        responses was less than the number requested.

        **See also** **setLimit** ().
        """
        ...

    def locations(self) -> typing.List[QtPositioning.QGeoLocation]:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#locations

        **QList<QGeoLocation> QGeoCodeReply::locations() const**

        Returns a list of locations.

        The locations are the results of the operation corresponding to the
        **QGeoCodingManager**  function which created this reply.

        **See also** **setLocations** ().
        """
        ...

    def viewport(self) -> QtPositioning.QGeoShape:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#viewport

        **QGeoShape QGeoCodeReply::viewport() const**

        Returns the viewport which contains the results.

        This function will return 0 if no viewport bias was specified in the
        **QGeoCodingManager**  function which created this reply.

        **See also** **setViewport** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#errorString

        **QString QGeoCodeReply::errorString() const**

        Returns the textual representation of the error state of this reply.

        If no error has occurred this will return an empty string. It is
        possible that an error occurred which has no associated textual
        representation, in which case this will also return an empty string.

        To determine whether an error has occurred, check to see if
        **QGeoCodeReply::error** () is equal to **QGeoCodeReply::NoError** .
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#isFinished

        **bool QGeoCodeReply::isFinished() const**

        Return true if the operation completed successfully or encountered an
        error which cause the operation to come to a halt.
        """
        ...

    @property
    def aborted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#aborted

        **[signal] void QGeoCodeReply::aborted()**

        This signal is emitted when the operation has been cancelled.

        This function was introduced in Qt 5.9.

        **See also** **abort** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#error

        **QGeoCodeReply::Error QGeoCodeReply::error() const**

        Returns the error state of this reply.

        If the result is **QGeoCodeReply::NoError**  then no error has occurred.

        **See also** **setError** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeocodereply.html#finished

        **[signal] void QGeoCodeReply::finished()**

        This signal is emitted when this reply has finished processing.

        If **error** () equals **QGeoCodeReply::NoError**  then the processing
        finished successfully.

        This signal and **QGeoCodingManager::finished** () will be emitted at
        the same time.

        **Note:** Do not delete this reply object in the slot connected to this
        signal. Use **deleteLater** () instead.

        **See also** **setFinished** ().
        """
        ...
