"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtHelp import *


class QHelpFilterEngine(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qhelpfilterengine.html

    **Detailed Description**

    The filter engine allows the management of filters associated with a
    **QHelpEngineCore**  instance. The help engine internally creates an
    instance of the filter engine, which can be accessed by calling
    **QHelpEngineCore::filterEngine** (). Therefore, the public constructor of
    this class is disabled.

    The filters are identified by a filter name string. Filter details are
    described by the **QHelpFilterData**  class.

    The filter engine allows for adding new filters and changing the existing
    filters' data through the **setFilterData** () method. An existing filter
    can be removed through the **removeFilter** () method.

    Out of the registered filters one can be marked as the active one. The
    active filter will be used by the associated help engine for returning
    filtered results of many different functions, such as content, index, or
    search results. If no filter is marked active, the help engine returns the
    full results list available.

    The active filter is returned by **activeFilter** () and it can be changed
    by **setActiveFilter** ().

    **See also** **QHelpEngineCore** .
    """

    @typing.overload
    def indices(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#indices

        **QStringList QHelpFilterEngine::indices() const**

        Returns a sorted list of available indices. The returned list contents
        depend on the active filter, and therefore only the indices registered
        for the active filter will be returned.

        This function was introduced in Qt 5.15.
        """
        ...

    @typing.overload
    def indices(self, filterName: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#indices-1

        **QStringList QHelpFilterEngine::indices(const QString & filterName )
        const**

        Returns a sorted list of available indices, filtered by **filterName**.
        The returned list contents depend on the passed filter, and therefore
        only the indices registered for this filter will be returned. If you
        want to get all available indices unfiltered, pass empty string as
        **filterName**.

        This function was introduced in Qt 5.15.
        """
        ...

    def availableVersions(self) -> typing.List[QtCore.QVersionNumber]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#availableVersions

        **QList<QVersionNumber> QHelpFilterEngine::availableVersions() const**

        Returns the list of all available versions defined in all registered
        documentation files.

        This function was introduced in Qt 5.15.
        """
        ...

    def namespacesForFilter(self, filterName: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#namespacesForFilter

        **QStringList QHelpFilterEngine::namespacesForFilter(const QString &
        filterName ) const**

        Returns the list of all registered documentation namespaces that match
        the filter identified by **filterName**.
        """
        ...

    def removeFilter(self, filterName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#removeFilter

        **bool QHelpFilterEngine::removeFilter(const QString & filterName )**

        Removes the filter identified by **filterName**.

        Returns `true` if removing the filter succeeded, otherwise returns
        `false`.
        """
        ...

    def setFilterData(self, filterName: str, filterData: QHelpFilterData) -> bool:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#setFilterData

        **bool QHelpFilterEngine::setFilterData(const QString & filterName ,
        const QHelpFilterData & filterData )**

        Changes the existing filter details of the filter identified by
        **filterName** to **filterData**. If the filter does not exist, a new
        filter is created.

        Returns `true` if setting the filter succeeded, otherwise returns
        `false`.

        **See also** **filterData** ().
        """
        ...

    def filterData(self, filterName: str) -> QHelpFilterData:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#filterData

        **QHelpFilterData QHelpFilterEngine::filterData(const QString &
        filterName ) const**

        Returns the filter details associated with **filterName**.

        **See also** **setFilterData** ().
        """
        ...

    def availableComponents(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#availableComponents

        **QStringList QHelpFilterEngine::availableComponents() const**

        Returns the list of all available components defined in all registered
        documentation files.
        """
        ...

    def setActiveFilter(self, filterName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#setActiveFilter

        **bool QHelpFilterEngine::setActiveFilter(const QString & filterName )**

        Changes the currently active filter to **filterName**.

        Returns `true` if changing the filter succeeded, otherwise returns
        `false`.

        **See also** **activeFilter** ().
        """
        ...

    def activeFilter(self) -> str:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#activeFilter

        **QString QHelpFilterEngine::activeFilter() const**

        Returns the name of the currently active filter.

        **See also** **setActiveFilter** ().
        """
        ...

    def filters(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#filters

        **QStringList QHelpFilterEngine::filters() const**

        Returns the list of all filter names defined inside the filter engine.
        """
        ...

    def namespaceToVersion(self) -> typing.Dict[str, QtCore.QVersionNumber]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#namespaceToVersion

        **QMap<QString, QVersionNumber> QHelpFilterEngine::namespaceToVersion()
        const**

        Returns the map of all the available namespaces as keys together with
        their associated versions as values.
        """
        ...

    def namespaceToComponent(self) -> typing.Dict[str, str]:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#namespaceToComponent

        **QMap<QString, QString> QHelpFilterEngine::namespaceToComponent()
        const**

        Returns the map of all the available namespaces as keys together with
        their associated components as values.
        """
        ...

    @property
    def filterActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qhelpfilterengine.html#filterActivated

        **[signal] void QHelpFilterEngine::filterActivated(const QString &
        newFilter )**

        This signal is emitted when the active filter is set. **newFilter**
        specifies the name of the filter.

        **See also** **setActiveFilter** ().
        """
        ...
