"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QVector4D(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qvector4d.html

    **Detailed Description**

    The QVector4D class can also be used to represent vertices in 4D space. We
    therefore do not need to provide a separate vertex class.

    **See also** **QQuaternion** , **QVector2D** , and **QVector3D** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D

        **QVector4D::QVector4D()**

        Constructs a null vector, i.e. with coordinates (0, 0, 0, 0).
        """
        ...

    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float, wpos: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-2

        **QVector4D::QVector4D(float xpos , float ypos , float zpos , float wpos
        )**

        Constructs a vector with coordinates ( **xpos** , **ypos** , **zpos** ,
        **wpos** ).
        """
        ...

    @typing.overload
    def __init__(self, point: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-3

        **QVector4D::QVector4D(const QPoint & point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and z
        and w coordinates of 0.
        """
        ...

    @typing.overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-4

        **QVector4D::QVector4D(const QPointF & point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and z
        and w coordinates of 0.
        """
        ...

    @typing.overload
    def __init__(self, vector: QVector2D) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-5

        **QVector4D::QVector4D(const QVector2D & vector )**

        Constructs a 4D vector from the specified 2D **vector**. The z and w
        coordinates are set to zero.

        **See also** **toVector2D** ().
        """
        ...

    @typing.overload
    def __init__(self, vector: QVector2D, zpos: float, wpos: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-6

        **QVector4D::QVector4D(const QVector2D & vector , float zpos , float
        wpos )**

        Constructs a 4D vector from the specified 2D **vector**. The z and w
        coordinates are set to **zpos** and **wpos** respectively.

        **See also** **toVector2D** ().
        """
        ...

    @typing.overload
    def __init__(self, vector: QVector3D) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-7

        **QVector4D::QVector4D(const QVector3D & vector )**

        Constructs a 4D vector from the specified 3D **vector**. The w
        coordinate is set to zero.

        **See also** **toVector3D** ().
        """
        ...

    @typing.overload
    def __init__(self, vector: QVector3D, wpos: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D-8

        **QVector4D::QVector4D(const QVector3D & vector , float wpos )**

        Constructs a 4D vector from the specified 3D **vector**. The w
        coordinate is set to **wpos**.

        **See also** **toVector3D** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QVector4D") -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#QVector4D

        **QVector4D::QVector4D()**

        Constructs a null vector, i.e. with coordinates (0, 0, 0, 0).
        """
        ...

    def __neg__(self) -> "QVector4D":
        ...

    def __getitem__(self, i: int) -> float:
        ...

    def toPointF(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qvector4d.html#toPointF

        **QPointF QVector4D::toPointF() const**

        Returns the **QPointF**  form of this 4D vector. The z and w coordinates
        are dropped.

        **See also** **toPoint** () and **toVector2D** ().
        """
        ...

    def toPoint(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qvector4d.html#toPoint

        **QPoint QVector4D::toPoint() const**

        Returns the **QPoint**  form of this 4D vector. The z and w coordinates
        are dropped.

        **See also** **toPointF** () and **toVector2D** ().
        """
        ...

    def setW(self, aW: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#setW

        **void QVector4D::setW(float w )**

        Sets the w coordinate of this point to the given **w** coordinate.

        **See also** **w** (), **setX** (), **setY** (), and **setZ** ().
        """
        ...

    def setZ(self, aZ: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#setZ

        **void QVector4D::setZ(float z )**

        Sets the z coordinate of this point to the given **z** coordinate.

        **See also** **z** (), **setX** (), **setY** (), and **setW** ().
        """
        ...

    def setY(self, aY: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#setY

        **void QVector4D::setY(float y )**

        Sets the y coordinate of this point to the given **y** coordinate.

        **See also** **y** (), **setX** (), **setZ** (), and **setW** ().
        """
        ...

    def setX(self, aX: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#setX

        **void QVector4D::setX(float x )**

        Sets the x coordinate of this point to the given **x** coordinate.

        **See also** **x** (), **setY** (), **setZ** (), and **setW** ().
        """
        ...

    def w(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#w

        **float QVector4D::w() const**

        Returns the w coordinate of this point.

        **See also** **setW** (), **x** (), **y** (), and **z** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#z

        **float QVector4D::z() const**

        Returns the z coordinate of this point.

        **See also** **setZ** (), **x** (), **y** (), and **w** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#y

        **float QVector4D::y() const**

        Returns the y coordinate of this point.

        **See also** **setY** (), **x** (), **z** (), and **w** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#x

        **float QVector4D::x() const**

        Returns the x coordinate of this point.

        **See also** **setX** (), **y** (), **z** (), and **w** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvector4d.html#isNull

        **bool QVector4D::isNull() const**

        Returns `true` if the x, y, z, and w coordinates are set to 0.0,
        otherwise returns `false`.
        """
        ...

    def toVector3DAffine(self) -> QVector3D:
        """
        https://doc.qt.io/qt-5/qvector4d.html#toVector3DAffine

        **QVector3D QVector4D::toVector3DAffine() const**

        Returns the 3D vector form of this 4D vector, dividing the x, y, and z
        coordinates by the w coordinate. Returns a null vector if w is zero.

        **See also** **toVector3D** (), **toVector2DAffine** (), and **toPoint**
        ().
        """
        ...

    def toVector3D(self) -> QVector3D:
        """
        https://doc.qt.io/qt-5/qvector4d.html#toVector3D

        **QVector3D QVector4D::toVector3D() const**

        Returns the 3D vector form of this 4D vector, dropping the w coordinate.

        **See also** **toVector3DAffine** (), **toVector2D** (), and **toPoint**
        ().
        """
        ...

    def toVector2DAffine(self) -> QVector2D:
        """
        https://doc.qt.io/qt-5/qvector4d.html#toVector2DAffine

        **QVector2D QVector4D::toVector2DAffine() const**

        Returns the 2D vector form of this 4D vector, dividing the x and y
        coordinates by the w coordinate and dropping the z coordinate. Returns a
        null vector if w is zero.

        **See also** **toVector2D** (), **toVector3DAffine** (), and **toPoint**
        ().
        """
        ...

    def toVector2D(self) -> QVector2D:
        """
        https://doc.qt.io/qt-5/qvector4d.html#toVector2D

        **QVector2D QVector4D::toVector2D() const**

        Returns the 2D vector form of this 4D vector, dropping the z and w
        coordinates.

        **See also** **toVector2DAffine** (), **toVector3D** (), and **toPoint**
        ().
        """
        ...

    @staticmethod
    def dotProduct(v1: "QVector4D", v2: "QVector4D") -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#dotProduct

        **[static] float QVector4D::dotProduct(const QVector4D & v1 , const
        QVector4D & v2 )**

        Returns the dot product of **v1** and **v2**.
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-5/qvector4d.html#normalize

        **void QVector4D::normalize()**

        Normalizes the currect vector in place. Nothing happens if this vector
        is a null vector or the length of the vector is very close to 1.

        **See also** **length** () and **normalized** ().
        """
        ...

    def normalized(self) -> "QVector4D":
        """
        https://doc.qt.io/qt-5/qvector4d.html#normalized

        **QVector4D QVector4D::normalized() const**

        Returns the normalized unit vector form of this vector.

        If this vector is null, then a null vector is returned. If the length of
        the vector is very close to 1, then the vector will be returned as-is.
        Otherwise the normalized form of the vector of length 1 will be
        returned.

        **See also** **length** () and **normalize** ().
        """
        ...

    def lengthSquared(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#lengthSquared

        **float QVector4D::lengthSquared() const**

        Returns the squared length of the vector from the origin. This is
        equivalent to the dot product of the vector with itself.

        **See also** **length** () and **dotProduct** ().
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector4d.html#length

        **float QVector4D::length() const**

        Returns the length of the vector from the origin.

        **See also** **lengthSquared** () and **normalized** ().
        """
        ...

    def __repr__(self) -> str:
        ...
