"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QVector3D(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qvector3d.html

    **Detailed Description**

    Vectors are one of the main building blocks of 3D representation and
    drawing. They consist of three coordinates, traditionally called x, y, and
    z.

    The QVector3D class can also be used to represent vertices in 3D space. We
    therefore do not need to provide a separate vertex class.

    **See also** **QVector2D** , **QVector4D** , and **QQuaternion** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D

        **QVector3D::QVector3D()**

        Constructs a null vector, i.e. with coordinates (0, 0, 0).
        """
        ...

    @typing.overload
    def __init__(self, xpos: float, ypos: float, zpos: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D-2

        **QVector3D::QVector3D(float xpos , float ypos , float zpos )**

        Constructs a vector with coordinates ( **xpos** , **ypos** , **zpos** ).
        """
        ...

    @typing.overload
    def __init__(self, point: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D-3

        **QVector3D::QVector3D(const QPoint & point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and a
        z coordinate of 0.
        """
        ...

    @typing.overload
    def __init__(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D-4

        **QVector3D::QVector3D(const QPointF & point )**

        Constructs a vector with x and y coordinates from a 2D **point** , and a
        z coordinate of 0.
        """
        ...

    @typing.overload
    def __init__(self, vector: QVector2D) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D-5

        **QVector3D::QVector3D(const QVector2D & vector )**

        Constructs a 3D vector from the specified 2D **vector**. The z
        coordinate is set to zero.

        **See also** **toVector2D** ().
        """
        ...

    @typing.overload
    def __init__(self, vector: QVector2D, zpos: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D-6

        **QVector3D::QVector3D(const QVector2D & vector , float zpos )**

        Constructs a 3D vector from the specified 2D **vector**. The z
        coordinate is set to **zpos**.

        **See also** **toVector2D** ().
        """
        ...

    @typing.overload
    def __init__(self, vector: "QVector4D") -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D-7

        **QVector3D::QVector3D(const QVector4D & vector )**

        Constructs a 3D vector from the specified 4D **vector**. The w
        coordinate is dropped.

        **See also** **toVector4D** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#QVector3D

        **QVector3D::QVector3D()**

        Constructs a null vector, i.e. with coordinates (0, 0, 0).
        """
        ...

    def __neg__(self) -> "QVector3D":
        ...

    def unproject(
        self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: QtCore.QRect
    ) -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#unproject

        **QVector3D QVector3D::unproject(const QMatrix4x4 & modelView , const
        QMatrix4x4 & projection , const QRect & viewport ) const**

        Returns the object/model coordinates of this vector initially in window
        coordinates using the model view matrix **modelView** , the projection
        matrix **projection** and the viewport dimensions **viewport**.

        When transforming from clip to normalized space, a division by the w
        component of the vector components takes place. To prevent dividing by 0
        if w equals to 0, it is set to 1.

        **Note:** y coordinates in **viewport** should use OpenGL orientation.
        OpenGL expects the bottom to be 0 whereas for Qt top is 0.

        This function was introduced in Qt 5.5.

        **See also** **project** ().
        """
        ...

    def project(
        self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: QtCore.QRect
    ) -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#project

        **QVector3D QVector3D::project(const QMatrix4x4 & modelView , const
        QMatrix4x4 & projection , const QRect & viewport ) const**

        Returns the window coordinates of this vector initially in object/model
        coordinates using the model view matrix **modelView** , the projection
        matrix **projection** and the viewport dimensions **viewport**.

        When transforming from clip to normalized space, a division by the w
        component on the vector components takes place. To prevent dividing by 0
        if w equals to 0, it is set to 1.

        **Note:** the returned y coordinates are in OpenGL orientation. OpenGL
        expects the bottom to be 0 whereas for Qt top is 0.

        This function was introduced in Qt 5.5.

        **See also** **unproject** ().
        """
        ...

    def __getitem__(self, i: int) -> float:
        ...

    def distanceToPoint(self, point: "QVector3D") -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#distanceToPoint

        **float QVector3D::distanceToPoint(const QVector3D & point ) const**

        Returns the distance from this vertex to a point defined by the vertex
        **point**.

        This function was introduced in Qt 5.1.

        **See also** **distanceToPlane** () and **distanceToLine** ().
        """
        ...

    def toPointF(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qvector3d.html#toPointF

        **QPointF QVector3D::toPointF() const**

        Returns the **QPointF**  form of this 3D vector. The z coordinate is
        dropped.

        **See also** **toPoint** () and **toVector2D** ().
        """
        ...

    def toPoint(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qvector3d.html#toPoint

        **QPoint QVector3D::toPoint() const**

        Returns the **QPoint**  form of this 3D vector. The z coordinate is
        dropped.

        **See also** **toPointF** () and **toVector2D** ().
        """
        ...

    def setZ(self, aZ: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#setZ

        **void QVector3D::setZ(float z )**

        Sets the z coordinate of this point to the given **z** coordinate.

        **See also** **z** (), **setX** (), and **setY** ().
        """
        ...

    def setY(self, aY: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#setY

        **void QVector3D::setY(float y )**

        Sets the y coordinate of this point to the given **y** coordinate.

        **See also** **y** (), **setX** (), and **setZ** ().
        """
        ...

    def setX(self, aX: float) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#setX

        **void QVector3D::setX(float x )**

        Sets the x coordinate of this point to the given **x** coordinate.

        **See also** **x** (), **setY** (), and **setZ** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#z

        **float QVector3D::z() const**

        Returns the z coordinate of this point.

        **See also** **setZ** (), **x** (), and **y** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#y

        **float QVector3D::y() const**

        Returns the y coordinate of this point.

        **See also** **setY** (), **x** (), and **z** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#x

        **float QVector3D::x() const**

        Returns the x coordinate of this point.

        **See also** **setX** (), **y** (), and **z** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qvector3d.html#isNull

        **bool QVector3D::isNull() const**

        Returns `true` if the x, y, and z coordinates are set to 0.0, otherwise
        returns `false`.
        """
        ...

    def toVector4D(self) -> "QVector4D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#toVector4D

        **QVector4D QVector3D::toVector4D() const**

        Returns the 4D form of this 3D vector, with the w coordinate set to
        zero.

        **See also** **toVector2D** () and **toPoint** ().
        """
        ...

    def toVector2D(self) -> QVector2D:
        """
        https://doc.qt.io/qt-5/qvector3d.html#toVector2D

        **QVector2D QVector3D::toVector2D() const**

        Returns the 2D vector form of this 3D vector, dropping the z coordinate.

        **See also** **toVector4D** () and **toPoint** ().
        """
        ...

    def distanceToLine(self, point: "QVector3D", direction: "QVector3D") -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#distanceToLine

        **float QVector3D::distanceToLine(const QVector3D & point , const
        QVector3D & direction ) const**

        Returns the distance that this vertex is from a line defined by
        **point** and the unit vector **direction**.

        If **direction** is a null vector, then it does not define a line. In
        that case, the distance from **point** to this vertex is returned.

        **See also** **distanceToPlane** ().
        """
        ...

    @typing.overload
    def distanceToPlane(self, plane: "QVector3D", normal: "QVector3D") -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#distanceToPlane

        **float QVector3D::distanceToPlane(const QVector3D & plane , const
        QVector3D & normal ) const**

        Returns the distance from this vertex to a plane defined by the vertex
        **plane** and a **normal** unit vector. The **normal** parameter is
        assumed to have been normalized to a unit vector.

        The return value will be negative if the vertex is below the plane, or
        zero if it is on the plane.

        **See also** **normal** () and **distanceToLine** ().
        """
        ...

    @typing.overload
    def distanceToPlane(
        self, plane1: "QVector3D", plane2: "QVector3D", plane3: "QVector3D"
    ) -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#distanceToPlane-1

        **float QVector3D::distanceToPlane(const QVector3D & plane1 , const
        QVector3D & plane2 , const QVector3D & plane3 ) const**

        This is an overloaded function.

        Returns the distance from this vertex to a plane defined by the vertices
        **plane1** , **plane2** and **plane3**.

        The return value will be negative if the vertex is below the plane, or
        zero if it is on the plane.

        The two vectors that define the plane are **plane2** \\- **plane1** and
        **plane3** \\- **plane1**.

        **See also** **normal** () and **distanceToLine** ().
        """
        ...

    @typing.overload
    @staticmethod
    def normal(v1: "QVector3D", v2: "QVector3D") -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#normal

        **[static] QVector3D QVector3D::normal(const QVector3D & v1 , const
        QVector3D & v2 )**

        Returns the normal vector of a plane defined by vectors **v1** and
        **v2** , normalized to be a unit vector.

        Use **crossProduct** () to compute the cross-product of **v1** and
        **v2** if you do not need the result to be normalized to a unit vector.

        **See also** **crossProduct** () and **distanceToPlane** ().
        """
        ...

    @typing.overload
    @staticmethod
    def normal(v1: "QVector3D", v2: "QVector3D", v3: "QVector3D") -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#normal-1

        **[static] QVector3D QVector3D::normal(const QVector3D & v1 , const
        QVector3D & v2 , const QVector3D & v3 )**

        This is an overloaded function.

        Returns the normal vector of a plane defined by vectors **v2** \\- **v1**
        and **v3** \\- **v1** , normalized to be a unit vector.

        Use **crossProduct** () to compute the cross-product of **v2** \\- **v1**
        and **v3** \\- **v1** if you do not need the result to be normalized to a
        unit vector.

        **See also** **crossProduct** () and **distanceToPlane** ().
        """
        ...

    @staticmethod
    def crossProduct(v1: "QVector3D", v2: "QVector3D") -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#crossProduct

        **[static] QVector3D QVector3D::crossProduct(const QVector3D & v1 ,
        const QVector3D & v2 )**

        Returns the cross-product of vectors **v1** and **v2** , which
        corresponds to the normal vector of a plane defined by **v1** and
        **v2**.

        **See also** **normal** ().
        """
        ...

    @staticmethod
    def dotProduct(v1: "QVector3D", v2: "QVector3D") -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#dotProduct

        **[static] float QVector3D::dotProduct(const QVector3D & v1 , const
        QVector3D & v2 )**

        Returns the dot product of **v1** and **v2**.
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-5/qvector3d.html#normalize

        **void QVector3D::normalize()**

        Normalizes the currect vector in place. Nothing happens if this vector
        is a null vector or the length of the vector is very close to 1.

        **See also** **length** () and **normalized** ().
        """
        ...

    def normalized(self) -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qvector3d.html#normalized

        **QVector3D QVector3D::normalized() const**

        Returns the normalized unit vector form of this vector.

        If this vector is null, then a null vector is returned. If the length of
        the vector is very close to 1, then the vector will be returned as-is.
        Otherwise the normalized form of the vector of length 1 will be
        returned.

        **See also** **length** () and **normalize** ().
        """
        ...

    def lengthSquared(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#lengthSquared

        **float QVector3D::lengthSquared() const**

        Returns the squared length of the vector from the origin. This is
        equivalent to the dot product of the vector with itself.

        **See also** **length** () and **dotProduct** ().
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-5/qvector3d.html#length

        **float QVector3D::length() const**

        Returns the length of the vector from the origin.

        **See also** **lengthSquared** () and **normalized** ().
        """
        ...

    def __repr__(self) -> str:
        ...
