"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTouchEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qtouchevent.html

    **Detailed Description**

    **Enabling Touch Events**

    Touch events occur when pressing, releasing, or moving one or more touch
    points on a touch device (such as a touch-screen or track-pad). To receive
    touch events, widgets have to have the **Qt::WA_AcceptTouchEvents**
    attribute set and graphics items need to have the **acceptTouchEvents**
    attribute set to true.

    When using **QAbstractScrollArea**  based widgets, you should enable the
    **Qt::WA_AcceptTouchEvents**  attribute on the scroll area's **viewport** .

    Similarly to **QMouseEvent** , Qt automatically grabs each touch point on
    the first press inside a widget, and the widget will receive all updates for
    the touch point until it is released. Note that it is possible for a widget
    to receive events for numerous touch points, and that multiple widgets may
    be receiving touch events at the same time.

    **Event Handling**

    All touch events are of type **QEvent::TouchBegin** ,
    **QEvent::TouchUpdate** , **QEvent::TouchEnd**  or **QEvent::TouchCancel** .
    Reimplement **QWidget::event** () or **QAbstractScrollArea::viewportEvent**
    () for widgets and **QGraphicsItem::sceneEvent** () for items in a graphics
    view to receive touch events.

    Unlike widgets, QWindows receive touch events always, there is no need to
    opt in. When working directly with a **QWindow** , it is enough to
    reimplement **QWindow::touchEvent** ().

    The **QEvent::TouchUpdate**  and **QEvent::TouchEnd**  events are sent to
    the widget or item that accepted the **QEvent::TouchBegin**  event. If the
    **QEvent::TouchBegin**  event is not accepted and not filtered by an event
    filter, then no further touch events are sent until the next
    **QEvent::TouchBegin** .

    Some systems may send an event of type **QEvent::TouchCancel** . Upon
    receiving this event applications are requested to ignore the entire active
    touch sequence. For example in a composited system the compositor may decide
    to treat certain gestures as system-wide gestures. Whenever such a decision
    is made (the gesture is recognized), the clients will be notified with a
    **QEvent::TouchCancel**  event so they can update their state accordingly.

    The **touchPoints** () function returns a list of all touch points contained
    in the event. Note that this list may be empty, for example in case of a
    **QEvent::TouchCancel**  event. Information about each touch point can be
    retrieved using the **QTouchEvent::TouchPoint**  class. The
    **Qt::TouchPointState**  enum describes the different states that a touch
    point may have.

    **Note:** The list of **touchPoints** () will never be partial: A touch
    event will always contain a touch point for each existing physical touch
    contacts targetting the window or widget to which the event is sent. For
    instance, assuming that all touches target the same window or widget, an
    event with a condition of **touchPoints** ().count()==2 is guaranteed to
    imply that the number of fingers touching the touchscreen or touchpad is
    exactly two.

    **Event Delivery and Propagation**

    By default, **QGuiApplication**  translates the first touch point in a
    QTouchEvent into a **QMouseEvent** . This makes it possible to enable touch
    events on existing widgets that do not normally handle QTouchEvent. See
    below for information on some special considerations needed when doing this.

    **QEvent::TouchBegin**  is the first touch event sent to a widget. The
    **QEvent::TouchBegin**  event contains a special accept flag that indicates
    whether the receiver wants the event. By default, the event is accepted. You
    should call **ignore** () if the touch event is not handled by your widget.
    The **QEvent::TouchBegin**  event is propagated up the parent widget chain
    until a widget accepts it with **accept** (), or an event filter consumes
    it. For QGraphicsItems, the **QEvent::TouchBegin**  event is propagated to
    items under the mouse (similar to mouse event propagation for
    QGraphicsItems).

    **Touch Point Grouping**

    As mentioned above, it is possible that several widgets can be receiving
    QTouchEvents at the same time. However, Qt makes sure to never send
    duplicate **QEvent::TouchBegin**  events to the same widget, which could
    theoretically happen during propagation if, for example, the user touched 2
    separate widgets in a **QGroupBox**  and both widgets ignored the
    **QEvent::TouchBegin**  event.

    To avoid this, Qt will group new touch points together using the following
    rules:

    * When the first touch point is detected, the destination widget is
    determined firstly by the location on screen and secondly by the propagation
    rules.
      * When additional touch points are detected, Qt first looks to see
    if there are any active touch points on any ancestor or descendent of the
    widget under the new touch point. If there are, the new touch point is
    grouped with the first, and the new touch point will be sent in a single
    QTouchEvent to the widget that handled the first touch point. (The widget
    under the new touch point will not receive an event).

    This makes it possible for sibling widgets to handle touch events
    independently while making sure that the sequence of QTouchEvents is always
    correct.

    **Mouse Events and Touch Event Synthesizing**

    QTouchEvent delivery is independent from that of **QMouseEvent** . The
    application flags **Qt::AA_SynthesizeTouchForUnhandledMouseEvents**  and
    **Qt::AA_SynthesizeMouseForUnhandledTouchEvents**  can be used to enable or
    disable automatic synthesizing of touch events to mouse events and mouse
    events to touch events.

    **Caveats**

    * As mentioned above, enabling touch events means multiple widgets can be
    receiving touch events simultaneously. Combined with the default
    **QWidget::event** () handling for QTouchEvents, this gives you great
    flexibility in designing touch user interfaces. Be aware of the
    implications. For example, it is possible that the user is moving a
    **QSlider**  with one finger and pressing a **QPushButton**  with another.
    The signals emitted by these widgets will be interleaved.
      * Recursion into
    the event loop using one of the exec() methods (e.g., **QDialog::exec** ()
    or **QMenu::exec** ()) in a QTouchEvent event handler is not supported.
    Since there are multiple event recipients, recursion may cause problems,
    including but not limited to lost events and unexpected infinite recursion.
    * QTouchEvents are not affected by a **mouse grab**  or an **active pop-up
    widget** . The behavior of QTouchEvents is undefined when opening a pop-up
    or grabbing the mouse while there are more than one active touch points.

    **See also** **QTouchEvent::TouchPoint** , **Qt::TouchPointState** ,
    **Qt::WA_AcceptTouchEvents** , and **QGraphicsItem::acceptTouchEvents** ().
    """

    class TouchPoint(sip.simplewrapper):
        class InfoFlag(int):
            Pen: QTouchEvent = ...
            Token: QTouchEvent = ...

        class InfoFlags(sip.simplewrapper):
            @typing.overload
            def __init__(self) -> None:
                ...

            @typing.overload
            def __init__(
                self,
                f: typing.Union[
                    "QTouchEvent.TouchPoint.InfoFlags",
                    "QTouchEvent.TouchPoint.InfoFlag",
                ],
            ) -> None:
                ...

            @typing.overload
            def __init__(self, a0: "QTouchEvent.TouchPoint.InfoFlags") -> None:
                ...

            def __hash__(self) -> int:
                ...

            def __bool__(self) -> int:
                ...

            def __invert__(self) -> "QTouchEvent.TouchPoint.InfoFlags":
                ...

            def __index__(self) -> int:
                ...

            def __int__(self) -> int:
                ...

        def ellipseDiameters(self) -> QtCore.QSizeF:
            ...

        def rotation(self) -> float:
            ...

        def uniqueId(self) -> "QPointingDeviceUniqueId":
            ...

        def rawScreenPositions(self) -> typing.List[QtCore.QPointF]:
            ...

        def flags(self) -> "QTouchEvent.TouchPoint.InfoFlags":
            ...

        def velocity(self) -> "QVector2D":
            ...

        def pressure(self) -> float:
            ...

        def screenRect(self) -> QtCore.QRectF:
            ...

        def sceneRect(self) -> QtCore.QRectF:
            ...

        def rect(self) -> QtCore.QRectF:
            ...

        def lastNormalizedPos(self) -> QtCore.QPointF:
            ...

        def startNormalizedPos(self) -> QtCore.QPointF:
            ...

        def normalizedPos(self) -> QtCore.QPointF:
            ...

        def lastScreenPos(self) -> QtCore.QPointF:
            ...

        def startScreenPos(self) -> QtCore.QPointF:
            ...

        def screenPos(self) -> QtCore.QPointF:
            ...

        def lastScenePos(self) -> QtCore.QPointF:
            ...

        def startScenePos(self) -> QtCore.QPointF:
            ...

        def scenePos(self) -> QtCore.QPointF:
            ...

        def lastPos(self) -> QtCore.QPointF:
            ...

        def startPos(self) -> QtCore.QPointF:
            ...

        def pos(self) -> QtCore.QPointF:
            ...

        def state(self) -> QtCore.Qt.TouchPointState:
            ...

        def id(self) -> int:
            ...

    @typing.overload
    def __init__(
        self,
        eventType: QtCore.QEvent.Type,
        device: typing.Optional["QTouchDevice"] = ...,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ] = ...,
        touchPointStates: typing.Union[
            QtCore.Qt.TouchPointStates, QtCore.Qt.TouchPointState
        ] = ...,
        touchPoints: typing.Iterable["QTouchEvent.TouchPoint"] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtouchevent.html#QTouchEvent

        **QTouchEvent::QTouchEvent(QEvent::Type eventType , QTouchDevice *
        device = nullptr, Qt::KeyboardModifiers modifiers = Qt::NoModifier,
        Qt::TouchPointStates touchPointStates = Qt::TouchPointStates(), const
        QList<QTouchEvent::TouchPoint> & touchPoints =
        QList<QTouchEvent::TouchPoint>())**

        Constructs a QTouchEvent with the given **eventType** , **device** , and
        **touchPoints**. The **touchPointStates** and **modifiers** are the
        current touch point states and keyboard modifiers at the time of the
        event.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTouchEvent") -> None:
        """
        https://doc.qt.io/qt-5/qtouchevent.html#QTouchEvent

        **QTouchEvent::QTouchEvent(QEvent::Type eventType , QTouchDevice *
        device = nullptr, Qt::KeyboardModifiers modifiers = Qt::NoModifier,
        Qt::TouchPointStates touchPointStates = Qt::TouchPointStates(), const
        QList<QTouchEvent::TouchPoint> & touchPoints =
        QList<QTouchEvent::TouchPoint>())**

        Constructs a QTouchEvent with the given **eventType** , **device** , and
        **touchPoints**. The **touchPointStates** and **modifiers** are the
        current touch point states and keyboard modifiers at the time of the
        event.
        """
        ...

    def setDevice(self, adevice: "QTouchDevice") -> None:
        """
        https://doc.qt.io/qt-5/qtouchevent.html#device

        **QTouchDevice *QTouchEvent::device() const**

        Returns the touch device from which this touch event originates.
        """
        ...

    def device(self) -> "QTouchDevice":
        """
        https://doc.qt.io/qt-5/qtouchevent.html#device

        **QTouchDevice *QTouchEvent::device() const**

        Returns the touch device from which this touch event originates.
        """
        ...

    def window(self) -> "QWindow":
        """
        https://doc.qt.io/qt-5/qtouchevent.html#window

        **QWindow *QTouchEvent::window() const**

        Returns the window on which the event occurred. Useful for doing global-
        local mapping on data like rawScreenPositions() which, for performance
        reasons, only stores the global positions in the touch event.
        """
        ...

    def touchPoints(self) -> typing.List["QTouchEvent.TouchPoint"]:
        """
        https://doc.qt.io/qt-5/qtouchevent.html#touchPoints

        **const QList<QTouchEvent::TouchPoint> &QTouchEvent::touchPoints()
        const**

        Returns the list of touch points contained in the touch event.
        """
        ...

    def touchPointStates(self) -> QtCore.Qt.TouchPointStates:
        """
        https://doc.qt.io/qt-5/qtouchevent.html#touchPointStates

        **Qt::TouchPointStates QTouchEvent::touchPointStates() const**

        Returns a bitwise OR of all the touch point states for this event.
        """
        ...

    def target(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qtouchevent.html#target

        **QObject *QTouchEvent::target() const**

        Returns the target object within the window on which the event occurred.
        This is typically a **QWidget**  or a **QQuickItem** . May be 0 when no
        specific target is available.
        """
        ...
