"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtGui import *
from PyQt5 import sip


class QTouchDevice(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtouchdevice.html

    **Detailed Description**

    Each **QTouchEvent**  contains a QTouchDevice pointer to allow accessing
    device-specific properties like type and capabilities. It is the
    responsibility of the platform or generic plug-ins to register the available
    touch devices via QWindowSystemInterface before generating any touch events.
    Applications do not need to instantiate this class, they should just access
    the global instances pointed to by **QTouchEvent::device** ().
    """

    class CapabilityFlag(int):
        Position: QTouchDevice = ...
        Area: QTouchDevice = ...
        Pressure: QTouchDevice = ...
        Velocity: QTouchDevice = ...
        RawPositions: QTouchDevice = ...
        NormalizedPosition: QTouchDevice = ...
        MouseEmulation: QTouchDevice = ...

    class DeviceType(int):
        TouchScreen: QTouchDevice = ...
        TouchPad: QTouchDevice = ...

    class Capabilities(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QTouchDevice.Capabilities", "QTouchDevice.CapabilityFlag"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTouchDevice.Capabilities") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QTouchDevice.Capabilities":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#QTouchDevice

        **QTouchDevice::QTouchDevice()**

        Creates a new touch device instance. By default the name is empty, the
        only capability is Position and type is **TouchScreen** .
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTouchDevice") -> None:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#QTouchDevice

        **QTouchDevice::QTouchDevice()**

        Creates a new touch device instance. By default the name is empty, the
        only capability is Position and type is **TouchScreen** .
        """
        ...

    def setMaximumTouchPoints(self, max: int) -> None:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#setMaximumTouchPoints

        **void QTouchDevice::setMaximumTouchPoints(int max )**

        Sets the maximum number of simultaneous touchpoints **max** supported by
        the device and its driver.

        **See also** **maximumTouchPoints** ().
        """
        ...

    def maximumTouchPoints(self) -> int:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#maximumTouchPoints

        **int QTouchDevice::maximumTouchPoints() const**

        Returns the maximum number of simultaneous touch points (fingers) that
        can be detected.

        This function was introduced in Qt 5.2.

        **See also** **setMaximumTouchPoints** ().
        """
        ...

    def setCapabilities(
        self,
        caps: typing.Union["QTouchDevice.Capabilities", "QTouchDevice.CapabilityFlag"],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#setCapabilities

        **void QTouchDevice::setCapabilities(QTouchDevice::Capabilities caps )**

        Sets the capabilities **caps** supported by the device and its driver.

        **See also** **capabilities** ().
        """
        ...

    def setType(self, devType: "QTouchDevice.DeviceType") -> None:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#setType

        **void QTouchDevice::setType(QTouchDevice::DeviceType devType )**

        Sets the device type **devType**.

        **See also** **type** ().
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#setName

        **void QTouchDevice::setName(const QString & name )**

        Sets the **name** (a unique identifier) for the device. In most systems
        it is enough to leave this unset and keep the default empty name. This
        identifier becomes important when having multiple touch devices and a
        need to differentiate between them.

        **See also** **name** ().
        """
        ...

    def capabilities(self) -> "QTouchDevice.Capabilities":
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#capabilities

        **QTouchDevice::Capabilities QTouchDevice::capabilities() const**

        Returns the touch device capabilities.

        **See also** **setCapabilities** ().
        """
        ...

    def type(self) -> "QTouchDevice.DeviceType":
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#type

        **QTouchDevice::DeviceType QTouchDevice::type() const**

        Returns the touch device type.

        **See also** **setType** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#name

        **QString QTouchDevice::name() const**

        Returns the touch device name.

        This string may often be empty. It is however useful for systems that
        have more than one touch input device because there it can be used to
        differentiate between the devices (i.e. to tell from which device a
        **QTouchEvent**  originates from).

        **See also** **setName** ().
        """
        ...

    @staticmethod
    def devices() -> typing.List["QTouchDevice"]:
        """
        https://doc.qt.io/qt-5/qtouchdevice.html#devices

        **[static] QList<const QTouchDevice *> QTouchDevice::devices()**

        Returns a list of all registered devices.

        **Note:** The returned list cannot be used to add new devices. To add a
        simulated touch screen for an autotest, **QTest::createTouchDevice** ()
        can be used. To add real touch screens to QPA plugins, the private
        `QWindowSystemInterface::registerTouchDevice()` function can be used.
        """
        ...
