"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtGui import *


class QTextListFormat(QTextFormat):
    """
    https://doc.qt.io/qt-5/qtextlistformat.html

    **Detailed Description**

    A list is composed of one or more items, represented as text blocks. The
    list's format specifies the appearance of items in the list. In particular,
    it determines the indentation and the style of each item.

    The indentation of the items is an integer value that causes each item to be
    offset from the left margin by a certain amount. This value is read with
    **indent** () and set with **setIndent** ().

    The style used to decorate each item is set with **setStyle** () and can be
    read with the **style** () function. The style controls the type of bullet
    points and numbering scheme used for items in the list. Note that lists that
    use the decimal numbering scheme begin counting at 1 rather than 0.

    Style properties can be set to further configure the appearance of list
    items; for example, the **ListNumberPrefix**  and **ListNumberSuffix**
    properties can be used to customize the numbers used in an ordered list so
    that they appear as (1), (2), (3), etc.:

    **QTextListFormat**  listFormat;
    listFormat.setStyle(**QTextListFormat** ::ListDecimal);
    listFormat.setNumberPrefix("(");
        listFormat.setNumberSuffix(")");
    cursor.insertList(listFormat);

    **See also** **QTextList** .
    """

    class Style(int):
        ListDisc: QTextListFormat = ...
        ListCircle: QTextListFormat = ...
        ListSquare: QTextListFormat = ...
        ListDecimal: QTextListFormat = ...
        ListLowerAlpha: QTextListFormat = ...
        ListUpperAlpha: QTextListFormat = ...
        ListLowerRoman: QTextListFormat = ...
        ListUpperRoman: QTextListFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#QTextListFormat

        **QTextListFormat::QTextListFormat()**

        Constructs a new list format object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTextListFormat") -> None:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#QTextListFormat

        **QTextListFormat::QTextListFormat()**

        Constructs a new list format object.
        """
        ...

    def setNumberSuffix(self, ns: str) -> None:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#setNumberSuffix

        **void QTextListFormat::setNumberSuffix(const QString & numberSuffix )**

        Sets the list format's number suffix to the string specified by
        **numberSuffix**. This can be used with all sorted list types. It does
        not have any effect on unsorted list types.

        The default suffix is ".".

        This function was introduced in Qt 4.8.

        **See also** **numberSuffix** ().
        """
        ...

    def setNumberPrefix(self, np: str) -> None:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#setNumberPrefix

        **void QTextListFormat::setNumberPrefix(const QString & numberPrefix )**

        Sets the list format's number prefix to the string specified by
        **numberPrefix**. This can be used with all sorted list types. It does
        not have any effect on unsorted list types.

        The default prefix is an empty string.

        This function was introduced in Qt 4.8.

        **See also** **numberPrefix** ().
        """
        ...

    def numberSuffix(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#numberSuffix

        **QString QTextListFormat::numberSuffix() const**

        Returns the list format's number suffix.

        This function was introduced in Qt 4.8.

        **See also** **setNumberSuffix** ().
        """
        ...

    def numberPrefix(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#numberPrefix

        **QString QTextListFormat::numberPrefix() const**

        Returns the list format's number prefix.

        This function was introduced in Qt 4.8.

        **See also** **setNumberPrefix** ().
        """
        ...

    def setIndent(self, aindent: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#setIndent

        **void QTextListFormat::setIndent(int indentation )**

        Sets the list format's **indentation**. The indentation is multiplied by
        the **QTextDocument::indentWidth**  property to get the effective indent
        in pixels.

        **See also** **indent** ().
        """
        ...

    def setStyle(self, astyle: "QTextListFormat.Style") -> None:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#setStyle

        **void QTextListFormat::setStyle(QTextListFormat::Style style )**

        Sets the list format's **style**.

        **See also** **style** () and **Style** .
        """
        ...

    def indent(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#indent

        **int QTextListFormat::indent() const**

        Returns the list format's indentation. The indentation is multiplied by
        the **QTextDocument::indentWidth**  property to get the effective indent
        in pixels.

        **See also** **setIndent** ().
        """
        ...

    def style(self) -> "QTextListFormat.Style":
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#style

        **QTextListFormat::Style QTextListFormat::style() const**

        Returns the list format's style.

        **See also** **setStyle** () and **Style** .
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextlistformat.html#isValid

        **bool QTextListFormat::isValid() const**

        Returns `true` if this list format is valid; otherwise returns `false`.
        """
        ...
