"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextLine(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtextline.html

    **Detailed Description**

    A text line is usually created by **QTextLayout::createLine** ().

    After being created, the line can be filled using the **setLineWidth** () or
    **setNumColumns** () functions. A line has a number of attributes including
    the rectangle it occupies, **rect** (), its coordinates, **x** () and **y**
    (), its **textLength** (), **width** () and **naturalTextWidth** (), and its
    **ascent** () and **descent** () relative to the text. The position of the
    cursor in terms of the line is available from **cursorToX** () and its
    inverse from **xToCursor** (). A line can be moved with **setPosition** ().
    """

    class CursorPosition(int):
        CursorBetweenCharacters: QTextLine = ...
        CursorOnCharacter: QTextLine = ...

    class Edge(int):
        Leading: QTextLine = ...
        Trailing: QTextLine = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#QTextLine

        **QTextLine::QTextLine()**

        Creates an invalid line.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTextLine") -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#QTextLine

        **QTextLine::QTextLine()**

        Creates an invalid line.
        """
        ...

    def glyphRuns(self, from_: int = ..., length: int = ...) -> typing.List[QGlyphRun]:
        """
        https://doc.qt.io/qt-5/qtextline.html#glyphRuns

        **QList<QGlyphRun> QTextLine::glyphRuns(int from = -1, int length = -1)
        const**

        Returns the glyph indexes and positions for all glyphs in this
        **QTextLine**  for characters in the range defined by **from** and
        **length**. The **from** index is relative to the beginning of the text
        in the containing **QTextLayout** , and the range must be within the
        range of **QTextLine**  as given by functions **textStart** () and
        **textLength** ().

        If **from** is negative, it will default to **textStart** (), and if
        **length** is negative it will default to the return value of
        **textLength** ().

        This function was introduced in Qt 5.0.

        **See also** **QTextLayout::glyphRuns** ().
        """
        ...

    def horizontalAdvance(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#horizontalAdvance

        **qreal QTextLine::horizontalAdvance() const**

        Returns the horizontal advance of the text. The advance of the text is
        the distance from its position to the next position at which text would
        naturally be drawn.

        By adding the advance to the position of the text line and using this as
        the position of a second text line, you will be able to position the two
        lines side-by-side without gaps in-between.

        This function was introduced in Qt 4.7.
        """
        ...

    def leadingIncluded(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextline.html#leadingIncluded

        **bool QTextLine::leadingIncluded() const**

        Returns `true` if positive leading is included into the line's height;
        otherwise returns `false`.

        By default, leading is not included.

        This function was introduced in Qt 4.6.

        **See also** **setLeadingIncluded** ().
        """
        ...

    def setLeadingIncluded(self, included: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#setLeadingIncluded

        **void QTextLine::setLeadingIncluded(bool included )**

        Includes positive leading into the line's height if **included** is
        true; otherwise does not include leading.

        By default, leading is not included.

        Note that negative leading is ignored, it must be handled in the code
        using the text lines by letting the lines overlap.

        This function was introduced in Qt 4.6.

        **See also** **leadingIncluded** ().
        """
        ...

    def leading(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#leading

        **qreal QTextLine::leading() const**

        Returns the line's leading.

        This function was introduced in Qt 4.6.

        **See also** **ascent** (), **descent** (), and **height** ().
        """
        ...

    def position(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qtextline.html#position

        **QPointF QTextLine::position() const**

        Returns the line's position relative to the text layout's position.

        **See also** **setPosition** ().
        """
        ...

    def draw(
        self,
        painter: QPainter,
        position: typing.Union[QtCore.QPointF, QtCore.QPoint],
        selection: typing.Optional[QTextLayout.FormatRange] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#draw

        **void QTextLine::draw(QPainter * painter , const QPointF & position ,
        const QTextLayout::FormatRange * selection = nullptr) const**

        Draws a line on the given **painter** at the specified **position**. The
        **selection** is reserved for internal use.
        """
        ...

    def lineNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextline.html#lineNumber

        **int QTextLine::lineNumber() const**

        Returns the position of the line in the text engine.
        """
        ...

    def textLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextline.html#textLength

        **int QTextLine::textLength() const**

        Returns the length of the text in the line.

        **See also** **naturalTextWidth** ().
        """
        ...

    def textStart(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextline.html#textStart

        **int QTextLine::textStart() const**

        Returns the start of the line from the beginning of the string passed to
        the **QTextLayout** .
        """
        ...

    def setPosition(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#setPosition

        **void QTextLine::setPosition(const QPointF & pos )**

        Moves the line to position **pos**.

        **See also** **position** ().
        """
        ...

    @typing.overload
    def setNumColumns(self, columns: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#setNumColumns

        **void QTextLine::setNumColumns(int numColumns )**

        Lays out the line. The line is filled from its starting position with as
        many characters as are specified by **numColumns**. In case the text
        cannot be split until **numColumns** characters, the line will be filled
        with as many characters to the next whitespace or end of the text.
        """
        ...

    @typing.overload
    def setNumColumns(self, columns: int, alignmentWidth: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#setNumColumns-1

        **void QTextLine::setNumColumns(int numColumns , qreal alignmentWidth
        )**

        Lays out the line. The line is filled from its starting position with as
        many characters as are specified by **numColumns**. In case the text
        cannot be split until **numColumns** characters, the line will be filled
        with as many characters to the next whitespace or end of the text. The
        provided **alignmentWidth** is used as reference width for alignment.
        """
        ...

    def setLineWidth(self, width: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextline.html#setLineWidth

        **void QTextLine::setLineWidth(qreal width )**

        Lays out the line with the given **width**. The line is filled from its
        starting position with as many characters as will fit into the line. In
        case the text cannot be split at the end of the line, it will be filled
        with additional characters to the next whitespace or end of the text.
        """
        ...

    def xToCursor(self, x: float, edge: "QTextLine.CursorPosition" = ...) -> int:
        """
        https://doc.qt.io/qt-5/qtextline.html#xToCursor

        **int QTextLine::xToCursor(qreal x , QTextLine::CursorPosition cpos =
        CursorBetweenCharacters) const**

        Converts the x-coordinate **x** , to the nearest matching cursor
        position, depending on the cursor position type, **cpos**. Note that
        result cursor position includes possible preedit area text.

        **See also** **cursorToX** ().
        """
        ...

    def cursorToX(
        self, cursorPos: int, edge: "QTextLine.Edge" = ...
    ) -> typing.Tuple[float, int]:
        """
        https://doc.qt.io/qt-5/qtextline.html#cursorToX

        **qreal QTextLine::cursorToX(int * cursorPos , QTextLine::Edge edge =
        Leading) const**

        Converts the cursor position **cursorPos** to the corresponding x
        position inside the line, taking account of the **edge**.

        If **cursorPos** is not a valid cursor position, the nearest valid
        cursor position will be used instead, and **cursorPos** will be modified
        to point to this valid cursor position.

        **See also** **xToCursor** ().
        """
        ...

    def naturalTextRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qtextline.html#naturalTextRect

        **QRectF QTextLine::naturalTextRect() const**

        Returns the rectangle covered by the line.
        """
        ...

    def naturalTextWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#naturalTextWidth

        **qreal QTextLine::naturalTextWidth() const**

        Returns the width of the line that is occupied by text. This is always
        <= to **width** (), and is the minimum width that could be used by
        layout() without changing the line break position.
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#height

        **qreal QTextLine::height() const**

        Returns the line's height. This is equal to **ascent** () + **descent**
        () if leading is not included. If leading is included, this equals to
        **ascent** () + **descent** () + **leading** ().

        **See also** **ascent** (), **descent** (), **leading** (), and
        **setLeadingIncluded** ().
        """
        ...

    def descent(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#descent

        **qreal QTextLine::descent() const**

        Returns the line's descent.

        **See also** **ascent** () and **height** ().
        """
        ...

    def ascent(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#ascent

        **qreal QTextLine::ascent() const**

        Returns the line's ascent.

        **See also** **descent** () and **height** ().
        """
        ...

    def width(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#width

        **qreal QTextLine::width() const**

        Returns the line's width as specified by the layout() function.

        **See also** **naturalTextWidth** (), **x** (), **y** (), **textLength**
        (), and **rect** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#y

        **qreal QTextLine::y() const**

        Returns the line's y position.

        **See also** **x** (), **rect** (), **textLength** (), and **width** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextline.html#x

        **qreal QTextLine::x() const**

        Returns the line's x position.

        **See also** **rect** (), **y** (), **textLength** (), and **width** ().
        """
        ...

    def rect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qtextline.html#rect

        **QRectF QTextLine::rect() const**

        Returns the line's bounding rectangle.

        **See also** **x** (), **y** (), **textLength** (), and **width** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextline.html#isValid

        **bool QTextLine::isValid() const**

        Returns `true` if this text line is valid; otherwise returns `false`.
        """
        ...
