"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextLength(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtextlength.html

    **Detailed Description**

    When we specify a value for the length of an element in a text document, we
    often need to provide some other information so that the length is used in
    the way we expect. For example, when we specify a table width, the value can
    represent a fixed number of pixels, or it can be a percentage value. This
    information changes both the meaning of the value and the way it is used.

    Generally, this class is used to specify table widths. These can be
    specified either as a fixed amount of pixels, as a percentage of the
    containing frame's width, or by a variable width that allows it to take up
    just the space it requires.

    **See also** **QTextTable** .
    """

    class Type(int):
        VariableLength: QTextLength = ...
        FixedLength: QTextLength = ...
        PercentageLength: QTextLength = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextlength.html#QTextLength

        **QTextLength::QTextLength()**

        Constructs a new length object which represents a variable size.
        """
        ...

    @typing.overload
    def __init__(self, atype: "QTextLength.Type", avalue: float) -> None:
        """
        https://doc.qt.io/qt-5/qtextlength.html#QTextLength-1

        **QTextLength::QTextLength(QTextLength::Type type , qreal value )**

        Constructs a new length object of the given **type** and **value**.
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qtextlength.html#QTextLength

        **QTextLength::QTextLength()**

        Constructs a new length object which represents a variable size.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTextLength") -> None:
        """
        https://doc.qt.io/qt-5/qtextlength.html#QTextLength

        **QTextLength::QTextLength()**

        Constructs a new length object which represents a variable size.
        """
        ...

    def rawValue(self) -> float:
        """
        https://doc.qt.io/qt-5/qtextlength.html#rawValue

        **qreal QTextLength::rawValue() const**

        Returns the constraint value that is specific for the type of the
        length. If the length is **QTextLength::PercentageLength**  then the raw
        value is in percent, in the range of 0 to 100. If the length is
        **QTextLength::FixedLength**  then that fixed amount is returned. For
        variable lengths, zero is returned.
        """
        ...

    def value(self, maximumLength: float) -> float:
        """
        https://doc.qt.io/qt-5/qtextlength.html#value

        **qreal QTextLength::value(qreal maximumLength ) const**

        Returns the effective length, constrained by the type of the length
        object and the specified **maximumLength**.

        **See also** **type** ().
        """
        ...

    def type(self) -> "QTextLength.Type":
        """
        https://doc.qt.io/qt-5/qtextlength.html#type

        **QTextLength::Type QTextLength::type() const**

        Returns the type of this length object.

        **See also** **QTextLength::Type** .
        """
        ...
