"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextFormat(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qtextformat.html

    **Detailed Description**

    A QTextFormat is a generic class used for describing the format of parts of
    a **QTextDocument** . The derived classes **QTextCharFormat** ,
    **QTextBlockFormat** , **QTextListFormat** , and **QTextTableFormat**  are
    usually more useful, and describe the formatting that is applied to specific
    parts of the document.

    A format has a `FormatType` which specifies the kinds of text item it can
    format; e.g. a block of text, a list, a table, etc. A format also has
    various properties (some specific to particular format types), as described
    by the Property enum. Every property has a corresponding Property.

    The format type is given by **type** (), and the format can be tested with
    **isCharFormat** (), **isBlockFormat** (), **isListFormat** (),
    **isTableFormat** (), **isFrameFormat** (), and **isImageFormat** (). If the
    type is determined, it can be retrieved with **toCharFormat** (),
    **toBlockFormat** (), **toListFormat** (), **toTableFormat** (),
    **toFrameFormat** (), and **toImageFormat** ().

    A format's properties can be set with the **setProperty** () functions, and
    retrieved with **boolProperty** (), **intProperty** (), **doubleProperty**
    (), and **stringProperty** () as appropriate. All the property IDs used in
    the format can be retrieved with allPropertyIds(). One format can be merged
    into another using **merge** ().

    A format's object index can be set with **setObjectIndex** (), and retrieved
    with **objectIndex** (). These methods can be used to associate the format
    with a **QTextObject** . It is used to represent lists, frames, and tables
    inside the document.

    **See also** **Rich Text Processing** .
    """

    class Property(int):
        ObjectIndex: QTextFormat = ...
        CssFloat: QTextFormat = ...
        LayoutDirection: QTextFormat = ...
        OutlinePen: QTextFormat = ...
        BackgroundBrush: QTextFormat = ...
        ForegroundBrush: QTextFormat = ...
        BlockAlignment: QTextFormat = ...
        BlockTopMargin: QTextFormat = ...
        BlockBottomMargin: QTextFormat = ...
        BlockLeftMargin: QTextFormat = ...
        BlockRightMargin: QTextFormat = ...
        TextIndent: QTextFormat = ...
        BlockIndent: QTextFormat = ...
        BlockNonBreakableLines: QTextFormat = ...
        BlockTrailingHorizontalRulerWidth: QTextFormat = ...
        FontFamily: QTextFormat = ...
        FontPointSize: QTextFormat = ...
        FontSizeAdjustment: QTextFormat = ...
        FontSizeIncrement: QTextFormat = ...
        FontWeight: QTextFormat = ...
        FontItalic: QTextFormat = ...
        FontUnderline: QTextFormat = ...
        FontOverline: QTextFormat = ...
        FontStrikeOut: QTextFormat = ...
        FontFixedPitch: QTextFormat = ...
        FontPixelSize: QTextFormat = ...
        TextUnderlineColor: QTextFormat = ...
        TextVerticalAlignment: QTextFormat = ...
        TextOutline: QTextFormat = ...
        IsAnchor: QTextFormat = ...
        AnchorHref: QTextFormat = ...
        AnchorName: QTextFormat = ...
        ObjectType: QTextFormat = ...
        ListStyle: QTextFormat = ...
        ListIndent: QTextFormat = ...
        FrameBorder: QTextFormat = ...
        FrameMargin: QTextFormat = ...
        FramePadding: QTextFormat = ...
        FrameWidth: QTextFormat = ...
        FrameHeight: QTextFormat = ...
        TableColumns: QTextFormat = ...
        TableColumnWidthConstraints: QTextFormat = ...
        TableCellSpacing: QTextFormat = ...
        TableCellPadding: QTextFormat = ...
        TableCellRowSpan: QTextFormat = ...
        TableCellColumnSpan: QTextFormat = ...
        ImageName: QTextFormat = ...
        ImageWidth: QTextFormat = ...
        ImageHeight: QTextFormat = ...
        TextUnderlineStyle: QTextFormat = ...
        TableHeaderRowCount: QTextFormat = ...
        FullWidthSelection: QTextFormat = ...
        PageBreakPolicy: QTextFormat = ...
        TextToolTip: QTextFormat = ...
        FrameTopMargin: QTextFormat = ...
        FrameBottomMargin: QTextFormat = ...
        FrameLeftMargin: QTextFormat = ...
        FrameRightMargin: QTextFormat = ...
        FrameBorderBrush: QTextFormat = ...
        FrameBorderStyle: QTextFormat = ...
        BackgroundImageUrl: QTextFormat = ...
        TabPositions: QTextFormat = ...
        FirstFontProperty: QTextFormat = ...
        FontCapitalization: QTextFormat = ...
        FontLetterSpacing: QTextFormat = ...
        FontWordSpacing: QTextFormat = ...
        LastFontProperty: QTextFormat = ...
        TableCellTopPadding: QTextFormat = ...
        TableCellBottomPadding: QTextFormat = ...
        TableCellLeftPadding: QTextFormat = ...
        TableCellRightPadding: QTextFormat = ...
        FontStyleHint: QTextFormat = ...
        FontStyleStrategy: QTextFormat = ...
        FontKerning: QTextFormat = ...
        LineHeight: QTextFormat = ...
        LineHeightType: QTextFormat = ...
        FontHintingPreference: QTextFormat = ...
        ListNumberPrefix: QTextFormat = ...
        ListNumberSuffix: QTextFormat = ...
        FontStretch: QTextFormat = ...
        FontLetterSpacingType: QTextFormat = ...
        HeadingLevel: QTextFormat = ...
        ImageQuality: QTextFormat = ...
        FontFamilies: QTextFormat = ...
        FontStyleName: QTextFormat = ...
        BlockQuoteLevel: QTextFormat = ...
        BlockCodeLanguage: QTextFormat = ...
        BlockCodeFence: QTextFormat = ...
        BlockMarker: QTextFormat = ...
        TableBorderCollapse: QTextFormat = ...
        TableCellTopBorder: QTextFormat = ...
        TableCellBottomBorder: QTextFormat = ...
        TableCellLeftBorder: QTextFormat = ...
        TableCellRightBorder: QTextFormat = ...
        TableCellTopBorderStyle: QTextFormat = ...
        TableCellBottomBorderStyle: QTextFormat = ...
        TableCellLeftBorderStyle: QTextFormat = ...
        TableCellRightBorderStyle: QTextFormat = ...
        TableCellTopBorderBrush: QTextFormat = ...
        TableCellBottomBorderBrush: QTextFormat = ...
        TableCellLeftBorderBrush: QTextFormat = ...
        TableCellRightBorderBrush: QTextFormat = ...
        ImageTitle: QTextFormat = ...
        ImageAltText: QTextFormat = ...
        UserProperty: QTextFormat = ...

    class PageBreakFlag(int):
        PageBreak_Auto: QTextFormat = ...
        PageBreak_AlwaysBefore: QTextFormat = ...
        PageBreak_AlwaysAfter: QTextFormat = ...

    class ObjectTypes(int):
        NoObject: QTextFormat = ...
        ImageObject: QTextFormat = ...
        TableObject: QTextFormat = ...
        TableCellObject: QTextFormat = ...
        UserObject: QTextFormat = ...

    class FormatType(int):
        InvalidFormat: QTextFormat = ...
        BlockFormat: QTextFormat = ...
        CharFormat: QTextFormat = ...
        ListFormat: QTextFormat = ...
        TableFormat: QTextFormat = ...
        FrameFormat: QTextFormat = ...
        UserFormat: QTextFormat = ...

    class PageBreakFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QTextFormat.PageBreakFlags", "QTextFormat.PageBreakFlag"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextFormat.PageBreakFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QTextFormat.PageBreakFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#QTextFormat

        **QTextFormat::QTextFormat()**

        Creates a new text format with an `InvalidFormat`.

        **See also** **FormatType** .
        """
        ...

    @typing.overload
    def __init__(self, type: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#QTextFormat-1

        **QTextFormat::QTextFormat(int type )**

        Creates a new text format of the given **type**.

        **See also** **FormatType** .
        """
        ...

    @typing.overload
    def __init__(self, rhs: "QTextFormat") -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#QTextFormat-2

        **QTextFormat::QTextFormat(const QTextFormat & other )**

        Creates a new text format with the same attributes as the **other** text
        format.
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#QTextFormat

        **QTextFormat::QTextFormat()**

        Creates a new text format with an `InvalidFormat`.

        **See also** **FormatType** .
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isEmpty

        **bool QTextFormat::isEmpty() const**

        Returns true if the format does not store any properties; false
        otherwise.

        This function was introduced in Qt 5.3.

        **See also** **propertyCount** () and **properties** ().
        """
        ...

    def swap(self, other: "QTextFormat") -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#swap

        **void QTextFormat::swap(QTextFormat & other )**

        Swaps this text format with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def toTableCellFormat(self) -> "QTextTableCellFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toTableCellFormat

        **QTextTableCellFormat QTextFormat::toTableCellFormat() const**

        Returns this format as a table cell format.

        This function was introduced in Qt 4.4.
        """
        ...

    def isTableCellFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isTableCellFormat

        **bool QTextFormat::isTableCellFormat() const**

        Returns `true` if this text format is a `TableCellFormat`; otherwise
        returns `false`.

        This function was introduced in Qt 4.4.
        """
        ...

    def propertyCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextformat.html#propertyCount

        **int QTextFormat::propertyCount() const**

        Returns the number of properties stored in the format.

        This function was introduced in Qt 4.3.
        """
        ...

    def setObjectType(self, atype: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setObjectType

        **void QTextFormat::setObjectType(int type )**

        Sets the text format's object type to **type**.

        **See also** **ObjectTypes**  and **objectType** ().
        """
        ...

    def clearForeground(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#clearForeground

        **void QTextFormat::clearForeground()**

        Clears the brush used to paint the document's foreground. The default
        brush will be used.

        **See also** **foreground** (), **setForeground** (), and
        **clearBackground** ().
        """
        ...

    def foreground(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qtextformat.html#foreground

        **QBrush QTextFormat::foreground() const**

        Returns the brush used to render foreground details, such as text, frame
        outlines, and table borders.

        **See also** **setForeground** (), **clearForeground** (), and
        **background** ().
        """
        ...

    def setForeground(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setForeground

        **void QTextFormat::setForeground(const QBrush & brush )**

        Sets the foreground brush to the specified **brush**. The foreground
        brush is mostly used to render text.

        **See also** **foreground** (), **clearForeground** (), and
        **setBackground** ().
        """
        ...

    def clearBackground(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#clearBackground

        **void QTextFormat::clearBackground()**

        Clears the brush used to paint the document's background. The default
        brush will be used.

        **See also** **background** (), **setBackground** (), and
        **clearForeground** ().
        """
        ...

    def background(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qtextformat.html#background

        **QBrush QTextFormat::background() const**

        Returns the brush used to paint the document's background.

        **See also** **setBackground** (), **clearBackground** (), and
        **foreground** ().
        """
        ...

    def setBackground(
        self, brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setBackground

        **void QTextFormat::setBackground(const QBrush & brush )**

        Sets the brush use to paint the document's background to the **brush**
        specified.

        **See also** **background** (), **clearBackground** (), and
        **setForeground** ().
        """
        ...

    def layoutDirection(self) -> QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-5/qtextformat.html#layoutDirection

        **Qt::LayoutDirection QTextFormat::layoutDirection() const**

        Returns the document's layout direction.

        **See also** **setLayoutDirection** ().
        """
        ...

    def setLayoutDirection(self, direction: QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setLayoutDirection

        **void QTextFormat::setLayoutDirection(Qt::LayoutDirection direction )**

        Sets the document's layout direction to the specified **direction**.

        **See also** **layoutDirection** ().
        """
        ...

    def toImageFormat(self) -> "QTextImageFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toImageFormat

        **QTextImageFormat QTextFormat::toImageFormat() const**

        Returns this format as an image format.
        """
        ...

    def toFrameFormat(self) -> "QTextFrameFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toFrameFormat

        **QTextFrameFormat QTextFormat::toFrameFormat() const**

        Returns this format as a frame format.
        """
        ...

    def toTableFormat(self) -> "QTextTableFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toTableFormat

        **QTextTableFormat QTextFormat::toTableFormat() const**

        Returns this format as a table format.
        """
        ...

    def toListFormat(self) -> "QTextListFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toListFormat

        **QTextListFormat QTextFormat::toListFormat() const**

        Returns this format as a list format.
        """
        ...

    def toCharFormat(self) -> "QTextCharFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toCharFormat

        **QTextCharFormat QTextFormat::toCharFormat() const**

        Returns this format as a character format.
        """
        ...

    def toBlockFormat(self) -> "QTextBlockFormat":
        """
        https://doc.qt.io/qt-5/qtextformat.html#toBlockFormat

        **QTextBlockFormat QTextFormat::toBlockFormat() const**

        Returns this format as a block format.
        """
        ...

    def isTableFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isTableFormat

        **bool QTextFormat::isTableFormat() const**

        Returns `true` if this text format is a `TableFormat`; otherwise returns
        `false`.
        """
        ...

    def isImageFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isImageFormat

        **bool QTextFormat::isImageFormat() const**

        Returns `true` if this text format is an image format; otherwise returns
        `false`.
        """
        ...

    def isFrameFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isFrameFormat

        **bool QTextFormat::isFrameFormat() const**

        Returns `true` if this text format is a `FrameFormat`; otherwise returns
        `false`.
        """
        ...

    def isListFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isListFormat

        **bool QTextFormat::isListFormat() const**

        Returns `true` if this text format is a `ListFormat`; otherwise returns
        `false`.
        """
        ...

    def isBlockFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isBlockFormat

        **bool QTextFormat::isBlockFormat() const**

        Returns `true` if this text format is a `BlockFormat`; otherwise returns
        `false`.
        """
        ...

    def isCharFormat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isCharFormat

        **bool QTextFormat::isCharFormat() const**

        Returns `true` if this text format is a `CharFormat`; otherwise returns
        `false`.
        """
        ...

    def objectType(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextformat.html#objectType

        **int QTextFormat::objectType() const**

        Returns the text format's object type.

        **See also** **ObjectTypes**  and **setObjectType** ().
        """
        ...

    def properties(self) -> typing.Dict[int, typing.Any]:
        """
        https://doc.qt.io/qt-5/qtextformat.html#properties

        **QMap<int, QVariant> QTextFormat::properties() const**

        Returns a map with all properties of this text format.
        """
        ...

    def lengthVectorProperty(self, propertyId: int) -> typing.List[QTextLength]:
        """
        https://doc.qt.io/qt-5/qtextformat.html#lengthVectorProperty

        **QVector<QTextLength> QTextFormat::lengthVectorProperty(int propertyId
        ) const**

        Returns the value of the property given by **propertyId**. If the
        property isn't of QTextFormat::LengthVector type, an empty length vector
        is returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **colorProperty** (),
        **lengthProperty** (), and **Property** .
        """
        ...

    def lengthProperty(self, propertyId: int) -> QTextLength:
        """
        https://doc.qt.io/qt-5/qtextformat.html#lengthProperty

        **QTextLength QTextFormat::lengthProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId**.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **colorProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def brushProperty(self, propertyId: int) -> QBrush:
        """
        https://doc.qt.io/qt-5/qtextformat.html#brushProperty

        **QBrush QTextFormat::brushProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of QVariant::Brush type, **Qt::NoBrush**  is returned
        instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def penProperty(self, propertyId: int) -> QPen:
        """
        https://doc.qt.io/qt-5/qtextformat.html#penProperty

        **QPen QTextFormat::penProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of QVariant::Pen type, **Qt::NoPen**  is returned
        instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def colorProperty(self, propertyId: int) -> QColor:
        """
        https://doc.qt.io/qt-5/qtextformat.html#colorProperty

        **QColor QTextFormat::colorProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of QVariant::Color type, an invalid color is returned
        instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **stringProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def stringProperty(self, propertyId: int) -> str:
        """
        https://doc.qt.io/qt-5/qtextformat.html#stringProperty

        **QString QTextFormat::stringProperty(int propertyId ) const**

        Returns the value of the property given by **propertyId** ; if the
        property isn't of QVariant::String type, an empty string is returned
        instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **doubleProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def doubleProperty(self, propertyId: int) -> float:
        """
        https://doc.qt.io/qt-5/qtextformat.html#doubleProperty

        **qreal QTextFormat::doubleProperty(int propertyId ) const**

        Returns the value of the property specified by **propertyId**. If the
        property isn't of QVariant::Double or **QMetaType::Float**  type, 0 is
        returned instead.

        **See also** **setProperty** (), **boolProperty** (), **intProperty**
        (), **stringProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def intProperty(self, propertyId: int) -> int:
        """
        https://doc.qt.io/qt-5/qtextformat.html#intProperty

        **int QTextFormat::intProperty(int propertyId ) const**

        Returns the value of the property specified by **propertyId**. If the
        property is not of QTextFormat::Integer type, 0 is returned instead.

        **See also** **setProperty** (), **boolProperty** (), **doubleProperty**
        (), **stringProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def boolProperty(self, propertyId: int) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#boolProperty

        **bool QTextFormat::boolProperty(int propertyId ) const**

        Returns the value of the property specified by **propertyId**. If the
        property isn't of QTextFormat::Bool type, false is returned instead.

        **See also** **setProperty** (), **intProperty** (), **doubleProperty**
        (), **stringProperty** (), **colorProperty** (), **lengthProperty** (),
        **lengthVectorProperty** (), and **Property** .
        """
        ...

    def hasProperty(self, propertyId: int) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#hasProperty

        **bool QTextFormat::hasProperty(int propertyId ) const**

        Returns `true` if the text format has a property with the given
        **propertyId** ; otherwise returns `false`.

        **See also** **properties** () and **Property** .
        """
        ...

    def clearProperty(self, propertyId: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#clearProperty

        **void QTextFormat::clearProperty(int propertyId )**

        Clears the value of the property given by **propertyId**

        **See also** **Property** .
        """
        ...

    @typing.overload
    def setProperty(self, propertyId: int, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setProperty

        **void QTextFormat::setProperty(int propertyId , const QVariant & value
        )**

        Sets the property specified by the **propertyId** to the given
        **value**.

        **See also** **property** () and **Property** .
        """
        ...

    @typing.overload
    def setProperty(
        self, propertyId: int, lengths: typing.Iterable[QTextLength]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setProperty-1

        **void QTextFormat::setProperty(int propertyId , const
        QVector<QTextLength> & value )**

        Sets the value of the property given by **propertyId** to **value**.

        **See also** **lengthVectorProperty** () and **Property** .
        """
        ...

    def property(self, propertyId: int) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qtextformat.html#property

        **QVariant QTextFormat::property(int propertyId ) const**

        Returns the property specified by the given **propertyId**.

        **See also** **setProperty** () and **Property** .
        """
        ...

    def setObjectIndex(self, object: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#setObjectIndex

        **void QTextFormat::setObjectIndex(int index )**

        Sets the format object's object **index**.

        **See also** **objectIndex** ().
        """
        ...

    def objectIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextformat.html#objectIndex

        **int QTextFormat::objectIndex() const**

        Returns the index of the format object, or -1 if the format object is
        invalid.

        **See also** **setObjectIndex** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextformat.html#type

        **int QTextFormat::type() const**

        Returns the type of this format.

        **See also** **FormatType** .
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextformat.html#isValid

        **bool QTextFormat::isValid() const**

        Returns `true` if the format is valid (i.e. is not **InvalidFormat** );
        otherwise returns `false`.
        """
        ...

    def merge(self, other: "QTextFormat") -> None:
        """
        https://doc.qt.io/qt-5/qtextformat.html#merge

        **void QTextFormat::merge(const QTextFormat & other )**

        Merges the **other** format with this format; where there are conflicts
        the **other** format takes precedence.
        """
        ...
