"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QSurface(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsurface.html

    **Detailed Description**

    The size of the surface is accessible with the **size** () function. The
    rendering specific attributes of the surface are accessible through the
    **format** () function.
    """

    class SurfaceType(int):
        RasterSurface: QSurface = ...
        OpenGLSurface: QSurface = ...
        RasterGLSurface: QSurface = ...
        OpenVGSurface: QSurface = ...
        VulkanSurface: QSurface = ...
        MetalSurface: QSurface = ...

    class SurfaceClass(int):
        Window: QSurface = ...
        Offscreen: QSurface = ...

    @typing.overload
    def __init__(self, type: "QSurface.SurfaceClass") -> None:
        """
        https://doc.qt.io/qt-5/qsurface.html#QSurface

        **[protected] QSurface::QSurface(QSurface::SurfaceClass type )**

        Creates a surface with the given **type**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QSurface") -> None:
        """
        https://doc.qt.io/qt-5/qsurface.html#QSurface

        **[protected] QSurface::QSurface(QSurface::SurfaceClass type )**

        Creates a surface with the given **type**.
        """
        ...

    def supportsOpenGL(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsurface.html#supportsOpenGL

        **bool QSurface::supportsOpenGL() const**

        Returns true if the surface is OpenGL compatible and can be used in
        conjunction with **QOpenGLContext** ; otherwise returns false.

        This function was introduced in Qt 5.3.
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qsurface.html#size

        **[pure virtual] QSize QSurface::size() const**

        Returns the size of the surface in pixels.
        """
        ...

    def surfaceType(self) -> "QSurface.SurfaceType":
        """
        https://doc.qt.io/qt-5/qsurface.html#surfaceType

        **[pure virtual] QSurface::SurfaceType QSurface::surfaceType() const**

        Returns the type of the surface.
        """
        ...

    def format(self) -> "QSurfaceFormat":
        """
        https://doc.qt.io/qt-5/qsurface.html#format

        **[pure virtual] QSurfaceFormat QSurface::format() const**

        Returns the format of the surface.
        """
        ...

    def surfaceClass(self) -> "QSurface.SurfaceClass":
        """
        https://doc.qt.io/qt-5/qsurface.html#surfaceClass

        **QSurface::SurfaceClass QSurface::surfaceClass() const**

        Returns the surface class of this surface.
        """
        ...
