"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QScrollPrepareEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qscrollprepareevent.html

    **Detailed Description**

    The scroll prepare event is sent before scrolling (usually by **QScroller**
    ) is started. The object receiving this event should set **viewportSize** ,
    maxContentPos and **contentPos** . It also should accept this event to
    indicate that scrolling should be started.

    It is not guaranteed that a **QScrollEvent**  will be sent after an
    acceepted QScrollPrepareEvent, e.g. in a case where the maximum content
    position is (0,0).

    **See also** **QScrollEvent**  and **QScroller** .
    """

    @typing.overload
    def __init__(self, startPos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#QScrollPrepareEvent

        **QScrollPrepareEvent::QScrollPrepareEvent(const QPointF & startPos )**

        Creates new QScrollPrepareEvent The **startPos** is the position of a
        touch or mouse event that started the scrolling.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QScrollPrepareEvent") -> None:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#QScrollPrepareEvent

        **QScrollPrepareEvent::QScrollPrepareEvent(const QPointF & startPos )**

        Creates new QScrollPrepareEvent The **startPos** is the position of a
        touch or mouse event that started the scrolling.
        """
        ...

    def setContentPos(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#setContentPos

        **void QScrollPrepareEvent::setContentPos(const QPointF & pos )**

        Sets the current content position to **pos**.

        **See also** **contentPos** ().
        """
        ...

    def setContentPosRange(self, rect: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#setContentPosRange

        **void QScrollPrepareEvent::setContentPosRange(const QRectF & rect )**

        Sets the range of content coordinates to **rect**.

        **See also** **contentPosRange** ().
        """
        ...

    def setViewportSize(self, size: QtCore.QSizeF) -> None:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#setViewportSize

        **void QScrollPrepareEvent::setViewportSize(const QSizeF & size )**

        Sets the size of the area that is to be scrolled to **size**.

        **See also** **viewportSize** ().
        """
        ...

    def contentPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#contentPos

        **QPointF QScrollPrepareEvent::contentPos() const**

        Returns the current position of the content as set by **setContentPos**
        .

        **See also** **setContentPos** ().
        """
        ...

    def contentPosRange(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#contentPosRange

        **QRectF QScrollPrepareEvent::contentPosRange() const**

        Returns the range of coordinates for the content as set by
        **setContentPosRange** ().

        **See also** **setContentPosRange** ().
        """
        ...

    def viewportSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#viewportSize

        **QSizeF QScrollPrepareEvent::viewportSize() const**

        Returns size of the area that is to be scrolled as set by
        **setViewportSize**

        **See also** **setViewportSize** ().
        """
        ...

    def startPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qscrollprepareevent.html#startPos

        **QPointF QScrollPrepareEvent::startPos() const**

        Returns the position of the touch or mouse event that started the
        scrolling.
        """
        ...
