"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QScrollEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qscrollevent.html

    **Detailed Description**

    The scroll event is sent to indicate that the receiver should be scrolled.
    Usually the receiver should be something visual like **QWidget**  or
    **QGraphicsObject** .

    Some care should be taken that no conflicting QScrollEvents are sent from
    two sources. Using **QScroller::scrollTo**  is save however.

    **See also** **QScrollPrepareEvent**  and **QScroller** .
    """

    class ScrollState(int):
        ScrollStarted: QScrollEvent = ...
        ScrollUpdated: QScrollEvent = ...
        ScrollFinished: QScrollEvent = ...

    @typing.overload
    def __init__(
        self,
        contentPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        overshoot: typing.Union[QtCore.QPointF, QtCore.QPoint],
        scrollState: "QScrollEvent.ScrollState",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qscrollevent.html#QScrollEvent

        **QScrollEvent::QScrollEvent(const QPointF & contentPos , const QPointF
        & overshootDistance , QScrollEvent::ScrollState scrollState )**

        Creates a new QScrollEvent **contentPos** is the new content position,
        **overshootDistance** is the new overshoot distance while
        **scrollState** indicates if this scroll event is the first one, the
        last one or some event in between.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QScrollEvent") -> None:
        """
        https://doc.qt.io/qt-5/qscrollevent.html#QScrollEvent

        **QScrollEvent::QScrollEvent(const QPointF & contentPos , const QPointF
        & overshootDistance , QScrollEvent::ScrollState scrollState )**

        Creates a new QScrollEvent **contentPos** is the new content position,
        **overshootDistance** is the new overshoot distance while
        **scrollState** indicates if this scroll event is the first one, the
        last one or some event in between.
        """
        ...

    def scrollState(self) -> "QScrollEvent.ScrollState":
        """
        https://doc.qt.io/qt-5/qscrollevent.html#scrollState

        **QScrollEvent::ScrollState QScrollEvent::scrollState() const**

        Returns the current scroll state as a combination of ScrollStateFlag
        values. **ScrollStarted**  (or **ScrollFinished** ) will be set, if this
        scroll event is the first (or last) event in a scrolling activity.
        Please note that both values can be set at the same time, if the
        activity consists of a single **QScrollEvent** . All other scroll events
        in between will have their state set to **ScrollUpdated** .

        A widget could for example revert selections when scrolling is started
        and stopped.
        """
        ...

    def overshootDistance(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qscrollevent.html#overshootDistance

        **QPointF QScrollEvent::overshootDistance() const**

        Returns the new overshoot distance. See **QScroller**  for an
        explanation of the term overshoot.

        **See also** **QScroller** .
        """
        ...

    def contentPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qscrollevent.html#contentPos

        **QPointF QScrollEvent::contentPos() const**

        Returns the new scroll position.
        """
        ...
