"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QPalette(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpalette.html

    **Detailed Description**

    A palette consists of three color groups: **Active** , **Disabled** , and
    **Inactive**. All widgets in Qt contain a palette and use their palette to
    draw themselves. This makes the user interface easily configurable and
    easier to keep consistent.

    If you create a new widget we strongly recommend that you use the colors in
    the palette rather than hard-coding specific colors.

    The color groups:

    * The Active group is used for the window that has keyboard focus.
      * The
    Inactive group is used for other windows.
      * The Disabled group is used for
    widgets (not windows) that are disabled for some reason.

    Both active and inactive windows can contain disabled widgets. (Disabled
    widgets are often called **inaccessible** or **grayed out**.)

    In most styles, Active and Inactive look the same.

    Colors and brushes can be set for particular roles in any of a palette's
    color groups with **setColor** () and **setBrush** (). A color group
    contains a group of colors used by widgets for drawing themselves. We
    recommend that widgets use color group roles from the palette such as
    "foreground" and "base" rather than literal colors like "red" or
    "turquoise". The color roles are enumerated and defined in the **ColorRole**
    documentation.

    We strongly recommend that you use the default palette of the current style
    (returned by **QGuiApplication::palette** ()) and modify that as necessary.
    This is done by Qt's widgets when they are drawn.

    To modify a color group you call the functions **setColor** () and
    **setBrush** (), depending on whether you want a pure color or a pixmap
    pattern.

    There are also corresponding **color** () and **brush** () getters, and a
    commonly used convenience function to get the **ColorRole**  for the current
    **ColorGroup** : **window** (), **windowText** (), **base** (), etc.

    You can copy a palette using the copy constructor and test to see if two
    palettes are **identical** using **isCopyOf** ().

    QPalette is optimized by the use of **implicit sharing** , so it is very
    efficient to pass QPalette objects as arguments.

    **Warning:** Some styles do not use the palette for all drawing, for
    instance, if they make use of native theme engines. This is the case for
    both the Windows Vista and the macOS styles.

    **See also** **QApplication::setPalette** (), **QWidget::setPalette** (),
    and **QColor** .
    """

    class ColorRole(int):
        WindowText: QPalette = ...
        Foreground: QPalette = ...
        Button: QPalette = ...
        Light: QPalette = ...
        Midlight: QPalette = ...
        Dark: QPalette = ...
        Mid: QPalette = ...
        Text: QPalette = ...
        BrightText: QPalette = ...
        ButtonText: QPalette = ...
        Base: QPalette = ...
        Window: QPalette = ...
        Background: QPalette = ...
        Shadow: QPalette = ...
        Highlight: QPalette = ...
        HighlightedText: QPalette = ...
        Link: QPalette = ...
        LinkVisited: QPalette = ...
        AlternateBase: QPalette = ...
        ToolTipBase: QPalette = ...
        ToolTipText: QPalette = ...
        PlaceholderText: QPalette = ...
        NoRole: QPalette = ...
        NColorRoles: QPalette = ...

    class ColorGroup(int):
        Active: QPalette = ...
        Disabled: QPalette = ...
        Inactive: QPalette = ...
        NColorGroups: QPalette = ...
        Current: QPalette = ...
        All: QPalette = ...
        Normal: QPalette = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette

        **QPalette::QPalette()**

        Constructs a palette object that uses the application's default palette.

        **See also** **QApplication::setPalette** () and
        **QApplication::palette** ().
        """
        ...

    @typing.overload
    def __init__(
        self, button: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette-1

        **QPalette::QPalette(const QColor & button )**

        Constructs a palette from the **button** color. The other colors are
        automatically calculated, based on this color. `Window` will be the
        button color as well.
        """
        ...

    @typing.overload
    def __init__(self, button: QtCore.Qt.GlobalColor) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette-2

        **QPalette::QPalette(Qt::GlobalColor button )**

        Constructs a palette from the **button** color. The other colors are
        automatically calculated, based on this color. `Window` will be the
        button color as well.
        """
        ...

    @typing.overload
    def __init__(
        self,
        button: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient],
        background: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette-3

        **QPalette::QPalette(const QColor & button , const QColor & window )**

        Constructs a palette from a **button** color and a **window**. The other
        colors are automatically calculated, based on these colors.
        """
        ...

    @typing.overload
    def __init__(
        self,
        foreground: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        button: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        light: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        dark: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        mid: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        bright_text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        base: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        background: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette-4

        **QPalette::QPalette(const QBrush & windowText , const QBrush & button ,
        const QBrush & light , const QBrush & dark , const QBrush & mid , const
        QBrush & text , const QBrush & bright_text , const QBrush & base , const
        QBrush & window )**

        Constructs a palette. You can pass either brushes, pixmaps or plain
        colors for **windowText** , **button** , **light** , **dark** , **mid**
        , **text** , **bright_text** , **base** and **window**.

        **See also** **QBrush** .
        """
        ...

    @typing.overload
    def __init__(self, palette: "QPalette") -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette-6

        **QPalette::QPalette(const QPalette & p )**

        Constructs a copy of **p**.

        This constructor is fast thanks to **implicit sharing** .
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#QPalette-7

        **QPalette::QPalette(QPalette && other )**

        Move-constructs a QPalette instance, making it point at the same object
        that **other** was pointing to.

        After being moved from, you can only assign to or destroy **other**. Any
        other operation will result in undefined behavior.

        This function was introduced in Qt 5.4.
        """
        ...

    def swap(self, other: "QPalette") -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#swap

        **void QPalette::swap(QPalette & other )**

        Swaps this palette instance with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def cacheKey(self) -> int:
        """
        https://doc.qt.io/qt-5/qpalette.html#cacheKey

        **qint64 QPalette::cacheKey() const**

        Returns a number that identifies the contents of this **QPalette**
        object. Distinct **QPalette**  objects can have the same key if they
        refer to the same contents.

        The cacheKey() will change when the palette is altered.
        """
        ...

    def isBrushSet(self, cg: "QPalette.ColorGroup", cr: "QPalette.ColorRole") -> bool:
        """
        https://doc.qt.io/qt-5/qpalette.html#isBrushSet

        **bool QPalette::isBrushSet(QPalette::ColorGroup cg ,
        QPalette::ColorRole cr ) const**

        Returns `true` if the **ColorGroup**  **cg** and **ColorRole**  **cr**
        has been set previously on this palette; otherwise returns `false`.

        This function was introduced in Qt 4.2.

        **See also** **setBrush** ().
        """
        ...

    @typing.overload
    def setColor(
        self,
        acg: "QPalette.ColorGroup",
        acr: "QPalette.ColorRole",
        acolor: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#setColor

        **void QPalette::setColor(QPalette::ColorGroup group ,
        QPalette::ColorRole role , const QColor & color )**

        Sets the color in the specified color **group** , used for the given
        color **role** , to the specified solid **color**.

        **See also** **setBrush** (), **color** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def setColor(
        self,
        acr: "QPalette.ColorRole",
        acolor: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#setColor-1

        **void QPalette::setColor(QPalette::ColorRole role , const QColor &
        color )**

        This is an overloaded function.

        Sets the color used for the given color **role** , in all color groups,
        to the specified solid **color**.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def resolve(self, a0: "QPalette") -> "QPalette":
        """
        https://doc.qt.io/qt-5/qpalette.html#resolve

        **QPalette QPalette::resolve(const QPalette & other ) const**

        Returns a new **QPalette**  that is a union of this instance and
        **other**. Color roles set in this instance take precedence.
        """
        ...

    @typing.overload
    def resolve(self) -> int:
        """
        https://doc.qt.io/qt-5/qpalette.html#resolve

        **QPalette QPalette::resolve(const QPalette & other ) const**

        Returns a new **QPalette**  that is a union of this instance and
        **other**. Color roles set in this instance take precedence.
        """
        ...

    @typing.overload
    def resolve(self, mask: int) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#resolve

        **QPalette QPalette::resolve(const QPalette & other ) const**

        Returns a new **QPalette**  that is a union of this instance and
        **other**. Color roles set in this instance take precedence.
        """
        ...

    def isCopyOf(self, p: "QPalette") -> bool:
        """
        https://doc.qt.io/qt-5/qpalette.html#isCopyOf

        **bool QPalette::isCopyOf(const QPalette & p ) const**

        Returns `true` if this palette and **p** are copies of each other, i.e.
        one of them was created as a copy of the other and neither was
        subsequently modified; otherwise returns `false`. This is much stricter
        than equality.

        **See also** **operator=** () and **operator==** ().
        """
        ...

    def placeholderText(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#placeholderText

        **const QBrush &QPalette::placeholderText() const**

        Returns the placeholder text brush of the current color group.

        **Note:** Before Qt 5.12, the placeholder text color was hard-coded in
        the code as **QPalette::text** ().**color** () where an alpha of 128 was
        applied. We continue to support this behavior by default, unless you set
        your own brush. One can get back the original placeholder color setting
        the special **QBrush**  default constructor as placeholder brush.

        This function was introduced in Qt 5.12.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def toolTipText(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#toolTipText

        **const QBrush &QPalette::toolTipText() const**

        Returns the tool tip text brush of the current color group. This brush
        is used by **QToolTip**  and **QWhatsThis** .

        **Note:** Tool tips use the Inactive color group of **QPalette** ,
        because tool tips are not active windows.

        This function was introduced in Qt 4.4.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def toolTipBase(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#toolTipBase

        **const QBrush &QPalette::toolTipBase() const**

        Returns the tool tip base brush of the current color group. This brush
        is used by **QToolTip**  and **QWhatsThis** .

        **Note:** Tool tips use the Inactive color group of **QPalette** ,
        because tool tips are not active windows.

        This function was introduced in Qt 4.4.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def linkVisited(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#linkVisited

        **const QBrush &QPalette::linkVisited() const**

        Returns the visited link text brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def link(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#link

        **const QBrush &QPalette::link() const**

        Returns the unvisited link text brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def highlightedText(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#highlightedText

        **const QBrush &QPalette::highlightedText() const**

        Returns the highlighted text brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def highlight(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#highlight

        **const QBrush &QPalette::highlight() const**

        Returns the highlight brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def shadow(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#shadow

        **const QBrush &QPalette::shadow() const**

        Returns the shadow brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def buttonText(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#buttonText

        **const QBrush &QPalette::buttonText() const**

        Returns the button text foreground brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def brightText(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#brightText

        **const QBrush &QPalette::brightText() const**

        Returns the bright text foreground brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def midlight(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#midlight

        **const QBrush &QPalette::midlight() const**

        Returns the midlight brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def window(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#window

        **const QBrush &QPalette::window() const**

        Returns the window (general background) brush of the current color
        group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def alternateBase(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#alternateBase

        **const QBrush &QPalette::alternateBase() const**

        Returns the alternate base brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def base(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#base

        **const QBrush &QPalette::base() const**

        Returns the base brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def text(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#text

        **const QBrush &QPalette::text() const**

        Returns the text foreground brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def mid(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#mid

        **const QBrush &QPalette::mid() const**

        Returns the mid brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def dark(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#dark

        **const QBrush &QPalette::dark() const**

        Returns the dark brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def light(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#light

        **const QBrush &QPalette::light() const**

        Returns the light brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def button(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#button

        **const QBrush &QPalette::button() const**

        Returns the button brush of the current color group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def windowText(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#windowText

        **const QBrush &QPalette::windowText() const**

        Returns the window text (general foreground) brush of the current color
        group.

        **See also** **ColorRole**  and **brush** ().
        """
        ...

    def isEqual(self, cr1: "QPalette.ColorGroup", cr2: "QPalette.ColorGroup") -> bool:
        """
        https://doc.qt.io/qt-5/qpalette.html#isEqual

        **bool QPalette::isEqual(QPalette::ColorGroup cg1 , QPalette::ColorGroup
        cg2 ) const**

        Returns `true` (usually quickly) if color group **cg1** is equal to
        **cg2** ; otherwise returns `false`.
        """
        ...

    def setColorGroup(
        self,
        cr: "QPalette.ColorGroup",
        foreground: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        button: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        light: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        dark: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        mid: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        bright_text: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        base: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
        background: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#setColorGroup

        **void QPalette::setColorGroup(QPalette::ColorGroup cg , const QBrush &
        windowText , const QBrush & button , const QBrush & light , const QBrush
        & dark , const QBrush & mid , const QBrush & text , const QBrush &
        bright_text , const QBrush & base , const QBrush & window )**

        Sets a the group at **cg**. You can pass either brushes, pixmaps or
        plain colors for **windowText** , **button** , **light** , **dark** ,
        **mid** , **text** , **bright_text** , **base** and **window**.

        **See also** **QBrush** .
        """
        ...

    @typing.overload
    def setBrush(
        self,
        cg: "QPalette.ColorGroup",
        cr: "QPalette.ColorRole",
        brush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#setBrush

        **void QPalette::setBrush(QPalette::ColorRole role , const QBrush &
        brush )**

        Sets the brush for the given color **role** to the specified **brush**
        for all groups in the palette.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def setBrush(
        self,
        acr: "QPalette.ColorRole",
        abrush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#setBrush-1

        **void QPalette::setBrush(QPalette::ColorGroup group ,
        QPalette::ColorRole role , const QBrush & brush )**

        This is an overloaded function.

        Sets the brush in the specified color **group** , used for the given
        color **role** , to **brush**.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def brush(self, cg: "QPalette.ColorGroup", cr: "QPalette.ColorRole") -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#brush

        **const QBrush &QPalette::brush(QPalette::ColorGroup group ,
        QPalette::ColorRole role ) const**

        Returns the brush in the specified color **group** , used for the given
        color **role**.

        **See also** **color** (), **setBrush** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def brush(self, cr: "QPalette.ColorRole") -> QBrush:
        """
        https://doc.qt.io/qt-5/qpalette.html#brush-1

        **const QBrush &QPalette::brush(QPalette::ColorRole role ) const**

        This is an overloaded function.

        Returns the brush that has been set for the given color **role** in the
        current **ColorGroup** .

        **See also** **color** (), **setBrush** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def color(self, cg: "QPalette.ColorGroup", cr: "QPalette.ColorRole") -> QColor:
        """
        https://doc.qt.io/qt-5/qpalette.html#color

        **const QColor &QPalette::color(QPalette::ColorGroup group ,
        QPalette::ColorRole role ) const**

        Returns the color in the specified color **group** , used for the given
        color **role**.

        **See also** **brush** (), **setColor** (), and **ColorRole** .
        """
        ...

    @typing.overload
    def color(self, cr: "QPalette.ColorRole") -> QColor:
        """
        https://doc.qt.io/qt-5/qpalette.html#color-1

        **const QColor &QPalette::color(QPalette::ColorRole role ) const**

        This is an overloaded function.

        Returns the color that has been set for the given color **role** in the
        current **ColorGroup** .

        **See also** **brush** () and **ColorRole** .
        """
        ...

    def setCurrentColorGroup(self, cg: "QPalette.ColorGroup") -> None:
        """
        https://doc.qt.io/qt-5/qpalette.html#setCurrentColorGroup

        **void QPalette::setCurrentColorGroup(QPalette::ColorGroup cg )**

        Set the palette's current color group to **cg**.

        **See also** **currentColorGroup** ().
        """
        ...

    def currentColorGroup(self) -> "QPalette.ColorGroup":
        """
        https://doc.qt.io/qt-5/qpalette.html#currentColorGroup

        **QPalette::ColorGroup QPalette::currentColorGroup() const**

        Returns the palette's current color group.

        **See also** **setCurrentColorGroup** ().
        """
        ...
