"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QPaintEngine(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpaintengine.html

    **Detailed Description**

    Qt provides several premade implementations of QPaintEngine for the
    different painter backends we support. The primary paint engine provided is
    the raster paint engine, which contains a software rasterizer which supports
    the full feature set on all supported platforms. This is the default for
    painting on **QWidget** -based classes in e.g. on Windows, X11 and macOS, it
    is the backend for painting on **QImage**  and it is used as a fallback for
    paint engines that do not support a certain capability. In addition we
    provide QPaintEngine implementations for OpenGL (accessible through
    **QOpenGLWidget** ) and printing (which allows using **QPainter**  to draw
    on a **QPrinter**  object).

    If one wants to use **QPainter**  to draw to a different backend, one must
    subclass QPaintEngine and reimplement all its virtual functions. The
    QPaintEngine implementation is then made available by subclassing
    **QPaintDevice**  and reimplementing the virtual function
    **QPaintDevice::paintEngine** ().

    QPaintEngine is created and owned by the **QPaintDevice**  that created it.

    **See also** **QPainter** , **QPaintDevice::paintEngine** (), and **Paint
    System** .
    """

    class Type(int):
        X11: QPaintEngine = ...
        Windows: QPaintEngine = ...
        QuickDraw: QPaintEngine = ...
        CoreGraphics: QPaintEngine = ...
        MacPrinter: QPaintEngine = ...
        QWindowSystem: QPaintEngine = ...
        PostScript: QPaintEngine = ...
        OpenGL: QPaintEngine = ...
        Picture: QPaintEngine = ...
        SVG: QPaintEngine = ...
        Raster: QPaintEngine = ...
        Direct3D: QPaintEngine = ...
        Pdf: QPaintEngine = ...
        OpenVG: QPaintEngine = ...
        OpenGL2: QPaintEngine = ...
        PaintBuffer: QPaintEngine = ...
        Blitter: QPaintEngine = ...
        Direct2D: QPaintEngine = ...
        User: QPaintEngine = ...
        MaxUser: QPaintEngine = ...

    class PolygonDrawMode(int):
        OddEvenMode: QPaintEngine = ...
        WindingMode: QPaintEngine = ...
        ConvexMode: QPaintEngine = ...
        PolylineMode: QPaintEngine = ...

    class DirtyFlag(int):
        DirtyPen: QPaintEngine = ...
        DirtyBrush: QPaintEngine = ...
        DirtyBrushOrigin: QPaintEngine = ...
        DirtyFont: QPaintEngine = ...
        DirtyBackground: QPaintEngine = ...
        DirtyBackgroundMode: QPaintEngine = ...
        DirtyTransform: QPaintEngine = ...
        DirtyClipRegion: QPaintEngine = ...
        DirtyClipPath: QPaintEngine = ...
        DirtyHints: QPaintEngine = ...
        DirtyCompositionMode: QPaintEngine = ...
        DirtyClipEnabled: QPaintEngine = ...
        DirtyOpacity: QPaintEngine = ...
        AllDirty: QPaintEngine = ...

    class PaintEngineFeature(int):
        PrimitiveTransform: QPaintEngine = ...
        PatternTransform: QPaintEngine = ...
        PixmapTransform: QPaintEngine = ...
        PatternBrush: QPaintEngine = ...
        LinearGradientFill: QPaintEngine = ...
        RadialGradientFill: QPaintEngine = ...
        ConicalGradientFill: QPaintEngine = ...
        AlphaBlend: QPaintEngine = ...
        PorterDuff: QPaintEngine = ...
        PainterPaths: QPaintEngine = ...
        Antialiasing: QPaintEngine = ...
        BrushStroke: QPaintEngine = ...
        ConstantOpacity: QPaintEngine = ...
        MaskedBrush: QPaintEngine = ...
        PaintOutsidePaintEvent: QPaintEngine = ...
        PerspectiveTransform: QPaintEngine = ...
        BlendModes: QPaintEngine = ...
        ObjectBoundingModeGradients: QPaintEngine = ...
        RasterOpModes: QPaintEngine = ...
        AllFeatures: QPaintEngine = ...

    class PaintEngineFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QPaintEngine.PaintEngineFeatures", "QPaintEngine.PaintEngineFeature"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QPaintEngine.PaintEngineFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QPaintEngine.PaintEngineFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class DirtyFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QPaintEngine.DirtyFlags", "QPaintEngine.DirtyFlag"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QPaintEngine.DirtyFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QPaintEngine.DirtyFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self,
        features: typing.Union[
            "QPaintEngine.PaintEngineFeatures", "QPaintEngine.PaintEngineFeature"
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#QPaintEngine

        **QPaintEngine::QPaintEngine(QPaintEngine::PaintEngineFeatures caps =
        PaintEngineFeatures())**

        Creates a paint engine with the featureset specified by **caps**.
        """
        ...

    def hasFeature(
        self,
        feature: typing.Union[
            "QPaintEngine.PaintEngineFeatures", "QPaintEngine.PaintEngineFeature"
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#hasFeature

        **bool QPaintEngine::hasFeature(QPaintEngine::PaintEngineFeatures
        feature ) const**

        Returns `true` if the paint engine supports the specified **feature** ;
        otherwise returns `false`.
        """
        ...

    def painter(self) -> QPainter:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#painter

        **QPainter *QPaintEngine::painter() const**

        Returns the paint engine's painter.
        """
        ...

    def type(self) -> "QPaintEngine.Type":
        """
        https://doc.qt.io/qt-5/qpaintengine.html#type

        **[pure virtual] QPaintEngine::Type QPaintEngine::type() const**

        Reimplement this function to return the paint engine **Type** .
        """
        ...

    def paintDevice(self) -> QPaintDevice:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#paintDevice

        **QPaintDevice *QPaintEngine::paintDevice() const**

        Returns the device that this engine is painting on, if painting is
        active; otherwise returns `nullptr`.
        """
        ...

    def setPaintDevice(self, device: QPaintDevice) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#paintDevice

        **QPaintDevice *QPaintEngine::paintDevice() const**

        Returns the device that this engine is painting on, if painting is
        active; otherwise returns `nullptr`.
        """
        ...

    def drawImage(
        self,
        r: QtCore.QRectF,
        pm: QImage,
        sr: QtCore.QRectF,
        flags: typing.Union[
            QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawImage

        **[virtual] void QPaintEngine::drawImage(const QRectF & rectangle ,
        const QImage & image , const QRectF & sr , Qt::ImageConversionFlags
        flags = Qt::AutoColor)**

        Reimplement this function to draw the part of the **image** specified by
        the **sr** rectangle in the given **rectangle** using the given
        conversion flags **flags** , to convert it to a pixmap.
        """
        ...

    def drawTiledPixmap(
        self,
        r: QtCore.QRectF,
        pixmap: QPixmap,
        s: typing.Union[QtCore.QPointF, QtCore.QPoint],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawTiledPixmap

        **[virtual] void QPaintEngine::drawTiledPixmap(const QRectF & rect ,
        const QPixmap & pixmap , const QPointF & p )**

        Reimplement this function to draw the **pixmap** in the given **rect** ,
        starting at the given **p**. The pixmap will be drawn repeatedly until
        the **rect** is filled.
        """
        ...

    def drawTextItem(
        self, p: typing.Union[QtCore.QPointF, QtCore.QPoint], textItem: QTextItem
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawTextItem

        **[virtual] void QPaintEngine::drawTextItem(const QPointF & p , const
        QTextItem & textItem )**

        This function draws the text item **textItem** at position **p**. The
        default implementation of this function converts the text to a
        **QPainterPath**  and paints the resulting path.
        """
        ...

    def drawPixmap(self, r: QtCore.QRectF, pm: QPixmap, sr: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawPixmap

        **[pure virtual] void QPaintEngine::drawPixmap(const QRectF & r , const
        QPixmap & pm , const QRectF & sr )**

        Reimplement this function to draw the part of the **pm** specified by
        the **sr** rectangle in the given **r**.
        """
        ...

    @typing.overload
    def drawPolygon(
        self,
        points: typing.Union[QtCore.QPointF, QtCore.QPoint],
        mode: "QPaintEngine.PolygonDrawMode",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawPolygon

        **[virtual] void QPaintEngine::drawPolygon(const QPointF * points , int
        pointCount , QPaintEngine::PolygonDrawMode mode )**

        Reimplement this virtual function to draw the polygon defined by the
        **pointCount** first points in **points** , using mode **mode**.

        **Note:** At least one of the drawPolygon() functions must be
        reimplemented.
        """
        ...

    @typing.overload
    def drawPolygon(
        self, points: QtCore.QPoint, mode: "QPaintEngine.PolygonDrawMode"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawPolygon-1

        **[virtual] void QPaintEngine::drawPolygon(const QPoint * points , int
        pointCount , QPaintEngine::PolygonDrawMode mode )**

        This is an overloaded function.

        Reimplement this virtual function to draw the polygon defined by the
        **pointCount** first points in **points** , using mode **mode**.

        **Note:** At least one of the drawPolygon() functions must be
        reimplemented.
        """
        ...

    @typing.overload
    def drawPoints(self, points: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawPoints

        **[virtual] void QPaintEngine::drawPoints(const QPointF * points , int
        pointCount )**

        Draws the first **pointCount** points in the buffer **points**
        """
        ...

    @typing.overload
    def drawPoints(self, points: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawPoints-1

        **[virtual] void QPaintEngine::drawPoints(const QPoint * points , int
        pointCount )**

        Draws the first **pointCount** points in the buffer **points**

        The default implementation converts the first **pointCount** QPoints in
        **points** to QPointFs and calls the floating point version of
        drawPoints.
        """
        ...

    def drawPath(self, path: "QPainterPath") -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawPath

        **[virtual] void QPaintEngine::drawPath(const QPainterPath & path )**

        The default implementation ignores the **path** and does nothing.
        """
        ...

    @typing.overload
    def drawEllipse(self, r: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawEllipse

        **[virtual] void QPaintEngine::drawEllipse(const QRectF & rect )**

        Reimplement this function to draw the largest ellipse that can be
        contained within rectangle **rect**.

        The default implementation calls **drawPolygon** ().
        """
        ...

    @typing.overload
    def drawEllipse(self, r: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawEllipse-1

        **[virtual] void QPaintEngine::drawEllipse(const QRect & rect )**

        The default implementation of this function calls the floating point
        version of this function
        """
        ...

    @typing.overload
    def drawLines(self, lines: QtCore.QLine) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawLines

        **[virtual] void QPaintEngine::drawLines(const QLineF * lines , int
        lineCount )**

        The default implementation splits the list of lines in **lines** into
        **lineCount** separate calls to **drawPath** () or **drawPolygon** ()
        depending on the feature set of the paint engine.
        """
        ...

    @typing.overload
    def drawLines(self, lines: QtCore.QLineF) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawLines-1

        **[virtual] void QPaintEngine::drawLines(const QLine * lines , int
        lineCount )**

        This is an overloaded function.

        The default implementation converts the first **lineCount** lines in
        **lines** to a **QLineF**  and calls the floating point version of this
        function.
        """
        ...

    @typing.overload
    def drawRects(self, rects: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawRects

        **[virtual] void QPaintEngine::drawRects(const QRectF * rects , int
        rectCount )**

        Draws the first **rectCount** rectangles in the buffer **rects**. The
        default implementation of this function calls **drawPath** () or
        **drawPolygon** () depending on the feature set of the paint engine.
        """
        ...

    @typing.overload
    def drawRects(self, rects: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#drawRects-1

        **[virtual] void QPaintEngine::drawRects(const QRect * rects , int
        rectCount )**

        This is an overloaded function.

        The default implementation converts the first **rectCount** rectangles
        in the buffer **rects** to a **QRectF**  and calls the floating point
        version of this function.
        """
        ...

    def updateState(self, state: "QPaintEngineState") -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#updateState

        **[pure virtual] void QPaintEngine::updateState(const QPaintEngineState
        & state )**

        Reimplement this function to update the state of a paint engine.

        When implemented, this function is responsible for checking the paint
        engine's current **state** and update the properties that are changed.
        Use the **QPaintEngineState::state** () function to find out which
        properties that must be updated, then use the corresponding **get
        function**  to retrieve the current values for the given properties.

        **See also** **QPaintEngineState** .
        """
        ...

    def end(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#end

        **[pure virtual] bool QPaintEngine::end()**

        Reimplement this function to finish painting on the current paint
        device. Return true if painting was finished successfully; otherwise
        return false.

        **See also** **begin** () and **isActive** ().
        """
        ...

    def begin(self, pdev: QPaintDevice) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#begin

        **[pure virtual] bool QPaintEngine::begin(QPaintDevice * pdev )**

        Reimplement this function to initialise your paint engine when painting
        is to start on the paint device **pdev**. Return true if the
        initialization was successful; otherwise return false.

        **See also** **end** () and **isActive** ().
        """
        ...

    def setActive(self, newState: bool) -> None:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#setActive

        **void QPaintEngine::setActive(bool state )**

        Sets the active state of the paint engine to **state**.

        **See also** **isActive** ().
        """
        ...

    def isActive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintengine.html#isActive

        **bool QPaintEngine::isActive() const**

        Returns `true` if the paint engine is actively drawing; otherwise
        returns `false`.

        **See also** **setActive** ().
        """
        ...
