"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QOpenGLTexture(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qopengltexture.html

    **Detailed Description**

    QOpenGLTexture makes it easy to work with OpenGL textures and the myriad
    features and targets that they offer depending upon the capabilities of your
    OpenGL implementation.

    The typical usage pattern for QOpenGLTexture is

    * Instantiate the object specifying the texture target type
      * Set
    properties that affect the storage requirements e.g. storage format,
    dimensions
      * Allocate the server-side storage
      * Optionally upload pixel
    data
      * Optionally set any additional properties e.g. filtering and border
    options
      * Render with texture or render to texture

    In the common case of simply using a **QImage**  as the source of texture
    pixel data most of the above steps are performed automatically.

    // Prepare texture
        **QOpenGLTexture**  *texture = new **QOpenGLTexture**
    (**QImage** (fileName).mirrored());
    texture->setMinificationFilter(**QOpenGLTexture** ::LinearMipMapLinear);
    texture->setMagnificationFilter(**QOpenGLTexture** ::Linear);
        ...
        //
    Render with texture
        texture->bind();
        glDrawArrays(...);

    Note that the **QImage**  is mirrored vertically to account for the fact
    that OpenGL and **QImage**  use opposite directions for the y axis. Another
    option would be to transform your texture coordinates.
    """

    class ComparisonMode(int):
        CompareRefToTexture: QOpenGLTexture = ...
        CompareNone: QOpenGLTexture = ...

    class ComparisonFunction(int):
        CompareLessEqual: QOpenGLTexture = ...
        CompareGreaterEqual: QOpenGLTexture = ...
        CompareLess: QOpenGLTexture = ...
        CompareGreater: QOpenGLTexture = ...
        CompareEqual: QOpenGLTexture = ...
        CommpareNotEqual: QOpenGLTexture = ...
        CompareAlways: QOpenGLTexture = ...
        CompareNever: QOpenGLTexture = ...

    class CoordinateDirection(int):
        DirectionS: QOpenGLTexture = ...
        DirectionT: QOpenGLTexture = ...
        DirectionR: QOpenGLTexture = ...

    class WrapMode(int):
        Repeat: QOpenGLTexture = ...
        MirroredRepeat: QOpenGLTexture = ...
        ClampToEdge: QOpenGLTexture = ...
        ClampToBorder: QOpenGLTexture = ...

    class Filter(int):
        Nearest: QOpenGLTexture = ...
        Linear: QOpenGLTexture = ...
        NearestMipMapNearest: QOpenGLTexture = ...
        NearestMipMapLinear: QOpenGLTexture = ...
        LinearMipMapNearest: QOpenGLTexture = ...
        LinearMipMapLinear: QOpenGLTexture = ...

    class DepthStencilMode(int):
        DepthMode: QOpenGLTexture = ...
        StencilMode: QOpenGLTexture = ...

    class SwizzleValue(int):
        RedValue: QOpenGLTexture = ...
        GreenValue: QOpenGLTexture = ...
        BlueValue: QOpenGLTexture = ...
        AlphaValue: QOpenGLTexture = ...
        ZeroValue: QOpenGLTexture = ...
        OneValue: QOpenGLTexture = ...

    class SwizzleComponent(int):
        SwizzleRed: QOpenGLTexture = ...
        SwizzleGreen: QOpenGLTexture = ...
        SwizzleBlue: QOpenGLTexture = ...
        SwizzleAlpha: QOpenGLTexture = ...

    class Feature(int):
        ImmutableStorage: QOpenGLTexture = ...
        ImmutableMultisampleStorage: QOpenGLTexture = ...
        TextureRectangle: QOpenGLTexture = ...
        TextureArrays: QOpenGLTexture = ...
        Texture3D: QOpenGLTexture = ...
        TextureMultisample: QOpenGLTexture = ...
        TextureBuffer: QOpenGLTexture = ...
        TextureCubeMapArrays: QOpenGLTexture = ...
        Swizzle: QOpenGLTexture = ...
        StencilTexturing: QOpenGLTexture = ...
        AnisotropicFiltering: QOpenGLTexture = ...
        NPOTTextures: QOpenGLTexture = ...
        NPOTTextureRepeat: QOpenGLTexture = ...
        Texture1D: QOpenGLTexture = ...
        TextureComparisonOperators: QOpenGLTexture = ...
        TextureMipMapLevel: QOpenGLTexture = ...

    class PixelType(int):
        NoPixelType: QOpenGLTexture = ...
        Int8: QOpenGLTexture = ...
        UInt8: QOpenGLTexture = ...
        Int16: QOpenGLTexture = ...
        UInt16: QOpenGLTexture = ...
        Int32: QOpenGLTexture = ...
        UInt32: QOpenGLTexture = ...
        Float16: QOpenGLTexture = ...
        Float16OES: QOpenGLTexture = ...
        Float32: QOpenGLTexture = ...
        UInt32_RGB9_E5: QOpenGLTexture = ...
        UInt32_RG11B10F: QOpenGLTexture = ...
        UInt8_RG3B2: QOpenGLTexture = ...
        UInt8_RG3B2_Rev: QOpenGLTexture = ...
        UInt16_RGB5A1: QOpenGLTexture = ...
        UInt16_RGB5A1_Rev: QOpenGLTexture = ...
        UInt16_R5G6B5: QOpenGLTexture = ...
        UInt16_R5G6B5_Rev: QOpenGLTexture = ...
        UInt16_RGBA4: QOpenGLTexture = ...
        UInt16_RGBA4_Rev: QOpenGLTexture = ...
        UInt32_RGB10A2: QOpenGLTexture = ...
        UInt32_RGB10A2_Rev: QOpenGLTexture = ...
        UInt32_RGBA8: QOpenGLTexture = ...
        UInt32_RGBA8_Rev: QOpenGLTexture = ...
        UInt32_D24S8: QOpenGLTexture = ...
        Float32_D32_UInt32_S8_X24: QOpenGLTexture = ...

    class PixelFormat(int):
        NoSourceFormat: QOpenGLTexture = ...
        Red: QOpenGLTexture = ...
        RG: QOpenGLTexture = ...
        RGB: QOpenGLTexture = ...
        BGR: QOpenGLTexture = ...
        RGBA: QOpenGLTexture = ...
        BGRA: QOpenGLTexture = ...
        Red_Integer: QOpenGLTexture = ...
        RG_Integer: QOpenGLTexture = ...
        RGB_Integer: QOpenGLTexture = ...
        BGR_Integer: QOpenGLTexture = ...
        RGBA_Integer: QOpenGLTexture = ...
        BGRA_Integer: QOpenGLTexture = ...
        Depth: QOpenGLTexture = ...
        DepthStencil: QOpenGLTexture = ...
        Alpha: QOpenGLTexture = ...
        Luminance: QOpenGLTexture = ...
        LuminanceAlpha: QOpenGLTexture = ...
        Stencil: QOpenGLTexture = ...

    class CubeMapFace(int):
        CubeMapPositiveX: QOpenGLTexture = ...
        CubeMapNegativeX: QOpenGLTexture = ...
        CubeMapPositiveY: QOpenGLTexture = ...
        CubeMapNegativeY: QOpenGLTexture = ...
        CubeMapPositiveZ: QOpenGLTexture = ...
        CubeMapNegativeZ: QOpenGLTexture = ...

    class TextureFormat(int):
        NoFormat: QOpenGLTexture = ...
        R8_UNorm: QOpenGLTexture = ...
        RG8_UNorm: QOpenGLTexture = ...
        RGB8_UNorm: QOpenGLTexture = ...
        RGBA8_UNorm: QOpenGLTexture = ...
        R16_UNorm: QOpenGLTexture = ...
        RG16_UNorm: QOpenGLTexture = ...
        RGB16_UNorm: QOpenGLTexture = ...
        RGBA16_UNorm: QOpenGLTexture = ...
        R8_SNorm: QOpenGLTexture = ...
        RG8_SNorm: QOpenGLTexture = ...
        RGB8_SNorm: QOpenGLTexture = ...
        RGBA8_SNorm: QOpenGLTexture = ...
        R16_SNorm: QOpenGLTexture = ...
        RG16_SNorm: QOpenGLTexture = ...
        RGB16_SNorm: QOpenGLTexture = ...
        RGBA16_SNorm: QOpenGLTexture = ...
        R8U: QOpenGLTexture = ...
        RG8U: QOpenGLTexture = ...
        RGB8U: QOpenGLTexture = ...
        RGBA8U: QOpenGLTexture = ...
        R16U: QOpenGLTexture = ...
        RG16U: QOpenGLTexture = ...
        RGB16U: QOpenGLTexture = ...
        RGBA16U: QOpenGLTexture = ...
        R32U: QOpenGLTexture = ...
        RG32U: QOpenGLTexture = ...
        RGB32U: QOpenGLTexture = ...
        RGBA32U: QOpenGLTexture = ...
        R8I: QOpenGLTexture = ...
        RG8I: QOpenGLTexture = ...
        RGB8I: QOpenGLTexture = ...
        RGBA8I: QOpenGLTexture = ...
        R16I: QOpenGLTexture = ...
        RG16I: QOpenGLTexture = ...
        RGB16I: QOpenGLTexture = ...
        RGBA16I: QOpenGLTexture = ...
        R32I: QOpenGLTexture = ...
        RG32I: QOpenGLTexture = ...
        RGB32I: QOpenGLTexture = ...
        RGBA32I: QOpenGLTexture = ...
        R16F: QOpenGLTexture = ...
        RG16F: QOpenGLTexture = ...
        RGB16F: QOpenGLTexture = ...
        RGBA16F: QOpenGLTexture = ...
        R32F: QOpenGLTexture = ...
        RG32F: QOpenGLTexture = ...
        RGB32F: QOpenGLTexture = ...
        RGBA32F: QOpenGLTexture = ...
        RGB9E5: QOpenGLTexture = ...
        RG11B10F: QOpenGLTexture = ...
        RG3B2: QOpenGLTexture = ...
        R5G6B5: QOpenGLTexture = ...
        RGB5A1: QOpenGLTexture = ...
        RGBA4: QOpenGLTexture = ...
        RGB10A2: QOpenGLTexture = ...
        D16: QOpenGLTexture = ...
        D24: QOpenGLTexture = ...
        D24S8: QOpenGLTexture = ...
        D32: QOpenGLTexture = ...
        D32F: QOpenGLTexture = ...
        D32FS8X24: QOpenGLTexture = ...
        RGB_DXT1: QOpenGLTexture = ...
        RGBA_DXT1: QOpenGLTexture = ...
        RGBA_DXT3: QOpenGLTexture = ...
        RGBA_DXT5: QOpenGLTexture = ...
        R_ATI1N_UNorm: QOpenGLTexture = ...
        R_ATI1N_SNorm: QOpenGLTexture = ...
        RG_ATI2N_UNorm: QOpenGLTexture = ...
        RG_ATI2N_SNorm: QOpenGLTexture = ...
        RGB_BP_UNSIGNED_FLOAT: QOpenGLTexture = ...
        RGB_BP_SIGNED_FLOAT: QOpenGLTexture = ...
        RGB_BP_UNorm: QOpenGLTexture = ...
        SRGB8: QOpenGLTexture = ...
        SRGB8_Alpha8: QOpenGLTexture = ...
        SRGB_DXT1: QOpenGLTexture = ...
        SRGB_Alpha_DXT1: QOpenGLTexture = ...
        SRGB_Alpha_DXT3: QOpenGLTexture = ...
        SRGB_Alpha_DXT5: QOpenGLTexture = ...
        SRGB_BP_UNorm: QOpenGLTexture = ...
        DepthFormat: QOpenGLTexture = ...
        AlphaFormat: QOpenGLTexture = ...
        RGBFormat: QOpenGLTexture = ...
        RGBAFormat: QOpenGLTexture = ...
        LuminanceFormat: QOpenGLTexture = ...
        LuminanceAlphaFormat: QOpenGLTexture = ...
        S8: QOpenGLTexture = ...
        R11_EAC_UNorm: QOpenGLTexture = ...
        R11_EAC_SNorm: QOpenGLTexture = ...
        RG11_EAC_UNorm: QOpenGLTexture = ...
        RG11_EAC_SNorm: QOpenGLTexture = ...
        RGB8_ETC2: QOpenGLTexture = ...
        SRGB8_ETC2: QOpenGLTexture = ...
        RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture = ...
        SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture = ...
        RGBA8_ETC2_EAC: QOpenGLTexture = ...
        SRGB8_Alpha8_ETC2_EAC: QOpenGLTexture = ...
        RGB8_ETC1: QOpenGLTexture = ...
        RGBA_ASTC_4x4: QOpenGLTexture = ...
        RGBA_ASTC_5x4: QOpenGLTexture = ...
        RGBA_ASTC_5x5: QOpenGLTexture = ...
        RGBA_ASTC_6x5: QOpenGLTexture = ...
        RGBA_ASTC_6x6: QOpenGLTexture = ...
        RGBA_ASTC_8x5: QOpenGLTexture = ...
        RGBA_ASTC_8x6: QOpenGLTexture = ...
        RGBA_ASTC_8x8: QOpenGLTexture = ...
        RGBA_ASTC_10x5: QOpenGLTexture = ...
        RGBA_ASTC_10x6: QOpenGLTexture = ...
        RGBA_ASTC_10x8: QOpenGLTexture = ...
        RGBA_ASTC_10x10: QOpenGLTexture = ...
        RGBA_ASTC_12x10: QOpenGLTexture = ...
        RGBA_ASTC_12x12: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_4x4: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_5x4: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_5x5: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_6x5: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_6x6: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_8x5: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_8x6: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_8x8: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_10x5: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_10x6: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_10x8: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_10x10: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_12x10: QOpenGLTexture = ...
        SRGB8_Alpha8_ASTC_12x12: QOpenGLTexture = ...

    class TextureUnitReset(int):
        ResetTextureUnit: QOpenGLTexture = ...
        DontResetTextureUnit: QOpenGLTexture = ...

    class MipMapGeneration(int):
        GenerateMipMaps: QOpenGLTexture = ...
        DontGenerateMipMaps: QOpenGLTexture = ...

    class BindingTarget(int):
        BindingTarget1D: QOpenGLTexture = ...
        BindingTarget1DArray: QOpenGLTexture = ...
        BindingTarget2D: QOpenGLTexture = ...
        BindingTarget2DArray: QOpenGLTexture = ...
        BindingTarget3D: QOpenGLTexture = ...
        BindingTargetCubeMap: QOpenGLTexture = ...
        BindingTargetCubeMapArray: QOpenGLTexture = ...
        BindingTarget2DMultisample: QOpenGLTexture = ...
        BindingTarget2DMultisampleArray: QOpenGLTexture = ...
        BindingTargetRectangle: QOpenGLTexture = ...
        BindingTargetBuffer: QOpenGLTexture = ...

    class Target(int):
        Target1D: QOpenGLTexture = ...
        Target1DArray: QOpenGLTexture = ...
        Target2D: QOpenGLTexture = ...
        Target2DArray: QOpenGLTexture = ...
        Target3D: QOpenGLTexture = ...
        TargetCubeMap: QOpenGLTexture = ...
        TargetCubeMapArray: QOpenGLTexture = ...
        Target2DMultisample: QOpenGLTexture = ...
        Target2DMultisampleArray: QOpenGLTexture = ...
        TargetRectangle: QOpenGLTexture = ...
        TargetBuffer: QOpenGLTexture = ...

    class Features(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QOpenGLTexture.Features", "QOpenGLTexture.Feature"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QOpenGLTexture.Features") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QOpenGLTexture.Features":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, target: "QOpenGLTexture.Target") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#QOpenGLTexture

        **QOpenGLTexture::QOpenGLTexture(QOpenGLTexture::Target target )**

        Creates a QOpenGLTexture object that can later be bound to **target**.

        This does not create the underlying OpenGL texture object. Therefore,
        construction using this constructor does not require a valid current
        OpenGL context.
        """
        ...

    @typing.overload
    def __init__(
        self, image: QImage, genMipMaps: "QOpenGLTexture.MipMapGeneration" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#QOpenGLTexture-1

        **QOpenGLTexture::QOpenGLTexture(const QImage & image ,
        QOpenGLTexture::MipMapGeneration genMipMaps = GenerateMipMaps)**

        Creates a QOpenGLTexture object that can later be bound to the 2D
        texture target and contains the pixel data contained in **image**. If
        you wish to have a chain of mipmaps generated then set **genMipMaps** to
        `true` (this is the default).

        This does create the underlying OpenGL texture object. Therefore,
        construction using this constructor does require a valid current OpenGL
        context.
        """
        ...

    def comparisonMode(self) -> "QOpenGLTexture.ComparisonMode":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#comparisonMode

        **QOpenGLTexture::ComparisonMode QOpenGLTexture::comparisonMode()
        const**

        Returns the texture comparison mode set on this texture. By default, a
        texture has a **CompareNone**  comparison mode (i.e. comparisons are
        disabled).

        This function was introduced in Qt 5.5.

        **See also** **setComparisonMode** ().
        """
        ...

    def setComparisonMode(self, mode: "QOpenGLTexture.ComparisonMode") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setComparisonMode

        **void QOpenGLTexture::setComparisonMode(QOpenGLTexture::ComparisonMode
        mode )**

        Sets the texture comparison mode on this texture to **mode**. The
        texture comparison mode is used by shadow samplers when sampling a depth
        texture.

        This function was introduced in Qt 5.5.

        **See also** **comparisonMode** ().
        """
        ...

    def comparisonFunction(self) -> "QOpenGLTexture.ComparisonFunction":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#comparisonFunction

        **QOpenGLTexture::ComparisonFunction
        QOpenGLTexture::comparisonFunction() const**

        Returns the texture comparison operator set on this texture. By default,
        a texture has a **CompareLessEqual**  comparison function.

        This function was introduced in Qt 5.5.

        **See also** **setComparisonFunction** ().
        """
        ...

    def setComparisonFunction(
        self, function: "QOpenGLTexture.ComparisonFunction"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setComparisonFunction

        **void
        QOpenGLTexture::setComparisonFunction(QOpenGLTexture::ComparisonFunction
        function )**

        Sets the texture comparison function on this texture to **function**.
        The texture comparison function is used by shadow samplers when sampling
        a depth texture.

        This function was introduced in Qt 5.5.

        **See also** **comparisonFunction** ().
        """
        ...

    def isFixedSamplePositions(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isFixedSamplePositions

        **bool QOpenGLTexture::isFixedSamplePositions() const**

        Returns whether this texture uses a fixed pattern of multisample
        samples. If storage has not yet been allocated for this texture then
        this function returns the requested fixed sample position setting.

        For texture targets that do not support multisampling this will return
        `true`.

        **See also** **setFixedSamplePositions** () and **isStorageAllocated**
        ().
        """
        ...

    def setFixedSamplePositions(self, fixed: bool) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setFixedSamplePositions

        **void QOpenGLTexture::setFixedSamplePositions(bool fixed )**

        Sets whether the sample positions and number of samples used with a
        multisample capable texture target to **fixed**. If set to `true` the
        sample positions and number of samples used are the same for all texels
        in the image and will not depend upon the image size or internal format.
        This function should be called before storage is allocated for the
        texture.

        For targets that do not support multisampling this function has no
        effect.

        The default value is `true`.

        **See also** **isFixedSamplePositions** () and **isStorageAllocated**
        ().
        """
        ...

    def samples(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#samples

        **int QOpenGLTexture::samples() const**

        Returns the number of multisample sample points for this texture. If
        storage has not yet been allocated for this texture then this function
        returns the requested number of samples.

        For texture targets that do not support multisampling this will return
        0.

        **See also** **setSamples** () and **isStorageAllocated** ().
        """
        ...

    def setSamples(self, samples: int) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setSamples

        **void QOpenGLTexture::setSamples(int samples )**

        Sets the number of **samples** to allocate storage for when rendering to
        a multisample capable texture target. This function should be called
        before storage is allocated for the texture.

        For targets that do not support multisampling this function has no
        effect.

        **See also** **samples** () and **isStorageAllocated** ().
        """
        ...

    def target(self) -> "QOpenGLTexture.Target":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#target

        **QOpenGLTexture::Target QOpenGLTexture::target() const**

        Returns the binding target of this texture.

        This function was introduced in Qt 5.4.
        """
        ...

    def levelofDetailBias(self) -> float:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#levelofDetailBias

        **float QOpenGLTexture::levelofDetailBias() const**

        Returns the level of detail bias parameter.

        **See also** **setLevelofDetailBias** ().
        """
        ...

    def setLevelofDetailBias(self, bias: float) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setLevelofDetailBias

        **void QOpenGLTexture::setLevelofDetailBias(float bias )**

        Sets the level of detail bias to **bias**. Level of detail bias affects
        the point at which mipmapping levels change. Increasing values for level
        of detail bias makes the overall images blurrier or smoother. Decreasing
        values make the overall images sharper.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **levelofDetailBias** ().
        """
        ...

    def levelOfDetailRange(self) -> typing.Tuple[float, float]:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#levelOfDetailRange

        **QPair<float, float> QOpenGLTexture::levelOfDetailRange() const**

        Returns the minimum and maximum level of detail parameters.

        **See also** **setLevelOfDetailRange** (), **minimumLevelOfDetail** (),
        and **maximumLevelOfDetail** ().
        """
        ...

    def setLevelOfDetailRange(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setLevelOfDetailRange

        **void QOpenGLTexture::setLevelOfDetailRange(float min , float max )**

        Sets the minimum level of detail parameters to **min** and the maximum
        level to **max**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **levelOfDetailRange** (), **setMinimumLevelOfDetail** (),
        and **setMaximumLevelOfDetail** ().
        """
        ...

    def maximumLevelOfDetail(self) -> float:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#maximumLevelOfDetail

        **float QOpenGLTexture::maximumLevelOfDetail() const**

        Returns the maximum level of detail parameter.

        **See also** **setMaximumLevelOfDetail** (), **minimumLevelOfDetail**
        (), and **levelOfDetailRange** ().
        """
        ...

    def setMaximumLevelOfDetail(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMaximumLevelOfDetail

        **void QOpenGLTexture::setMaximumLevelOfDetail(float value )**

        Sets the maximum level of detail to **value**. This limits the selection
        of lowest resolution mipmap (highest mipmap level). The default value is
        1000.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **maximumLevelOfDetail** (), **setMinimumLevelOfDetail**
        (), and **setLevelOfDetailRange** ().
        """
        ...

    def minimumLevelOfDetail(self) -> float:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#minimumLevelOfDetail

        **float QOpenGLTexture::minimumLevelOfDetail() const**

        Returns the minimum level of detail parameter.

        **See also** **setMinimumLevelOfDetail** (), **maximumLevelOfDetail**
        (), and **levelOfDetailRange** ().
        """
        ...

    def setMinimumLevelOfDetail(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMinimumLevelOfDetail

        **void QOpenGLTexture::setMinimumLevelOfDetail(float value )**

        Sets the minimum level of detail to **value**. This limits the selection
        of highest resolution mipmap (lowest mipmap level). The default value is
        -1000.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **minimumLevelOfDetail** (), **setMaximumLevelOfDetail**
        (), and **setLevelOfDetailRange** ().
        """
        ...

    def borderColor(self) -> QColor:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#borderColor

        **QColor QOpenGLTexture::borderColor() const**

        Returns the borderColor of this texture.

        **See also** **setBorderColor** ().
        """
        ...

    def setBorderColor(
        self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setBorderColor

        **void QOpenGLTexture::setBorderColor(QColor color )**

        Sets the border color of the texture to **color**.

        **Note:** This function has no effect on Mac and Qt built for OpenGL ES
        2.

        **See also** **borderColor** ().
        """
        ...

    def wrapMode(
        self, direction: "QOpenGLTexture.CoordinateDirection"
    ) -> "QOpenGLTexture.WrapMode":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#wrapMode

        **QOpenGLTexture::WrapMode
        QOpenGLTexture::wrapMode(QOpenGLTexture::CoordinateDirection direction )
        const**

        Returns the wrap mode for the texture dimension **direction**.

        **See also** **setWrapMode** ().
        """
        ...

    @typing.overload
    def setWrapMode(self, mode: "QOpenGLTexture.WrapMode") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setWrapMode

        **void QOpenGLTexture::setWrapMode(QOpenGLTexture::WrapMode mode )**

        Sets the wrap (or repeat mode) for all texture dimentions to **mode**.

        **See also** **wrapMode** ().
        """
        ...

    @typing.overload
    def setWrapMode(
        self,
        direction: "QOpenGLTexture.CoordinateDirection",
        mode: "QOpenGLTexture.WrapMode",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setWrapMode-1

        **void QOpenGLTexture::setWrapMode(QOpenGLTexture::CoordinateDirection
        direction , QOpenGLTexture::WrapMode mode )**

        Holds the texture dimension **direction**.

        This is an overloaded function.
        """
        ...

    def maximumAnisotropy(self) -> float:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#maximumAnisotropy

        **float QOpenGLTexture::maximumAnisotropy() const**

        Returns the maximum level of anisotropy to be accounted for when
        performing texture lookups. This requires the
        GL_EXT_texture_filter_anisotropic extension.

        **See also** **setMaximumAnisotropy** ().
        """
        ...

    def setMaximumAnisotropy(self, anisotropy: float) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMaximumAnisotropy

        **void QOpenGLTexture::setMaximumAnisotropy(float anisotropy )**

        If your OpenGL implementation supports the
        GL_EXT_texture_filter_anisotropic extension this function sets the
        maximum anisotropy level to **anisotropy**.

        **See also** **maximumAnisotropy** ().
        """
        ...

    def minMagFilters(
        self,
    ) -> typing.Tuple["QOpenGLTexture.Filter", "QOpenGLTexture.Filter"]:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#minMagFilters

        **QPair<QOpenGLTexture::Filter, QOpenGLTexture::Filter>
        QOpenGLTexture::minMagFilters() const**

        Returns the current minification and magnification filters.

        **See also** **setMinMagFilters** ().
        """
        ...

    def setMinMagFilters(
        self,
        minificationFilter: "QOpenGLTexture.Filter",
        magnificationFilter: "QOpenGLTexture.Filter",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMinMagFilters

        **void QOpenGLTexture::setMinMagFilters(QOpenGLTexture::Filter
        minificationFilter , QOpenGLTexture::Filter magnificationFilter )**

        Sets the minification filter to **minificationFilter** and the
        magnification filter to **magnificationFilter**.

        **See also** **minMagFilters** (), **setMinificationFilter** (), and
        **setMagnificationFilter** ().
        """
        ...

    def magnificationFilter(self) -> "QOpenGLTexture.Filter":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#magnificationFilter

        **QOpenGLTexture::Filter QOpenGLTexture::magnificationFilter() const**

        Returns the magnification filter.

        **See also** **setMagnificationFilter** ().
        """
        ...

    def setMagnificationFilter(self, filter: "QOpenGLTexture.Filter") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMagnificationFilter

        **void QOpenGLTexture::setMagnificationFilter(QOpenGLTexture::Filter
        filter )**

        Sets the magnification filter to **filter**.

        **See also** **magnificationFilter** (), **setMinificationFilter** (),
        and **setMinMagFilters** ().
        """
        ...

    def minificationFilter(self) -> "QOpenGLTexture.Filter":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#minificationFilter

        **QOpenGLTexture::Filter QOpenGLTexture::minificationFilter() const**

        Returns the minification filter.

        **See also** **setMinificationFilter** ().
        """
        ...

    def setMinificationFilter(self, filter: "QOpenGLTexture.Filter") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMinificationFilter

        **void QOpenGLTexture::setMinificationFilter(QOpenGLTexture::Filter
        filter )**

        Sets the filter used for minification to **filter**.

        **See also** **minificationFilter** (), **setMagnificationFilter** (),
        and **setMinMagFilters** ().
        """
        ...

    def depthStencilMode(self) -> "QOpenGLTexture.DepthStencilMode":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#depthStencilMode

        **QOpenGLTexture::DepthStencilMode QOpenGLTexture::depthStencilMode()
        const**

        Returns the depth stencil mode for textures using a combined
        depth/stencil format.

        This function was introduced in Qt 5.4.

        **See also** **setDepthStencilMode** ().
        """
        ...

    def setDepthStencilMode(self, mode: "QOpenGLTexture.DepthStencilMode") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setDepthStencilMode

        **void
        QOpenGLTexture::setDepthStencilMode(QOpenGLTexture::DepthStencilMode
        mode )**

        If using a texture that has a combined depth/stencil format this
        function sets which component of the texture is accessed to **mode**.

        When the parameter is set to **DepthMode** , then accessing it from the
        shader will access the depth component as a single float, as normal. But
        when the parameter is set to **StencilMode** , the shader will access
        the stencil component.

        **Note:** This function has no effect on Mac and Qt built for OpenGL ES
        2.

        This function was introduced in Qt 5.4.

        **See also** **depthStencilMode** ().
        """
        ...

    def swizzleMask(
        self, component: "QOpenGLTexture.SwizzleComponent"
    ) -> "QOpenGLTexture.SwizzleValue":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#swizzleMask

        **QOpenGLTexture::SwizzleValue
        QOpenGLTexture::swizzleMask(QOpenGLTexture::SwizzleComponent component )
        const**

        Returns the swizzle mask for texture **component**.

        **See also** **setSwizzleMask** ().
        """
        ...

    @typing.overload
    def setSwizzleMask(
        self,
        component: "QOpenGLTexture.SwizzleComponent",
        value: "QOpenGLTexture.SwizzleValue",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setSwizzleMask

        **void QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleComponent
        component , QOpenGLTexture::SwizzleValue value )**

        GLSL shaders are able to reorder the components of the vec4 returned by
        texture functions. It is also desirable to be able to control this
        reordering from CPU side code. This is made possible by swizzle masks
        since OpenGL 3.3.

        Each component of the texture can be mapped to one of the
        **SwizzleValue**  options.

        This function maps **component** to the output **value**.

        **Note:** This function has no effect on Mac and Qt built for OpenGL ES
        2.

        **See also** **swizzleMask** ().
        """
        ...

    @typing.overload
    def setSwizzleMask(
        self,
        r: "QOpenGLTexture.SwizzleValue",
        g: "QOpenGLTexture.SwizzleValue",
        b: "QOpenGLTexture.SwizzleValue",
        a: "QOpenGLTexture.SwizzleValue",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setSwizzleMask-1

        **void QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleValue r ,
        QOpenGLTexture::SwizzleValue g , QOpenGLTexture::SwizzleValue b ,
        QOpenGLTexture::SwizzleValue a )**

        Parameters **r** , **g** , **b** , and **a** are values used for setting
        the colors red, green, blue, and the alpha value.

        This is an overloaded function.
        """
        ...

    @typing.overload
    def generateMipMaps(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#generateMipMaps

        **void QOpenGLTexture::generateMipMaps()**

        Generates mipmaps for this texture object from mipmap level 0. If you
        are using a texture target and filtering option that requires mipmaps
        and you have disabled automatic mipmap generation then you need to call
        this function or the overload to create the mipmap chain.

        **Note:** Mipmap generation is not supported for compressed textures
        with OpenGL ES.

        **See also** **setAutoMipMapGenerationEnabled** (), **setMipLevels** (),
        and **mipLevels** ().
        """
        ...

    @typing.overload
    def generateMipMaps(self, baseLevel: int, resetBaseLevel: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#generateMipMaps-1

        **void QOpenGLTexture::generateMipMaps(int baseLevel , bool
        resetBaseLevel = true)**

        Generates mipmaps for this texture object from mipmap level
        **baseLevel**. If you are using a texture target and filtering option
        that requires mipmaps and you have disabled automatic mipmap generation
        then you need to call this function or the overload to create the mipmap
        chain.

        The generation of mipmaps to above **baseLevel** is achieved by setting
        the mipmap base level to **baseLevel** and then generating the mipmap
        chain. If **resetBaseLevel** is `true`, then the baseLevel of the
        texture will be reset to its previous value.

        **See also** **setAutoMipMapGenerationEnabled** (), **setMipLevels** (),
        and **mipLevels** ().
        """
        ...

    def isAutoMipMapGenerationEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isAutoMipMapGenerationEnabled

        **bool QOpenGLTexture::isAutoMipMapGenerationEnabled() const**

        Returns whether auto mipmap generation is enabled for this texture
        object.

        **See also** **setAutoMipMapGenerationEnabled** () and
        **generateMipMaps** ().
        """
        ...

    def setAutoMipMapGenerationEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setAutoMipMapGenerationEnable
        d

        **void QOpenGLTexture::setAutoMipMapGenerationEnabled(bool enabled )**

        If **enabled** is `true`, enables automatic mipmap generation for this
        texture object to occur whenever the level 0 mipmap data is set via
        **setData** ().

        The automatic mipmap generation is enabled by default.

        **Note:** Mipmap generation is not supported for compressed textures
        with OpenGL ES 2.0.

        **See also** **isAutoMipMapGenerationEnabled** () and
        **generateMipMaps** ().
        """
        ...

    def mipLevelRange(self) -> typing.Tuple[int, int]:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#mipLevelRange

        **QPair<int, int> QOpenGLTexture::mipLevelRange() const**

        Returns the range of mipmap levels that can be used for texture lookups
        with this texture.

        **See also** **setMipLevelRange** (), **mipBaseLevel** (), and
        **mipMaxLevel** ().
        """
        ...

    def setMipLevelRange(self, baseLevel: int, maxLevel: int) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMipLevelRange

        **void QOpenGLTexture::setMipLevelRange(int baseLevel , int maxLevel )**

        Sets the range of mipmap levels that can be used for texture lookups
        with this texture to range from **baseLevel** to **maxLevel**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **setMipBaseLevel** (), **setMipMaxLevel** (), and
        **mipLevelRange** ().
        """
        ...

    def mipMaxLevel(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#mipMaxLevel

        **int QOpenGLTexture::mipMaxLevel() const**

        Returns the mipmap maximum level used for all texture lookups with this
        texture.

        **See also** **setMipMaxLevel** (), **mipBaseLevel** (), and
        **mipLevelRange** ().
        """
        ...

    def setMipMaxLevel(self, maxLevel: int) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMipMaxLevel

        **void QOpenGLTexture::setMipMaxLevel(int maxLevel )**

        Sets the maximum mipmap level used for all texture lookups with this
        texture to **maxLevel**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **mipMaxLevel** (), **setMipBaseLevel** (), and
        **setMipLevelRange** ().
        """
        ...

    def mipBaseLevel(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#mipBaseLevel

        **int QOpenGLTexture::mipBaseLevel() const**

        Returns the mipmap base level used for all texture lookups with this
        texture. The default is 0.

        **See also** **setMipBaseLevel** (), **mipMaxLevel** (), and
        **mipLevelRange** ().
        """
        ...

    def setMipBaseLevel(self, baseLevel: int) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMipBaseLevel

        **void QOpenGLTexture::setMipBaseLevel(int baseLevel )**

        Sets the base mipmap level used for all texture lookups with this
        texture to **baseLevel**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **mipBaseLevel** (), **setMipMaxLevel** (), and
        **setMipLevelRange** ().
        """
        ...

    @staticmethod
    def hasFeature(feature: "QOpenGLTexture.Feature") -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#hasFeature

        **[static] bool QOpenGLTexture::hasFeature(QOpenGLTexture::Feature
        feature )**

        Returns `true` if your OpenGL implementation and version supports the
        texture feature **feature**.
        """
        ...

    @typing.overload
    def setCompressedData(
        self,
        mipLevel: int,
        layer: int,
        cubeFace: "QOpenGLTexture.CubeMapFace",
        dataSize: int,
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setCompressedData

        **void QOpenGLTexture::setCompressedData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , int dataSize , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads compressed pixel **data** to **mipLevel** , array **layer** ,
        and **cubeFace**. The pixel transfer can optionally be controlled with
        **options**. The **dataSize** argument should specify the size of the
        data pointed to by **data**.

        If not using a compressed **format** () then you should use **setData**
        () instead of this function.

        This function was introduced in Qt 5.3.
        """
        ...

    @typing.overload
    def setCompressedData(
        self,
        mipLevel: int,
        layer: int,
        dataSize: int,
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setCompressedData-5

        **void QOpenGLTexture::setCompressedData(int mipLevel , int layer , int
        layerCount , QOpenGLTexture::CubeMapFace cubeFace , int dataSize , const
        void * data , const QOpenGLPixelTransferOptions *const options =
        nullptr)**

        This is an overloaded function.

        Parameter **layerCount** is the number of layers in a texture array that
        are being uploaded/populated by this call.

        This function was introduced in Qt 5.9.
        """
        ...

    @typing.overload
    def setCompressedData(
        self,
        mipLevel: int,
        dataSize: int,
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setCompressedData-6

        **void QOpenGLTexture::setCompressedData(int mipLevel , int layer , int
        dataSize , const void * data , const QOpenGLPixelTransferOptions *const
        options = nullptr)**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def setCompressedData(
        self,
        dataSize: int,
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setCompressedData-7

        **void QOpenGLTexture::setCompressedData(int mipLevel , int dataSize ,
        const void * data , const QOpenGLPixelTransferOptions *const options =
        nullptr)**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def setCompressedData(
        self,
        mipLevel: int,
        layer: int,
        layerCount: int,
        cubeFace: "QOpenGLTexture.CubeMapFace",
        dataSize: int,
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setCompressedData-8

        **void QOpenGLTexture::setCompressedData(int dataSize , const void *
        data , const QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def setData(
        self,
        mipLevel: int,
        layer: int,
        cubeFace: "QOpenGLTexture.CubeMapFace",
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData

        **void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads pixel **data** for this texture object **mipLevel** , array
        **layer** , and **cubeFace**. Storage must have been allocated before
        uploading pixel data. Some overloads of setData() will set appropriate
        dimensions, mipmap levels, and array layers and then allocate storage
        for you if they have enough information to do so. This will be noted in
        the function documentation.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        If using a compressed **format** () then you should use
        **setCompressedData** () instead of this function.

        This function was introduced in Qt 5.3.

        **See also** **setCompressedData** ().
        """
        ...

    @typing.overload
    def setData(
        self,
        mipLevel: int,
        layer: int,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData-5

        **void QOpenGLTexture::setData(int mipLevel , int layer , int layerCount
        , QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.

        Parameter **layerCount** is the number of layers in a texture array that
        are being uploaded/populated by this call.

        This function was introduced in Qt 5.9.
        """
        ...

    @typing.overload
    def setData(
        self,
        mipLevel: int,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData-6

        **void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This function was introduced in Qt 5.3.
        """
        ...

    @typing.overload
    def setData(
        self,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData-7

        **void QOpenGLTexture::setData(int mipLevel ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This function was introduced in Qt 5.3.
        """
        ...

    @typing.overload
    def setData(
        self, image: QImage, genMipMaps: "QOpenGLTexture.MipMapGeneration" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData-8

        **void QOpenGLTexture::setData(QOpenGLTexture::PixelFormat sourceFormat
        , QOpenGLTexture::PixelType sourceType , const void * data , const
        QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.

        This function was introduced in Qt 5.3.
        """
        ...

    @typing.overload
    def setData(
        self,
        mipLevel: int,
        layer: int,
        layerCount: int,
        cubeFace: "QOpenGLTexture.CubeMapFace",
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData-9

        **void QOpenGLTexture::setData(int xOffset , int yOffset , int zOffset ,
        int width , int height , int depth , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @typing.overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData-10

        **void QOpenGLTexture::setData(int xOffset , int yOffset , int zOffset ,
        int width , int height , int depth , int mipLevel ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image. The mip map level the sub image we want to
        update is specified with **mipLevel**.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @typing.overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData

        **void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads pixel **data** for this texture object **mipLevel** , array
        **layer** , and **cubeFace**. Storage must have been allocated before
        uploading pixel data. Some overloads of setData() will set appropriate
        dimensions, mipmap levels, and array layers and then allocate storage
        for you if they have enough information to do so. This will be noted in
        the function documentation.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        If using a compressed **format** () then you should use
        **setCompressedData** () instead of this function.

        This function was introduced in Qt 5.3.

        **See also** **setCompressedData** ().
        """
        ...

    @typing.overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        layer: int,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData

        **void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads pixel **data** for this texture object **mipLevel** , array
        **layer** , and **cubeFace**. Storage must have been allocated before
        uploading pixel data. Some overloads of setData() will set appropriate
        dimensions, mipmap levels, and array layers and then allocate storage
        for you if they have enough information to do so. This will be noted in
        the function documentation.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        If using a compressed **format** () then you should use
        **setCompressedData** () instead of this function.

        This function was introduced in Qt 5.3.

        **See also** **setCompressedData** ().
        """
        ...

    @typing.overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        layer: int,
        cubeFace: "QOpenGLTexture.CubeMapFace",
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData

        **void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads pixel **data** for this texture object **mipLevel** , array
        **layer** , and **cubeFace**. Storage must have been allocated before
        uploading pixel data. Some overloads of setData() will set appropriate
        dimensions, mipmap levels, and array layers and then allocate storage
        for you if they have enough information to do so. This will be noted in
        the function documentation.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        If using a compressed **format** () then you should use
        **setCompressedData** () instead of this function.

        This function was introduced in Qt 5.3.

        **See also** **setCompressedData** ().
        """
        ...

    @typing.overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        layer: int,
        cubeFace: "QOpenGLTexture.CubeMapFace",
        layerCount: int,
        sourceFormat: "QOpenGLTexture.PixelFormat",
        sourceType: "QOpenGLTexture.PixelType",
        data: PyQt5.sip.voidptr,
        options: typing.Optional[QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setData

        **void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads pixel **data** for this texture object **mipLevel** , array
        **layer** , and **cubeFace**. Storage must have been allocated before
        uploading pixel data. Some overloads of setData() will set appropriate
        dimensions, mipmap levels, and array layers and then allocate storage
        for you if they have enough information to do so. This will be noted in
        the function documentation.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        If using a compressed **format** () then you should use
        **setCompressedData** () instead of this function.

        This function was introduced in Qt 5.3.

        **See also** **setCompressedData** ().
        """
        ...

    def isTextureView(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isTextureView

        **bool QOpenGLTexture::isTextureView() const**

        Returns `true` if this texture object is actually a view onto another
        texture object.

        **See also** **createTextureView** ().
        """
        ...

    def createTextureView(
        self,
        target: "QOpenGLTexture.Target",
        viewFormat: "QOpenGLTexture.TextureFormat",
        minimumMipmapLevel: int,
        maximumMipmapLevel: int,
        minimumLayer: int,
        maximumLayer: int,
    ) -> "QOpenGLTexture":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#createTextureView

        **QOpenGLTexture
        *QOpenGLTexture::createTextureView(QOpenGLTexture::Target target ,
        QOpenGLTexture::TextureFormat viewFormat , int minimumMipmapLevel , int
        maximumMipmapLevel , int minimumLayer , int maximumLayer ) const**

        Attempts to create a texture view onto this texture. A texture view is
        somewhat analogous to a view in SQL in that it presents a restricted or
        reinterpreted view of the original data. Texture views do not allocate
        any more server-side storage, insted relying on the storage buffer of
        the source texture.

        Texture views are only available when using immutable storage. For more
        information on texture views see
        http://www.opengl.org/wiki/Texture_Storage#Texture_views.

        The **target** argument specifies the target to use for the view. Only
        some targets can be used depending upon the target of the original
        target. For e.g. a view onto a **Target1DArray**  texture can specify
        either **Target1DArray**  or **Target1D**  but for the latter the number
        of array layers specified with **minimumLayer** and **maximumLayer**
        must be exactly 1.

        Simpliar constraints apply for the **viewFormat**. See the above link
        and the specification for more details.

        The **minimumMipmapLevel** , **maximumMipmapLevel** , **minimumLayer** ,
        and **maximumLayer** arguments serve to restrict the parts of the
        texture accessible by the texture view.

        If creation of the texture view fails this function will return 0. If
        the function succeeds it will return a pointer to a new
        **QOpenGLTexture**  object that will return `true` from its
        **isTextureView** () function.

        **See also** **isTextureView** ().
        """
        ...

    def isStorageAllocated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isStorageAllocated

        **bool QOpenGLTexture::isStorageAllocated() const**

        Returns `true` if server-side storage for this texture as been
        allocated.

        The texture format, dimensions, mipmap levels and array layers cannot be
        altered once storage ihas been allocated.

        **See also** **allocateStorage** (), **setSize** (), **setMipLevels**
        (), **setLayers** (), and **setFormat** ().
        """
        ...

    @typing.overload
    def allocateStorage(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#allocateStorage

        **void QOpenGLTexture::allocateStorage()**

        Allocates server-side storage for this texture object taking into
        account, the format, dimensions, mipmap levels, array layers and cubemap
        faces.

        Once storage has been allocated it is no longer possible to change these
        properties.

        If supported **QOpenGLTexture**  makes use of immutable texture storage.

        Once storage has been allocated for the texture then pixel data can be
        uploaded via one of the **setData** () overloads.

        **Note:** If immutable texture storage is not available, then a default
        pixel format and pixel type will be used to create the mutable storage.
        You can use the other allocateStorage() overload to specify exactly the
        pixel format and the pixel type to use when allocating mutable storage;
        this is particulary useful under certain OpenGL ES implementations
        (notably, OpenGL ES 2), where the pixel format and the pixel type used
        at allocation time must perfectly match the format and the type passed
        to any subsequent **setData** () call.

        **See also** **isStorageAllocated** () and **setData** ().
        """
        ...

    @typing.overload
    def allocateStorage(
        self,
        pixelFormat: "QOpenGLTexture.PixelFormat",
        pixelType: "QOpenGLTexture.PixelType",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#allocateStorage-1

        **void QOpenGLTexture::allocateStorage(QOpenGLTexture::PixelFormat
        pixelFormat , QOpenGLTexture::PixelType pixelType )**

        Allocates server-side storage for this texture object taking into
        account, the format, dimensions, mipmap levels, array layers and cubemap
        faces.

        Once storage has been allocated it is no longer possible to change these
        properties.

        If supported **QOpenGLTexture**  makes use of immutable texture storage.
        However, if immutable texture storage is not available, then the
        specified **pixelFormat** and **pixelType** will be used to allocate
        mutable storage; note that in certain OpenGL implementations (notably,
        OpenGL ES 2) they must perfectly match the format and the type passed to
        any subsequent **setData** () call.

        Once storage has been allocated for the texture then pixel data can be
        uploaded via one of the **setData** () overloads.

        This function was introduced in Qt 5.5.

        **See also** **isStorageAllocated** () and **setData** ().
        """
        ...

    def faces(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#faces

        **int QOpenGLTexture::faces() const**

        Returns the number of faces for this texture. For cubemap and cubemap
        array type targets this will be 6.

        For non-cubemap type targets this will return 1.
        """
        ...

    def layers(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#layers

        **int QOpenGLTexture::layers() const**

        Returns the number of array layers for this texture. If storage has not
        yet been allocated for this texture then this function returns the
        requested number of array layers.

        For texture targets that do not support array layers this will return 1.

        **See also** **setLayers** () and **isStorageAllocated** ().
        """
        ...

    def setLayers(self, layers: int) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setLayers

        **void QOpenGLTexture::setLayers(int layers )**

        Sets the number of array **layers** to allocate storage for. This
        function should be called before storage is allocated for the texture.

        For targets that do not support array layers this function has no
        effect.

        **See also** **layers** () and **isStorageAllocated** ().
        """
        ...

    def maximumMipLevels(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#maximumMipLevels

        **int QOpenGLTexture::maximumMipLevels() const**

        Returns the maximum number of mipmap levels that this texture can have
        given the current dimensions.

        **See also** **setMipLevels** (), **mipLevels** (), and **setSize** ().
        """
        ...

    def mipLevels(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#mipLevels

        **int QOpenGLTexture::mipLevels() const**

        Returns the number of mipmap levels for this texture. If storage has not
        yet been allocated for this texture it returns the requested number of
        mipmap levels.

        **See also** **setMipLevels** (), **maximumMipLevels** (), and
        **isStorageAllocated** ().
        """
        ...

    def setMipLevels(self, levels: int) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setMipLevels

        **void QOpenGLTexture::setMipLevels(int levels )**

        For texture targets that support mipmaps, this function sets the
        requested number of mipmap **levels** to allocate storage for. This
        function should be called before storage is allocated for the texture.

        If the texture target does not support mipmaps this function has no
        effect.

        **See also** **mipLevels** (), **maximumMipLevels** (), and
        **isStorageAllocated** ().
        """
        ...

    def depth(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#depth

        **int QOpenGLTexture::depth() const**

        Returns the depth of a 3D texture.

        **See also** **width** (), **height** (), and **setSize** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#height

        **int QOpenGLTexture::height() const**

        Returns the height of a 2D or 3D texture.

        **See also** **width** (), **depth** (), and **setSize** ().
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#width

        **int QOpenGLTexture::width() const**

        Returns the width of a 1D, 2D or 3D texture.

        **See also** **height** (), **depth** (), and **setSize** ().
        """
        ...

    def setSize(self, width: int, height: int = ..., depth: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setSize

        **void QOpenGLTexture::setSize(int width , int height = 1, int depth =
        1)**

        Sets the dimensions of this texture object to **width** , **height** ,
        and **depth**. The default for each dimension is 1. The maximum
        allowable texture size is dependent upon your OpenGL implementation.
        Allocating storage for a texture less than the maximum size can still
        fail if your system is low on resources.

        If a non-power-of-two **width** , **height** or **depth** is provided
        and your OpenGL implementation doesn't have support for repeating non-
        power-of-two textures, then the wrap mode is automatically set to
        **ClampToEdge** .

        **See also** **width** (), **height** (), and **depth** ().
        """
        ...

    def format(self) -> "QOpenGLTexture.TextureFormat":
        """
        https://doc.qt.io/qt-5/qopengltexture.html#format

        **QOpenGLTexture::TextureFormat QOpenGLTexture::format() const**

        Returns the format of this texture object.

        **See also** **setFormat** ().
        """
        ...

    def setFormat(self, format: "QOpenGLTexture.TextureFormat") -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#setFormat

        **void QOpenGLTexture::setFormat(QOpenGLTexture::TextureFormat format
        )**

        Sets the format of this texture object to **format**. This function must
        be called before texture storage is allocated.

        Note that all formats may not be supported. The exact set of supported
        formats is dependent upon your OpenGL implementation and version.

        **See also** **format** () and **allocateStorage** ().
        """
        ...

    @typing.overload
    @staticmethod
    def boundTextureId(target: "QOpenGLTexture.BindingTarget") -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#boundTextureId

        **[static] GLuint
        QOpenGLTexture::boundTextureId(QOpenGLTexture::BindingTarget target )**

        Returns the **textureId**  of the texture that is bound to the
        **target** of the currently active texture unit.
        """
        ...

    @typing.overload
    @staticmethod
    def boundTextureId(unit: int, target: "QOpenGLTexture.BindingTarget") -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#boundTextureId-1

        **[static] GLuint QOpenGLTexture::boundTextureId(uint unit ,
        QOpenGLTexture::BindingTarget target )**

        Returns the **textureId**  of the texture that is bound to the
        **target** of the texture unit **unit**.
        """
        ...

    @typing.overload
    def isBound(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isBound

        **bool QOpenGLTexture::isBound() const**

        Returns `true` if this texture is bound to the corresponding target of
        the currently active texture unit.

        **See also** **bind** () and **release** ().
        """
        ...

    @typing.overload
    def isBound(self, unit: int) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isBound-1

        **bool QOpenGLTexture::isBound(uint unit )**

        Returns `true` if this texture is bound to the corresponding target of
        texture unit **unit**.

        **See also** **bind** () and **release** ().
        """
        ...

    @typing.overload
    def release(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#release

        **void QOpenGLTexture::release()**

        Unbinds this texture from the currently active texture unit.

        **See also** **bind** ().
        """
        ...

    @typing.overload
    def release(
        self, unit: int, reset: "QOpenGLTexture.TextureUnitReset" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#release-1

        **void QOpenGLTexture::release(uint unit ,
        QOpenGLTexture::TextureUnitReset reset = DontResetTextureUnit)**

        Unbinds this texture from texture unit **unit**.

        If parameter **reset** is `true` then this function will restore the
        active unit to the texture unit that was active upon entry.
        """
        ...

    @typing.overload
    def bind(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#bind

        **void QOpenGLTexture::bind()**

        Binds this texture to the currently active texture unit ready for
        rendering. Note that you do not need to bind **QOpenGLTexture**  objects
        in order to modify them as the implementation makes use of the
        EXT_direct_state_access extension where available and simulates it where
        it is not.

        **See also** **release** ().
        """
        ...

    @typing.overload
    def bind(self, unit: int, reset: "QOpenGLTexture.TextureUnitReset" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#bind-1

        **void QOpenGLTexture::bind(uint unit , QOpenGLTexture::TextureUnitReset
        reset = DontResetTextureUnit)**

        Binds this texture to texture unit **unit** ready for rendering. Note
        that you do not need to bind **QOpenGLTexture**  objects in order to
        modify them as the implementation makes use of the
        EXT_direct_state_access extension where available and simulates it where
        it is not.

        If parameter **reset** is `true` then this function will restore the
        active unit to the texture unit that was active upon entry.

        **See also** **release** ().
        """
        ...

    def textureId(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#textureId

        **GLuint QOpenGLTexture::textureId() const**

        Returns the name of the underlying OpenGL texture object or 0 if it has
        not yet been created.

        **See also** **create** (), **destroy** (), and **isCreated** ().
        """
        ...

    def isCreated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#isCreated

        **bool QOpenGLTexture::isCreated() const**

        Returns `true` if the underlying OpenGL texture object has been created.

        **See also** **create** (), **destroy** (), and **textureId** ().
        """
        ...

    def destroy(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#destroy

        **void QOpenGLTexture::destroy()**

        Destroys the underlying OpenGL texture object. This requires a current
        valid OpenGL context.

        **See also** **create** (), **isCreated** (), and **textureId** ().
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltexture.html#create

        **bool QOpenGLTexture::create()**

        Creates the underlying OpenGL texture object. This requires a current
        valid OpenGL context. If the texture object already exists, this
        function does nothing.

        Once the texture object is created you can obtain the object name from
        the **textureId** () function. This may be useful if you wish to make
        some raw OpenGL calls related to this texture.

        Normally it should not be necessary to call this function directly as
        all functions that set properties of the texture object implicitly call
        create() on your behalf.

        Returns `true` if the creation succeeded, otherwise returns `false`.

        **See also** **destroy** (), **isCreated** (), and **textureId** ().
        """
        ...
