"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QOpenGLContext(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qopenglcontext.html

    **Detailed Description**

    QOpenGLContext represents the OpenGL state of an underlying OpenGL context.
    To set up a context, set its screen and format such that they match those of
    the surface or surfaces with which the context is meant to be used, if
    necessary make it share resources with other contexts with
    **setShareContext** (), and finally call **create** (). Use the return value
    or **isValid** () to check if the context was successfully initialized.

    A context can be made current against a given surface by calling
    **makeCurrent** (). When OpenGL rendering is done, call **swapBuffers** ()
    to swap the front and back buffers of the surface, so that the newly
    rendered content becomes visible. To be able to support certain platforms,
    QOpenGLContext requires that you call **makeCurrent** () again before
    starting rendering a new frame, after calling **swapBuffers** ().

    If the context is temporarily not needed, such as when the application is
    not rendering, it can be useful to delete it in order to free resources. You
    can connect to the **aboutToBeDestroyed** () signal to clean up any
    resources that have been allocated with different ownership from the
    QOpenGLContext itself.

    Once a QOpenGLContext has been made current, you can render to it in a
    platform independent way by using Qt's OpenGL enablers such as
    **QOpenGLFunctions** , **QOpenGLBuffer** , **QOpenGLShaderProgram** , and
    **QOpenGLFramebufferObject** . It is also possible to use the platform's
    OpenGL API directly, without using the Qt enablers, although potentially at
    the cost of portability. The latter is necessary when wanting to use OpenGL
    1.x or OpenGL ES 1.x.

    For more information about the OpenGL API, refer to the official **OpenGL
    documentation** .

    For an example of how to use QOpenGLContext see the **OpenGL Window**
    example.

    **Thread Affinity**

    QOpenGLContext can be moved to a different thread with **moveToThread** ().
    Do not call **makeCurrent** () from a different thread than the one to which
    the QOpenGLContext object belongs. A context can only be current in one
    thread and against one surface at a time, and a thread only has one context
    current at a time.

    **Context Resource Sharing**

    Resources such as textures and vertex buffer objects can be shared between
    contexts. Use **setShareContext** () before calling **create** () to specify
    that the contexts should share these resources. QOpenGLContext internally
    keeps track of a **QOpenGLContextGroup**  object which can be accessed with
    **shareGroup** (), and which can be used to find all the contexts in a given
    share group. A share group consists of all contexts that have been
    successfully initialized and are sharing with an existing context in the
    share group. A non-sharing context has a share group consisting of a single
    context.

    **Default Framebuffer**

    On certain platforms, a framebuffer other than 0 might be the default frame
    buffer depending on the current surface. Instead of calling
    glBindFramebuffer(0), it is recommended that you use
    glBindFramebuffer(ctx->**defaultFramebufferObject** ()), to ensure that your
    application is portable between different platforms. However, if you use
    **QOpenGLFunctions::glBindFramebuffer** (), this is done automatically for
    you.

    **See also** **QOpenGLFunctions** , **QOpenGLBuffer** ,
    **QOpenGLShaderProgram** , and **QOpenGLFramebufferObject** .
    """

    class OpenGLModuleType(int):
        LibGL: QOpenGLContext = ...
        LibGLES: QOpenGLContext = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#QOpenGLContext

        **QOpenGLContext::QOpenGLContext(QObject * parent = nullptr)**

        Creates a new OpenGL context instance with parent object **parent**.

        Before it can be used you need to set the proper format and call
        **create** ().

        **See also** **create** () and **makeCurrent** ().
        """
        ...

    @staticmethod
    def globalShareContext() -> "QOpenGLContext":
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#globalShareContext

        **[static] QOpenGLContext *QOpenGLContext::globalShareContext()**

        Returns the application-wide shared OpenGL context, if present.
        Otherwise, returns `nullptr`.

        This is useful if you need to upload OpenGL objects (buffers, textures,
        etc.) before creating or showing a **QOpenGLWidget**  or
        **QQuickWidget** .

        **Note:** You must set the **Qt::AA_ShareOpenGLContexts**  flag on
        **QGuiApplication**  before creating the **QGuiApplication**  object,
        otherwise Qt may not create a global shared context.

        **Warning:** Do not attempt to make the context returned by this
        function current on any surface. Instead, you can create a new context
        which shares with the global one, and then make the new context current.

        This function was introduced in Qt 5.5.

        **See also** **Qt::AA_ShareOpenGLContexts** , **setShareContext** (),
        and **makeCurrent** ().
        """
        ...

    @staticmethod
    def supportsThreadedOpenGL() -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#supportsThreadedOpenGL

        **[static] bool QOpenGLContext::supportsThreadedOpenGL()**

        Returns `true` if the platform supports OpenGL rendering outside the
        main (gui) thread.

        The value is controlled by the platform plugin in use and may also
        depend on the graphics drivers.

        This function was introduced in Qt 5.5.
        """
        ...

    def nativeHandle(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#nativeHandle

        **QVariant QOpenGLContext::nativeHandle() const**

        Returns the native handle for the context.

        This function provides access to the **QOpenGLContext** 's underlying
        native context. The returned variant contains a platform-specific value
        type. These classes can be found in the module **QtPlatformHeaders** .

        On platforms where retrieving the native handle is not supported, or if
        neither **create** () nor **setNativeHandle** () was called, a null
        variant is returned.

        This function was introduced in Qt 5.4.

        **See also** **setNativeHandle** ().
        """
        ...

    def setNativeHandle(self, handle: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#setNativeHandle

        **void QOpenGLContext::setNativeHandle(const QVariant & handle )**

        Set the native handles for this context. When **create** () is called
        and a native handle is set, configuration settings, like **format** (),
        are ignored since this **QOpenGLContext**  will wrap an already created
        native context instead of creating a new one from scratch.

        On some platforms the native context handle is not sufficient and other
        related handles (for example, for a window or display) have to be
        provided in addition. Therefore **handle** is variant containing a
        platform-specific value type. These classes can be found in the
        **QtPlatformHeaders**  module.

        When **create** () is called with native handles set, **QOpenGLContext**
        does not take ownership of the handles, so destroying the
        **QOpenGLContext**  does not destroy the native context.

        **Note:** Some frameworks track the current context and surfaces
        internally. Making the adopted **QOpenGLContext**  current via Qt will
        have no effect on such other frameworks' internal state. Therefore a
        subsequent **makeCurrent**  done via the other framework may have no
        effect. It is therefore advisable to make explicit calls to make no
        context and surface current to reset the other frameworks' internal
        state after performing OpenGL operations via Qt.

        **Note:** Using foreign contexts with Qt windows and Qt contexts with
        windows and surfaces created by other frameworks may give unexpected
        results, depending on the platform, due to potential mismatches in
        context and window pixel formats. To make sure this does not happen,
        avoid making contexts and surfaces from different frameworks current
        together. Instead, prefer approaches based on context sharing where
        OpenGL resources like textures are accessible both from Qt's and the
        foreign framework's contexts.

        This function was introduced in Qt 5.4.

        **See also** **nativeHandle** ().
        """
        ...

    def isOpenGLES(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#isOpenGLES

        **bool QOpenGLContext::isOpenGLES() const**

        Returns true if the context is an OpenGL ES context.

        If the context has not yet been created, the result is based on the
        requested format set via **setFormat** ().

        This function was introduced in Qt 5.3.

        **See also** **create** (), **format** (), and **setFormat** ().
        """
        ...

    @staticmethod
    def openGLModuleType() -> "QOpenGLContext.OpenGLModuleType":
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#openGLModuleType

        **[static] QOpenGLContext::OpenGLModuleType
        QOpenGLContext::openGLModuleType()**

        Returns the underlying OpenGL implementation type.

        On platforms where the OpenGL implementation is not dynamically loaded,
        the return value is determined during compile time and never changes.

        **Note:** A desktop OpenGL implementation may be capable of creating ES-
        compatible contexts too. Therefore in most cases it is more appropriate
        to check **QSurfaceFormat::renderableType** () or use the convenience
        function **isOpenGLES** ().

        **Note:** This function requires that the **QGuiApplication**  instance
        is already created.

        This function was introduced in Qt 5.3.
        """
        ...

    @staticmethod
    def openGLModuleHandle() -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#openGLModuleHandle

        **[static] void *QOpenGLContext::openGLModuleHandle()**

        Returns the platform-specific handle for the OpenGL implementation that
        is currently in use. (for example, a HMODULE on Windows)

        On platforms that do not use dynamic GL switching, the return value is
        `nullptr`.

        The library might be GL-only, meaning that windowing system interface
        functions (for example EGL) may live in another, separate library.

        **Note:** This function requires that the **QGuiApplication**  instance
        is already created.

        This function was introduced in Qt 5.3.

        **See also** **openGLModuleType** ().
        """
        ...

    def versionFunctions(
        self, versionProfile: typing.Optional["QOpenGLVersionProfile"] = ...
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#versionFunctions

        **QAbstractOpenGLFunctions *QOpenGLContext::versionFunctions(const
        QOpenGLVersionProfile & versionProfile = QOpenGLVersionProfile())
        const**

        Returns a pointer to an object that provides access to all functions for
        the **versionProfile** of this context. There is no need to call
        QAbstractOpenGLFunctions::initializeOpenGLFunctions() as long as this
        context is current. It is also possible to call this function when the
        context is not current, but in that case it is the caller's
        responsibility to ensure proper initialization by calling
        QAbstractOpenGLFunctions::initializeOpenGLFunctions() afterwards.

        Usually one would use the template version of this function to
        automatically have the result cast to the correct type.
        """
        ...

    def hasExtension(
        self, extension: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#hasExtension

        **bool QOpenGLContext::hasExtension(const QByteArray & extension )
        const**

        Returns `true` if this OpenGL context supports the specified OpenGL
        **extension** , `false` otherwise.

        The context or a sharing context must be current.

        **See also** **extensions** ().
        """
        ...

    def extensions(self) -> typing.Set[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#extensions

        **QSet<QByteArray> QOpenGLContext::extensions() const**

        Returns the set of OpenGL extensions supported by this context.

        The context or a sharing context must be current.

        **See also** **hasExtension** ().
        """
        ...

    @staticmethod
    def areSharing(first: "QOpenGLContext", second: "QOpenGLContext") -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#areSharing

        **[static] bool QOpenGLContext::areSharing(QOpenGLContext * first ,
        QOpenGLContext * second )**

        Returns `true` if the **first** and **second** contexts are sharing
        OpenGL resources.
        """
        ...

    @staticmethod
    def currentContext() -> "QOpenGLContext":
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#currentContext

        **[static] QOpenGLContext *QOpenGLContext::currentContext()**

        Returns the last context which called **makeCurrent**  in the current
        thread, or `nullptr`, if no context is current.
        """
        ...

    def surface(self) -> QSurface:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#surface

        **QSurface *QOpenGLContext::surface() const**

        Returns the surface the context has been made current with.

        This is the surface passed as an argument to **makeCurrent** ().
        """
        ...

    def getProcAddress(
        self, procName: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#getProcAddress

        **QFunctionPointer QOpenGLContext::getProcAddress(const QByteArray &
        procName ) const**

        Resolves the function pointer to an OpenGL extension function,
        identified by **procName**

        Returns `nullptr` if no such function can be found.
        """
        ...

    def swapBuffers(self, surface: QSurface) -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#swapBuffers

        **void QOpenGLContext::swapBuffers(QSurface * surface )**

        Swap the back and front buffers of **surface**.

        Call this to finish a frame of OpenGL rendering, and make sure to call
        **makeCurrent** () again before issuing any further OpenGL commands, for
        example as part of a new frame.
        """
        ...

    def doneCurrent(self) -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#doneCurrent

        **void QOpenGLContext::doneCurrent()**

        Convenience function for calling **makeCurrent**  with a 0 surface.

        This results in no context being current in the current thread.

        **See also** **makeCurrent** () and **currentContext** ().
        """
        ...

    def makeCurrent(self, surface: QSurface) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#makeCurrent

        **bool QOpenGLContext::makeCurrent(QSurface * surface )**

        Makes the context current in the current thread, against the given
        **surface**. Returns `true` if successful; otherwise returns `false`.
        The latter may happen if the surface is not exposed, or the graphics
        hardware is not available due to e.g. the application being suspended.

        If **surface** is `nullptr` this is equivalent to calling
        **doneCurrent** ().

        Avoid calling this function from a different thread than the one the
        **QOpenGLContext**  instance lives in. If you wish to use
        **QOpenGLContext**  from a different thread you should first make sure
        it's not current in the current thread, by calling **doneCurrent** () if
        necessary. Then call **moveToThread** (otherThread) before using it in
        the other thread.

        By default Qt employs a check that enforces the above condition on the
        thread affinity. It is still possible to disable this check by setting
        the `Qt::AA_DontCheckOpenGLContextThreadAffinity` application attribute.
        Be sure to understand the consequences of using QObjects from outside
        the thread they live in, as explained in the **QObject thread affinity**
        documentation.

        **See also** **functions** (), **doneCurrent** (), and
        **Qt::AA_DontCheckOpenGLContextThreadAffinity** .
        """
        ...

    def defaultFramebufferObject(self) -> int:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#defaultFramebufferObject

        **GLuint QOpenGLContext::defaultFramebufferObject() const**

        Call this to get the default framebuffer object for the current surface.

        On some platforms (for instance, iOS) the default framebuffer object
        depends on the surface being rendered to, and might be different from 0.
        Thus, instead of calling glBindFramebuffer(0), you should call
        glBindFramebuffer(ctx->defaultFramebufferObject()) if you want your
        application to work across different Qt platforms.

        If you use the glBindFramebuffer() in **QOpenGLFunctions**  you do not
        have to worry about this, as it automatically binds the current
        context's defaultFramebufferObject() when 0 is passed.

        **Note:** Widgets that render via framebuffer objects, like
        **QOpenGLWidget**  and **QQuickWidget** , will override the value
        returned from this function when painting is active, because at that
        time the correct "default" framebuffer is the widget's associated
        backing framebuffer, not the platform-specific one belonging to the top-
        level window's surface. This ensures the expected behavior for this
        function and other classes relying on it (for example,
        **QOpenGLFramebufferObject::bindDefault** () or
        **QOpenGLFramebufferObject::release** ()).

        **See also** **QOpenGLFramebufferObject** .
        """
        ...

    def screen(self) -> "QScreen":
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#screen

        **QScreen *QOpenGLContext::screen() const**

        Returns the screen the context was created for.

        **See also** **setScreen** ().
        """
        ...

    def shareGroup(self) -> QOpenGLContextGroup:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#shareGroup

        **QOpenGLContextGroup *QOpenGLContext::shareGroup() const**

        Returns the share group this context belongs to.
        """
        ...

    def shareContext(self) -> "QOpenGLContext":
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#shareContext

        **QOpenGLContext *QOpenGLContext::shareContext() const**

        Returns the share context this context was created with.

        If the underlying platform was not able to support the requested
        sharing, this will return 0.

        **See also** **setShareContext** ().
        """
        ...

    def format(self) -> "QSurfaceFormat":
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#format

        **QSurfaceFormat QOpenGLContext::format() const**

        Returns the format of the underlying platform context, if **create** ()
        has been called.

        Otherwise, returns the requested format.

        The requested and the actual format may differ. Requesting a given
        OpenGL version does not mean the resulting context will target exactly
        the requested version. It is only guaranteed that the
        version/profile/options combination for the created context is
        compatible with the request, as long as the driver is able to provide
        such a context.

        For example, requesting an OpenGL version 3.x core profile context may
        result in an OpenGL 4.x core profile context. Similarly, a request for
        OpenGL 2.1 may result in an OpenGL 3.0 context with deprecated functions
        enabled. Finally, depending on the driver, unsupported versions may
        result in either a context creation failure or in a context for the
        highest supported version.

        Similar differences are possible in the buffer sizes, for example, the
        resulting context may have a larger depth buffer than requested. This is
        perfectly normal.

        **See also** **setFormat** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#isValid

        **bool QOpenGLContext::isValid() const**

        Returns if this context is valid, i.e. has been successfully created.

        On some platforms the return value of `false` for a context that was
        successfully created previously indicates that the OpenGL context was
        lost.

        The typical way to handle context loss scenarios in applications is to
        check via this function whenever **makeCurrent** () fails and returns
        `false`. If this function then returns `false`, recreate the underlying
        native OpenGL context by calling **create** (), call **makeCurrent** ()
        again and then reinitialize all OpenGL resources.

        On some platforms context loss situations is not something that can
        avoided. On others however, they may need to be opted-in to. This can be
        done by enabling **ResetNotification**  in the **QSurfaceFormat** . This
        will lead to setting `RESET_NOTIFICATION_STRATEGY_EXT` to
        `LOSE_CONTEXT_ON_RESET_EXT` in the underlying native OpenGL context.
        **QOpenGLContext**  will then monitor the status via
        `glGetGraphicsResetStatusEXT()` in every **makeCurrent** ().

        **See also** **create** ().
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#create

        **bool QOpenGLContext::create()**

        Attempts to create the OpenGL context with the current configuration.

        The current configuration includes the format, the share context, and
        the screen.

        If the OpenGL implementation on your system does not support the
        requested version of OpenGL context, then **QOpenGLContext**  will try
        to create the closest matching version. The actual created context
        properties can be queried using the **QSurfaceFormat**  returned by the
        **format** () function. For example, if you request a context that
        supports OpenGL 4.3 Core profile but the driver and/or hardware only
        supports version 3.2 Core profile contexts then you will get a 3.2 Core
        profile context.

        Returns `true` if the native context was successfully created and is
        ready to be used with **makeCurrent** (), **swapBuffers** (), etc.

        **Note:** If the context already exists, this function destroys the
        existing context first, and then creates a new one.

        **See also** **makeCurrent** () and **format** ().
        """
        ...

    def setScreen(self, screen: "QScreen") -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#setScreen

        **void QOpenGLContext::setScreen(QScreen * screen )**

        Sets the **screen** the OpenGL context should be valid for. You need to
        call **create** () before it takes effect.

        **See also** **screen** ().
        """
        ...

    def setShareContext(self, shareContext: "QOpenGLContext") -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#setShareContext

        **void QOpenGLContext::setShareContext(QOpenGLContext * shareContext )**

        Makes this context share textures, shaders, and other OpenGL resources
        with **shareContext**. You need to call **create** () before it takes
        effect.

        **See also** **shareContext** ().
        """
        ...

    def setFormat(self, format: "QSurfaceFormat") -> None:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#setFormat

        **void QOpenGLContext::setFormat(const QSurfaceFormat & format )**

        Sets the **format** the OpenGL context should be compatible with. You
        need to call **create** () before it takes effect.

        When the format is not explicitly set via this function, the format
        returned by **QSurfaceFormat::defaultFormat** () will be used. This
        means that when having multiple contexts, individual calls to this
        function can be replaced by one single call to
        **QSurfaceFormat::setDefaultFormat** () before creating the first
        context.

        **See also** **format** ().
        """
        ...

    @property
    def aboutToBeDestroyed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qopenglcontext.html#aboutToBeDestroyed

        **[signal] void QOpenGLContext::aboutToBeDestroyed()**

        This signal is emitted before the underlying native OpenGL context is
        destroyed, such that users may clean up OpenGL resources that might
        otherwise be left dangling in the case of shared OpenGL contexts.

        If you wish to make the context current in order to do clean-up, make
        sure to only connect to the signal using a direct connection.
        """
        ...
