"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QNativeGestureEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qnativegestureevent.html

    **Detailed Description**

    Native gesture events are generated by the operating system, typically by
    interpreting touch events. Gesture events are high-level events such as zoom
    or rotate.

    Event TypeDescriptionTouch sequence
    **Qt::ZoomNativeGesture**
    Magnification delta in percent.macOS: Two-finger pinch.
    **Qt::SmartZoomNativeGesture** Boolean magnification state.macOS: Two-finger
    douple tap (trackpad) / One-finger douple tap (magic mouse).
    **Qt::RotateNativeGesture** Rotation delta in degrees.macOS: Two-finger
    rotate.

    In addition, BeginNativeGesture and EndNativeGesture are sent before and
    after gesture event streams:

    BeginNativeGesture ZoomNativeGesture ZoomNativeGesture ZoomNativeGesture
    EndNativeGesture

    **See also** **Qt::NativeGestureType**  and **QGestureEvent** .
    """

    @typing.overload
    def __init__(
        self,
        type: QtCore.Qt.NativeGestureType,
        localPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        value: float,
        sequenceId: int,
        intArgument: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#QNativeGestureEvent-1

        **QNativeGestureEvent::QNativeGestureEvent(Qt::NativeGestureType type ,
        const QTouchDevice * device , const QPointF & localPos , const QPointF &
        windowPos , const QPointF & screenPos , qreal realValue , ulong
        sequenceId , quint64 intValue )**

        Constructs a native gesture event of type **type** originating from
        **device**.

        The points **localPos** , **windowPos** and **screenPos** specify the
        gesture position relative to the receiving widget or item, window, and
        screen, respectively.

        **realValue** is the macOS event parameter, **sequenceId** and
        **intValue** are the Windows event parameters.

        This function was introduced in Qt 5.10.
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: QtCore.Qt.NativeGestureType,
        dev: "QTouchDevice",
        localPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        value: float,
        sequenceId: int,
        intArgument: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#QNativeGestureEvent-1

        **QNativeGestureEvent::QNativeGestureEvent(Qt::NativeGestureType type ,
        const QTouchDevice * device , const QPointF & localPos , const QPointF &
        windowPos , const QPointF & screenPos , qreal realValue , ulong
        sequenceId , quint64 intValue )**

        Constructs a native gesture event of type **type** originating from
        **device**.

        The points **localPos** , **windowPos** and **screenPos** specify the
        gesture position relative to the receiving widget or item, window, and
        screen, respectively.

        **realValue** is the macOS event parameter, **sequenceId** and
        **intValue** are the Windows event parameters.

        This function was introduced in Qt 5.10.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QNativeGestureEvent") -> None:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#QNativeGestureEvent-1

        **QNativeGestureEvent::QNativeGestureEvent(Qt::NativeGestureType type ,
        const QTouchDevice * device , const QPointF & localPos , const QPointF &
        windowPos , const QPointF & screenPos , qreal realValue , ulong
        sequenceId , quint64 intValue )**

        Constructs a native gesture event of type **type** originating from
        **device**.

        The points **localPos** , **windowPos** and **screenPos** specify the
        gesture position relative to the receiving widget or item, window, and
        screen, respectively.

        **realValue** is the macOS event parameter, **sequenceId** and
        **intValue** are the Windows event parameters.

        This function was introduced in Qt 5.10.
        """
        ...

    def device(self) -> "QTouchDevice":
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#device

        **const QTouchDevice *QNativeGestureEvent::device() const**

        Returns the device.

        This function was introduced in Qt 5.10.
        """
        ...

    def screenPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#screenPos

        **const QPointF &QNativeGestureEvent::screenPos() const**

        Returns the position of the gesture as a **QPointF**  in screen
        coordinates.

        This function was introduced in Qt 5.2.
        """
        ...

    def windowPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#windowPos

        **const QPointF &QNativeGestureEvent::windowPos() const**

        Returns the position of the gesture as a **QPointF** , relative to the
        window that received the event.

        This function was introduced in Qt 5.2.
        """
        ...

    def localPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#localPos

        **const QPointF &QNativeGestureEvent::localPos() const**

        Returns the position of the gesture as a **QPointF** , relative to the
        widget or item that received the event.

        This function was introduced in Qt 5.2.
        """
        ...

    def globalPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#globalPos

        **const QPoint QNativeGestureEvent::globalPos() const**

        Returns the position of the gesture as a **QPointF**  in screen
        coordinates

        This function was introduced in Qt 5.2.
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#pos

        **const QPoint QNativeGestureEvent::pos() const**

        Returns the position of the mouse cursor, relative to the widget or item
        that received the event.

        This function was introduced in Qt 5.2.
        """
        ...

    def value(self) -> float:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#value

        **qreal QNativeGestureEvent::value() const**

        Returns the gesture value. The value should be interpreted based on the
        gesture type. For example, a Zoom gesture provides a scale factor while
        a Rotate gesture provides a rotation delta.

        This function was introduced in Qt 5.2.

        **See also** **QNativeGestureEvent**  and **gestureType** ().
        """
        ...

    def gestureType(self) -> QtCore.Qt.NativeGestureType:
        """
        https://doc.qt.io/qt-5/qnativegestureevent.html#gestureType

        **Qt::NativeGestureType QNativeGestureEvent::gestureType() const**

        Returns the gesture type.

        This function was introduced in Qt 5.2.
        """
        ...
