"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QMoveEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qmoveevent.html

    **Detailed Description**

    Move events are sent to widgets that have been moved to a new position
    relative to their parent.

    The event handler **QWidget::moveEvent** () receives move events.

    **See also** **QWidget::move** () and **QWidget::setGeometry** ().
    """

    @typing.overload
    def __init__(self, pos: QtCore.QPoint, oldPos: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-5/qmoveevent.html#QMoveEvent

        **QMoveEvent::QMoveEvent(const QPoint & pos , const QPoint & oldPos )**

        Constructs a move event with the new and old widget positions, **pos**
        and **oldPos** respectively.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QMoveEvent") -> None:
        """
        https://doc.qt.io/qt-5/qmoveevent.html#QMoveEvent

        **QMoveEvent::QMoveEvent(const QPoint & pos , const QPoint & oldPos )**

        Constructs a move event with the new and old widget positions, **pos**
        and **oldPos** respectively.
        """
        ...

    def oldPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qmoveevent.html#oldPos

        **const QPoint &QMoveEvent::oldPos() const**

        Returns the old position of the widget.
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qmoveevent.html#pos

        **const QPoint &QMoveEvent::pos() const**

        Returns the new position of the widget. This excludes the window frame
        for top level widgets.
        """
        ...
