"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QKeyEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qkeyevent.html

    **Detailed Description**

    Key events are sent to the widget with keyboard input focus when keys are
    pressed or released.

    A key event contains a special accept flag that indicates whether the
    receiver will handle the key event. This flag is set by default for
    **QEvent::KeyPress**  and **QEvent::KeyRelease** , so there is no need to
    call **accept** () when acting on a key event. For
    **QEvent::ShortcutOverride**  the receiver needs to explicitly accept the
    event to trigger the override. Calling **ignore** () on a key event will
    propagate it to the parent widget. The event is propagated up the parent
    widget chain until a widget accepts it or an event filter consumes it.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse and keyboard events for a widget.

    The event handlers **QWidget::keyPressEvent** (),
    **QWidget::keyReleaseEvent** (), **QGraphicsItem::keyPressEvent** () and
    **QGraphicsItem::keyReleaseEvent** () receive key events.

    **See also** **QFocusEvent**  and **QWidget::grabKeyboard** ().
    """

    @typing.overload
    def __init__(
        self,
        type: QtCore.QEvent.Type,
        key: int,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        nativeScanCode: int,
        nativeVirtualKey: int,
        nativeModifiers: int,
        text: str = ...,
        autorep: bool = ...,
        count: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#QKeyEvent

        **QKeyEvent::QKeyEvent(QEvent::Type type , int key ,
        Qt::KeyboardModifiers modifiers , const QString & text = QString(), bool
        autorep = false, ushort count = 1)**

        Constructs a key event object.

        The **type** parameter must be **QEvent::KeyPress** ,
        **QEvent::KeyRelease** , or **QEvent::ShortcutOverride** .

        Int **key** is the code for the **Qt::Key**  that the event loop should
        listen for. If **key** is 0, the event is not a result of a known key;
        for example, it may be the result of a compose sequence or keyboard
        macro. The **modifiers** holds the keyboard modifiers, and the given
        **text** is the Unicode text that the key generated. If **autorep** is
        true, **isAutoRepeat** () will be true. **count** is the number of keys
        involved in the event.
        """
        ...

    @typing.overload
    def __init__(
        self,
        type: QtCore.QEvent.Type,
        key: int,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        text: str = ...,
        autorep: bool = ...,
        count: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#QKeyEvent-1

        **QKeyEvent::QKeyEvent(QEvent::Type type , int key ,
        Qt::KeyboardModifiers modifiers , quint32 nativeScanCode , quint32
        nativeVirtualKey , quint32 nativeModifiers , const QString & text =
        QString(), bool autorep = false, ushort count = 1)**

        Constructs a key event object.

        The **type** parameter must be **QEvent::KeyPress** ,
        **QEvent::KeyRelease** , or **QEvent::ShortcutOverride** .

        Int **key** is the code for the **Qt::Key**  that the event loop should
        listen for. If **key** is 0, the event is not a result of a known key;
        for example, it may be the result of a compose sequence or keyboard
        macro. The **modifiers** holds the keyboard modifiers, and the given
        **text** is the Unicode text that the key generated. If **autorep** is
        true, **isAutoRepeat** () will be true. **count** is the number of keys
        involved in the event.

        In addition to the normal key event data, also contains
        **nativeScanCode** , **nativeVirtualKey** and **nativeModifiers**. This
        extra data is used by the shortcut system, to determine which shortcuts
        to trigger.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QKeyEvent") -> None:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#QKeyEvent

        **QKeyEvent::QKeyEvent(QEvent::Type type , int key ,
        Qt::KeyboardModifiers modifiers , const QString & text = QString(), bool
        autorep = false, ushort count = 1)**

        Constructs a key event object.

        The **type** parameter must be **QEvent::KeyPress** ,
        **QEvent::KeyRelease** , or **QEvent::ShortcutOverride** .

        Int **key** is the code for the **Qt::Key**  that the event loop should
        listen for. If **key** is 0, the event is not a result of a known key;
        for example, it may be the result of a compose sequence or keyboard
        macro. The **modifiers** holds the keyboard modifiers, and the given
        **text** is the Unicode text that the key generated. If **autorep** is
        true, **isAutoRepeat** () will be true. **count** is the number of keys
        involved in the event.
        """
        ...

    def nativeVirtualKey(self) -> int:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#nativeVirtualKey

        **quint32 QKeyEvent::nativeVirtualKey() const**

        Returns the native virtual key, or key sym of the key event. If the key
        event does not contain this data 0 is returned.

        Note: The native virtual key may be 0, even if the key event contains
        extended information.

        This function was introduced in Qt 4.2.
        """
        ...

    def nativeScanCode(self) -> int:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#nativeScanCode

        **quint32 QKeyEvent::nativeScanCode() const**

        Returns the native scan code of the key event. If the key event does not
        contain this data 0 is returned.

        Note: The native scan code may be 0, even if the key event contains
        extended information.

        Note: On macOS, this function is not useful, because there is no way to
        get the scan code from the system APIs. The function always returns 1
        (or 0 in the case explained above).

        This function was introduced in Qt 4.2.
        """
        ...

    def nativeModifiers(self) -> int:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#nativeModifiers

        **quint32 QKeyEvent::nativeModifiers() const**

        Returns the native modifiers of a key event. If the key event does not
        contain this data 0 is returned.

        Note: The native modifiers may be 0, even if the key event contains
        extended information.

        This function was introduced in Qt 4.2.
        """
        ...

    def matches(self, key: "QKeySequence.StandardKey") -> bool:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#matches

        **bool QKeyEvent::matches(QKeySequence::StandardKey key ) const**

        Returns `true` if the key event matches the given standard **key** ;
        otherwise returns `false`.

        This function was introduced in Qt 4.2.
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#count

        **int QKeyEvent::count() const**

        Returns the number of keys involved in this event. If **text** () is not
        empty, this is simply the length of the string.

        **See also** **Qt::WA_KeyCompression** .
        """
        ...

    def isAutoRepeat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#isAutoRepeat

        **bool QKeyEvent::isAutoRepeat() const**

        Returns `true` if this event comes from an auto-repeating key; returns
        `false` if it comes from an initial key press.

        Note that if the event is a multiple-key compressed event that is partly
        due to auto-repeat, this function could return either true or false
        indeterminately.
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#text

        **QString QKeyEvent::text() const**

        Returns the Unicode text that this key generated.

        Return values when modifier keys such as Shift, Control, Alt, and Meta
        are pressed differ among platforms and could return an empty string.

        **Note:****key** () will always return a valid value, independent of
        modifier keys.

        **See also** **Qt::WA_KeyCompression** .
        """
        ...

    def modifiers(self) -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#modifiers

        **Qt::KeyboardModifiers QKeyEvent::modifiers() const**

        Returns the keyboard modifier flags that existed immediately after the
        event occurred.

        **Warning:** This function cannot always be trusted. The user can
        confuse it by pressing both **Shift** keys simultaneously and releasing
        one of them, for example.

        **See also** **QGuiApplication::keyboardModifiers** ().
        """
        ...

    def key(self) -> int:
        """
        https://doc.qt.io/qt-5/qkeyevent.html#key

        **int QKeyEvent::key() const**

        Returns the code of the key that was pressed or released.

        See **Qt::Key**  for the list of keyboard codes. These codes are
        independent of the underlying window system. Note that this function
        does not distinguish between capital and non-capital letters, use the
        **text** () function (returning the Unicode text the key generated) for
        this purpose.

        A value of either 0 or **Qt::Key_unknown**  means that the event is not
        the result of a known key; for example, it may be the result of a
        compose sequence, a keyboard macro, or due to key event compression.

        **See also** **Qt::WA_KeyCompression** .
        """
        ...
