"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QImageIOHandler(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qimageiohandler.html

    **Detailed Description**

    Qt uses QImageIOHandler for reading and writing images through
    **QImageReader**  and **QImageWriter** . You can also derive from this class
    to write your own image format handler using Qt's plugin mechanism.

    Call **setDevice** () to assign a device to the handler, and **setFormat**
    () to assign a format to it. One QImageIOHandler may support more than one
    image format. **canRead** () returns `true` if an image can be read from the
    device, and **read** () and **write** () return true if reading or writing
    an image was completed successfully.

    QImageIOHandler also has support for animations formats, through the
    functions **loopCount** (), **imageCount** (), **nextImageDelay** () and
    **currentImageNumber** ().

    In order to determine what options an image handler supports, Qt will call
    **supportsOption** () and **setOption** (). Make sure to reimplement these
    functions if you can provide support for any of the options in the
    **ImageOption**  enum.

    To write your own image handler, you must at least reimplement **canRead**
    () and **read** (). Then create a **QImageIOPlugin**  that can create the
    handler. Finally, install your plugin, and **QImageReader**  and
    **QImageWriter**  will then automatically load the plugin, and start using
    it.

    **See also** **QImageIOPlugin** , **QImageReader** , and **QImageWriter** .
    """

    class Transformation(int):
        TransformationNone: QImageIOHandler = ...
        TransformationMirror: QImageIOHandler = ...
        TransformationFlip: QImageIOHandler = ...
        TransformationRotate180: QImageIOHandler = ...
        TransformationRotate90: QImageIOHandler = ...
        TransformationMirrorAndRotate90: QImageIOHandler = ...
        TransformationFlipAndRotate90: QImageIOHandler = ...
        TransformationRotate270: QImageIOHandler = ...

    class ImageOption(int):
        Size: QImageIOHandler = ...
        ClipRect: QImageIOHandler = ...
        Description: QImageIOHandler = ...
        ScaledClipRect: QImageIOHandler = ...
        ScaledSize: QImageIOHandler = ...
        CompressionRatio: QImageIOHandler = ...
        Gamma: QImageIOHandler = ...
        Quality: QImageIOHandler = ...
        Name: QImageIOHandler = ...
        SubType: QImageIOHandler = ...
        IncrementalReading: QImageIOHandler = ...
        Endianness: QImageIOHandler = ...
        Animation: QImageIOHandler = ...
        BackgroundColor: QImageIOHandler = ...
        SupportedSubTypes: QImageIOHandler = ...
        OptimizedWrite: QImageIOHandler = ...
        ProgressiveScanWrite: QImageIOHandler = ...
        ImageTransformation: QImageIOHandler = ...
        TransformedByDefault: QImageIOHandler = ...

    class Transformations(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QImageIOHandler.Transformations", "QImageIOHandler.Transformation"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QImageIOHandler.Transformations") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QImageIOHandler.Transformations":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#QImageIOHandler

        **QImageIOHandler::QImageIOHandler()**

        Constructs a QImageIOHandler object.
        """
        ...

    def currentImageRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#currentImageRect

        **[virtual] QRect QImageIOHandler::currentImageRect() const**

        Returns the rect of the current image. If no rect is defined for the
        image, and empty QRect() is returned.

        This function is useful for animations, where only parts of the frame
        may be updated at a time.
        """
        ...

    def currentImageNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#currentImageNumber

        **[virtual] int QImageIOHandler::currentImageNumber() const**

        For image formats that support animation, this function returns the
        sequence number of the current image in the animation. If this function
        is called before any image is **read** (), -1 is returned. The number of
        the first image in the sequence is 0.

        If the image format does not support animation, 0 is returned.

        **See also** **read** ().
        """
        ...

    def nextImageDelay(self) -> int:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#nextImageDelay

        **[virtual] int QImageIOHandler::nextImageDelay() const**

        For image formats that support animation, this function returns the
        number of milliseconds to wait until reading the next image. If the
        image format does not support animation, 0 is returned.
        """
        ...

    def imageCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#imageCount

        **[virtual] int QImageIOHandler::imageCount() const**

        For image formats that support animation, this function returns the
        number of images in the animation. If the image format does not support
        animation, or if it is unable to determine the number of images, 0 is
        returned.

        The default implementation returns 1 if **canRead** () returns `true`;
        otherwise 0 is returned.
        """
        ...

    def loopCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#loopCount

        **[virtual] int QImageIOHandler::loopCount() const**

        For image formats that support animation, this function returns the
        number of times the animation should loop. If the image format does not
        support animation, 0 is returned.
        """
        ...

    def jumpToImage(self, imageNumber: int) -> bool:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#jumpToImage

        **[virtual] bool QImageIOHandler::jumpToImage(int imageNumber )**

        For image formats that support animation, this function jumps to the
        image whose sequence number is **imageNumber**. The next call to
        **read** () will attempt to read this image.

        The default implementation does nothing, and returns `false`.
        """
        ...

    def jumpToNextImage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#jumpToNextImage

        **[virtual] bool QImageIOHandler::jumpToNextImage()**

        For image formats that support animation, this function jumps to the
        next image.

        The default implementation does nothing, and returns `false`.
        """
        ...

    def supportsOption(self, option: "QImageIOHandler.ImageOption") -> bool:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#supportsOption

        **[virtual] bool
        QImageIOHandler::supportsOption(QImageIOHandler::ImageOption option )
        const**

        Returns `true` if the **QImageIOHandler**  supports the option
        **option** ; otherwise returns `false`. For example, if the
        **QImageIOHandler**  supports the **Size**  option, supportsOption(Size)
        must return true.

        **See also** **setOption** () and **option** ().
        """
        ...

    def setOption(
        self, option: "QImageIOHandler.ImageOption", value: typing.Any
    ) -> None:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#setOption

        **[virtual] void QImageIOHandler::setOption(QImageIOHandler::ImageOption
        option , const QVariant & value )**

        Sets the option **option** with the value **value**.

        **See also** **option** () and **ImageOption** .
        """
        ...

    def option(self, option: "QImageIOHandler.ImageOption") -> typing.Any:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#option

        **[virtual] QVariant
        QImageIOHandler::option(QImageIOHandler::ImageOption option ) const**

        Returns the value assigned to **option** as a **QVariant** . The type of
        the value depends on the option. For example, option(Size) returns a
        **QSize**  variant.

        **See also** **setOption** () and **supportsOption** ().
        """
        ...

    def write(self, image: QImage) -> bool:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#write

        **[virtual] bool QImageIOHandler::write(const QImage & image )**

        Writes the image **image** to the assigned device. Returns `true` on
        success; otherwise returns `false`.

        The default implementation does nothing, and simply returns `false`.
        """
        ...

    def read(self, image: QImage) -> bool:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#read

        **[pure virtual] bool QImageIOHandler::read(QImage * image )**

        Read an image from the device, and stores it in **image**. Returns
        `true` if the image is successfully read; otherwise returns false.

        For image formats that support incremental loading, and for animation
        formats, the image handler can assume that **image** points to the
        previous frame.

        **See also** **canRead** ().
        """
        ...

    def canRead(self) -> bool:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#canRead

        **[pure virtual] bool QImageIOHandler::canRead() const**

        Returns `true` if an image can be read from the device (i.e., the image
        format is supported, the device can be read from and the initial header
        information suggests that the image can be read); otherwise returns
        `false`.

        When reimplementing canRead(), make sure that the I/O device (**device**
        ()) is left in its original state (e.g., by using peek() rather than
        **read** ()).

        **See also** **read** () and **QIODevice::peek** ().
        """
        ...

    def format(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#format

        **QByteArray QImageIOHandler::format() const**

        Returns the format that is currently assigned to **QImageIOHandler** .
        If no format has been assigned, an empty string is returned.

        **See also** **setFormat** ().
        """
        ...

    def setFormat(
        self, format: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#setFormat

        **void QImageIOHandler::setFormat(const QByteArray & format )**

        Sets the format of the **QImageIOHandler**  to **format**. The format is
        most useful for handlers that support multiple image formats.

        **See also** **format** ().
        """
        ...

    def device(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#device

        **QIODevice *QImageIOHandler::device() const**

        Returns the device currently assigned to the **QImageIOHandler** . If
        not device has been assigned, `nullptr` is returned.

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qimageiohandler.html#setDevice

        **void QImageIOHandler::setDevice(QIODevice * device )**

        Sets the device of the **QImageIOHandler**  to **device**. The image
        handler will use this device when reading and writing images.

        The device can only be set once and must be set before calling
        **canRead** (), **read** (), **write** (), etc. If you need to read
        multiple files, construct multiple instances of the appropriate
        **QImageIOHandler**  subclass.

        **See also** **device** ().
        """
        ...
