"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QFocusEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qfocusevent.html

    **Detailed Description**

    Focus events are sent to widgets when the keyboard input focus changes.
    Focus events occur due to mouse actions, key presses (such as **Tab** or
    **Backtab** ), the window system, popup menus, keyboard shortcuts, or other
    application-specific reasons. The reason for a particular focus event is
    returned by **reason** () in the appropriate event handler.

    The event handlers **QWidget::focusInEvent** (), **QWidget::focusOutEvent**
    (), **QGraphicsItem::focusInEvent**  and **QGraphicsItem::focusOutEvent** ()
    receive focus events.

    **See also** **QWidget::setFocus** (), **QWidget::setFocusPolicy** (), and
    **Keyboard Focus in Widgets** .
    """

    @typing.overload
    def __init__(
        self, type: QtCore.QEvent.Type, reason: QtCore.Qt.FocusReason = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfocusevent.html#QFocusEvent

        **QFocusEvent::QFocusEvent(QEvent::Type type , Qt::FocusReason reason =
        Qt::OtherFocusReason)**

        Constructs a focus event object.

        The **type** parameter must be either **QEvent::FocusIn**  or
        **QEvent::FocusOut** . The **reason** describes the cause of the change
        in focus.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QFocusEvent") -> None:
        """
        https://doc.qt.io/qt-5/qfocusevent.html#QFocusEvent

        **QFocusEvent::QFocusEvent(QEvent::Type type , Qt::FocusReason reason =
        Qt::OtherFocusReason)**

        Constructs a focus event object.

        The **type** parameter must be either **QEvent::FocusIn**  or
        **QEvent::FocusOut** . The **reason** describes the cause of the change
        in focus.
        """
        ...

    def reason(self) -> QtCore.Qt.FocusReason:
        """
        https://doc.qt.io/qt-5/qfocusevent.html#reason

        **Qt::FocusReason QFocusEvent::reason() const**

        Returns the reason for this focus event.
        """
        ...

    def lostFocus(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfocusevent.html#lostFocus

        **bool QFocusEvent::lostFocus() const**

        Returns `true` if **type** () is **QEvent::FocusOut** ; otherwise
        returns false.
        """
        ...

    def gotFocus(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfocusevent.html#gotFocus

        **bool QFocusEvent::gotFocus() const**

        Returns `true` if **type** () is **QEvent::FocusIn** ; otherwise returns
        false.
        """
        ...
