"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QFileOpenEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qfileopenevent.html

    **Detailed Description**

    File open events will be sent to the **QApplication::instance** () when the
    operating system requests that a file or URL should be opened. This is a
    high-level event that can be caused by different user actions depending on
    the user's desktop environment; for example, double clicking on an file icon
    in the Finder on macOS.

    This event is only used to notify the application of a request. It may be
    safely ignored.

    **Note:** This class is currently supported for macOS only.

    **macOS Example**

    In order to trigger the event on macOS, the application must be configured
    to let the OS know what kind of file(s) it should react on.

    For example, the following `Info.plist` file declares that the application
    can act as a viewer for files with a PNG extension:

    <?xml version="1.0" encoding="UTF-8"?>
        <!DOCTYPE plist PUBLIC
    "-//Apple//DTD PLIST 1.0//EN"
    "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
        <plist version="1.0">
    <dict>
            <key>CFBundleDocumentTypes</key>
            <array>
    <dict>
                    <key>CFBundleTypeExtensions</key>
    <array>
                        <string>png</string>
                    </array>
    <key>CFBundleTypeRole</key>
                    <string>Viewer</string>
    </dict>
            </array>
        </dict>
        </plist>

    The following implementation of a **QApplication**  subclass prints the path
    to the file that was, for example, dropped on the Dock icon of the
    application.

    #include <QApplication>
        #include <QFileOpenEvent>
        #include <QtDebug>
    class MyApplication : public **QApplication**
        {
        public:
    MyApplication(int &argc, char **argv)
                : **QApplication** (argc,
    argv)
            {
            }

            bool event(**QEvent**  *event)
    override
            {
                if (event->type() == **QEvent** ::FileOpen) {
    QFileOpenEvent *openEvent = static_cast<QFileOpenEvent *>(event);
    **qDebug** () << "Open file" << openEvent->file();
                }
    return **QApplication** ::event(event);
            }
        };
    """

    def openFile(
        self,
        file: QtCore.QFile,
        flags: typing.Union[QtCore.QIODevice.OpenMode, QtCore.QIODevice.OpenModeFlag],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfileopenevent.html#openFile

        **bool QFileOpenEvent::openFile(QFile & file , QIODevice::OpenMode flags
        ) const**

        Opens a **QFile**  on the **file** referenced by this event in the mode
        specified by **flags**. Returns `true` if successful; otherwise returns
        `false`.

        This is necessary as some files cannot be opened by name, but require
        specific information stored in this event.

        This function was introduced in Qt 4.8.
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qfileopenevent.html#url

        **QUrl QFileOpenEvent::url() const**

        Returns the url that is being opened.

        This function was introduced in Qt 4.6.
        """
        ...

    def file(self) -> str:
        """
        https://doc.qt.io/qt-5/qfileopenevent.html#file

        **QString QFileOpenEvent::file() const**

        Returns the file that is being opened.
        """
        ...
