"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QEnterEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qenterevent.html

    **Detailed Description**

    Enter events occur when the mouse cursor enters a window or a widget.
    """

    @typing.overload
    def __init__(
        self,
        localPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        windowPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        screenPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qenterevent.html#QEnterEvent

        **QEnterEvent::QEnterEvent(const QPointF & localPos , const QPointF &
        windowPos , const QPointF & screenPos )**

        Constructs an enter event object.

        The points **localPos** , **windowPos** and **screenPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen, respectively.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QEnterEvent") -> None:
        """
        https://doc.qt.io/qt-5/qenterevent.html#QEnterEvent

        **QEnterEvent::QEnterEvent(const QPointF & localPos , const QPointF &
        windowPos , const QPointF & screenPos )**

        Constructs an enter event object.

        The points **localPos** , **windowPos** and **screenPos** specify the
        mouse cursor's position relative to the receiving widget or item,
        window, and screen, respectively.
        """
        ...

    def screenPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qenterevent.html#screenPos

        **const QPointF &QEnterEvent::screenPos() const**

        Returns the position of the mouse cursor relative to the receiving
        screen.
        """
        ...

    def windowPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qenterevent.html#windowPos

        **const QPointF &QEnterEvent::windowPos() const**

        Returns the position of the mouse cursor relative to the receiving
        window.
        """
        ...

    def localPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qenterevent.html#localPos

        **const QPointF &QEnterEvent::localPos() const**

        Returns the mouse cursor's position relative to the receiving widget.
        """
        ...

    def globalY(self) -> int:
        """
        https://doc.qt.io/qt-5/qenterevent.html#globalY

        **int QEnterEvent::globalY() const**

        Returns the global position on the Y-axis of the mouse cursor **at the
        time of the event**.
        """
        ...

    def globalX(self) -> int:
        """
        https://doc.qt.io/qt-5/qenterevent.html#globalX

        **int QEnterEvent::globalX() const**

        Returns the global position on the X-axis of the mouse cursor **at the
        time of the event**.
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-5/qenterevent.html#y

        **int QEnterEvent::y() const**

        Returns the y position of the mouse cursor relative to the receiving
        widget.
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-5/qenterevent.html#x

        **int QEnterEvent::x() const**

        Returns the x position of the mouse cursor relative to the receiving
        widget.
        """
        ...

    def globalPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qenterevent.html#globalPos

        **QPoint QEnterEvent::globalPos() const**

        Returns the global position of the mouse cursor **at the time of the
        event**.
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qenterevent.html#pos

        **QPoint QEnterEvent::pos() const**

        Returns the position of the mouse cursor relative to the receiving
        widget.
        """
        ...
