"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QDropEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qdropevent.html

    **Detailed Description**

    When a widget **accepts drop events** , it will receive this event if it has
    accepted the most recent **QDragEnterEvent**  or **QDragMoveEvent**  sent to
    it.

    The drop event contains a proposed action, available from **proposedAction**
    (), for the widget to either accept or ignore. If the action can be handled
    by the widget, you should call the **acceptProposedAction** () function.
    Since the proposed action can be a combination of **Qt::DropAction**
    values, it may be useful to either select one of these values as a default
    action or ask the user to select their preferred action.

    If the proposed drop action is not suitable, perhaps because your custom
    widget does not support that action, you can replace it with any of the
    **possible drop actions**  by calling **setDropAction** () with your
    preferred action. If you set a value that is not present in the bitwise OR
    combination of values returned by **possibleActions** (), the default copy
    action will be used. Once a replacement drop action has been set, call
    **accept** () instead of **acceptProposedAction** () to complete the drop
    operation.

    The **mimeData** () function provides the data dropped on the widget in a
    **QMimeData**  object. This contains information about the MIME type of the
    data in addition to the data itself.

    **See also** **QMimeData** , **QDrag** , and **Drag and Drop** .
    """

    @typing.overload
    def __init__(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        actions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction],
        data: QtCore.QMimeData,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        type: QtCore.QEvent.Type = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdropevent.html#QDropEvent

        **QDropEvent::QDropEvent(const QPointF & pos , Qt::DropActions actions ,
        const QMimeData * data , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , QEvent::Type type = Drop)**

        Constructs a drop event of a certain **type** corresponding to a drop at
        the point specified by **pos** in the destination widget's coordinate
        system.

        The **actions** indicate which types of drag and drop operation can be
        performed, and the drag data is stored as MIME-encoded data in **data**.

        The states of the mouse buttons and keyboard modifiers at the time of
        the drop are specified by **buttons** and **modifiers**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QDropEvent") -> None:
        """
        https://doc.qt.io/qt-5/qdropevent.html#QDropEvent

        **QDropEvent::QDropEvent(const QPointF & pos , Qt::DropActions actions ,
        const QMimeData * data , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , QEvent::Type type = Drop)**

        Constructs a drop event of a certain **type** corresponding to a drop at
        the point specified by **pos** in the destination widget's coordinate
        system.

        The **actions** indicate which types of drag and drop operation can be
        performed, and the drag data is stored as MIME-encoded data in **data**.

        The states of the mouse buttons and keyboard modifiers at the time of
        the drop are specified by **buttons** and **modifiers**.
        """
        ...

    def mimeData(self) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-5/qdropevent.html#mimeData

        **const QMimeData *QDropEvent::mimeData() const**

        Returns the data that was dropped on the widget and its associated MIME
        type information.
        """
        ...

    def source(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qdropevent.html#source

        **QObject *QDropEvent::source() const**

        If the source of the drag operation is a widget in this application,
        this function returns that source; otherwise it returns `nullptr`. The
        source of the operation is the first parameter to the **QDrag**  object
        used instantiate the drag.

        This is useful if your widget needs special behavior when dragging to
        itself.

        **See also** **QDrag::QDrag** ().
        """
        ...

    def setDropAction(self, action: QtCore.Qt.DropAction) -> None:
        """
        https://doc.qt.io/qt-5/qdropevent.html#setDropAction

        **void QDropEvent::setDropAction(Qt::DropAction action )**

        Sets the **action** to be performed on the data by the target. Use this
        to override the **proposed action**  with one of the **possible
        actions** .

        If you set a drop action that is not one of the possible actions, the
        drag and drop operation will default to a copy operation.

        Once you have supplied a replacement drop action, call **accept** ()
        instead of **acceptProposedAction** ().

        **See also** **dropAction** ().
        """
        ...

    def dropAction(self) -> QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-5/qdropevent.html#dropAction

        **Qt::DropAction QDropEvent::dropAction() const**

        Returns the action to be performed on the data by the target. This may
        be different from the action supplied in **proposedAction** () if you
        have called **setDropAction** () to explicitly choose a drop action.

        **See also** **setDropAction** ().
        """
        ...

    def acceptProposedAction(self) -> None:
        """
        https://doc.qt.io/qt-5/qdropevent.html#acceptProposedAction

        **void QDropEvent::acceptProposedAction()**

        Sets the drop action to be the proposed action.

        **See also** **setDropAction** (), **proposedAction** (), and **accept**
        ().
        """
        ...

    def proposedAction(self) -> QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-5/qdropevent.html#proposedAction

        **Qt::DropAction QDropEvent::proposedAction() const**

        Returns the proposed drop action.

        **See also** **dropAction** ().
        """
        ...

    def possibleActions(self) -> QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-5/qdropevent.html#possibleActions

        **Qt::DropActions QDropEvent::possibleActions() const**

        Returns an OR-combination of possible drop actions.

        **See also** **dropAction** ().
        """
        ...

    def keyboardModifiers(self) -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qdropevent.html#keyboardModifiers

        **Qt::KeyboardModifiers QDropEvent::keyboardModifiers() const**

        Returns the modifier keys that are pressed.
        """
        ...

    def mouseButtons(self) -> QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-5/qdropevent.html#mouseButtons

        **Qt::MouseButtons QDropEvent::mouseButtons() const**

        Returns the mouse buttons that are pressed..
        """
        ...

    def posF(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qdropevent.html#posF

        **const QPointF &QDropEvent::posF() const**

        Returns the position where the drop was made.
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qdropevent.html#pos

        **QPoint QDropEvent::pos() const**

        Returns the position where the drop was made.
        """
        ...
