"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QDoubleValidator(QValidator):
    """
    https://doc.qt.io/qt-5/qdoublevalidator.html

    **Detailed Description**

    QDoubleValidator provides an upper bound, a lower bound, and a limit on the
    number of digits after the decimal point. It does not provide a **fixup** ()
    function.

    You can set the acceptable range in one call with **setRange** (), or with
    **setBottom** () and **setTop** (). Set the number of decimal places with
    **setDecimals** (). The **validate** () function returns the validation
    state.

    QDoubleValidator uses its **locale** () to interpret the number. For
    example, in the German locale, "1,234" will be accepted as the fractional
    number 1.234. In Arabic locales, QDoubleValidator will accept Arabic digits.

    **Note:** The **QLocale::NumberOptions**  set on the **locale** () also
    affect the way the number is interpreted. For example, since
    **QLocale::RejectGroupSeparator**  is not set by default, the validator will
    accept group separators. It is thus recommended to use **QLocale::toDouble**
    () to obtain the numeric value.

    **See also** **QIntValidator** , **QRegExpValidator** ,
    **QLocale::toDouble** (), and **Line Edits Example** .
    """

    class Notation(int):
        StandardNotation: QDoubleValidator = ...
        ScientificNotation: QDoubleValidator = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#QDoubleValidator

        **QDoubleValidator::QDoubleValidator(QObject * parent = nullptr)**

        Constructs a validator object with a **parent** object that accepts any
        double.
        """
        ...

    @typing.overload
    def __init__(
        self,
        bottom: float,
        top: float,
        decimals: int,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#QDoubleValidator-1

        **QDoubleValidator::QDoubleValidator(double bottom , double top , int
        decimals , QObject * parent = nullptr)**

        Constructs a validator object with a **parent** object. This validator
        will accept doubles from **bottom** to **top** inclusive, with up to
        **decimals** digits after the decimal point.
        """
        ...

    def notation(self) -> "QDoubleValidator.Notation":
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#notation-prop

        **notation : Notation**

        This property holds the notation of how a string can describe a number

        By default, this property is set to **ScientificNotation** .

        This property was introduced in Qt 4.3.

        **Access functions:**

        QDoubleValidator::Notation **notation** () const
        void **setNotation**
        ( **QDoubleValidator::Notation** )

        **Notifier signal:**

        void **notationChanged** (QDoubleValidator::Notation **notation** )

        **See also** **Notation** .
        """
        ...

    def setNotation(self, a0: "QDoubleValidator.Notation") -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#notation-prop

        **notation : Notation**

        This property holds the notation of how a string can describe a number

        By default, this property is set to **ScientificNotation** .

        This property was introduced in Qt 4.3.

        **Access functions:**

        QDoubleValidator::Notation **notation** () const
        void **setNotation**
        ( **QDoubleValidator::Notation** )

        **Notifier signal:**

        void **notationChanged** (QDoubleValidator::Notation **notation** )

        **See also** **Notation** .
        """
        ...

    def decimals(self) -> int:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#decimals-prop

        **decimals : int**

        This property holds the validator's maximum number of digits after the
        decimal point

        By default, this property contains a value of 1000.

        **Access functions:**

        int **decimals** () const
        void **setDecimals** ( **int** )

        **Notifier signal:**

        void **decimalsChanged** (int **decimals** )

        **See also** **setRange** ().
        """
        ...

    def top(self) -> float:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#top-prop

        **top : double**

        This property holds the validator's maximum acceptable value

        By default, this property contains a value of infinity.

        **Access functions:**

        double **top** () const
        void **setTop** ( **double** )

        **Notifier signal:**

        void **topChanged** (double **top** )

        **See also** **setRange** ().

        **Member Function Documentation**
        """
        ...

    def bottom(self) -> float:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#bottom-prop

        **bottom : double**

        This property holds the validator's minimum acceptable value

        By default, this property contains a value of -infinity.

        **Access functions:**

        double **bottom** () const
        void **setBottom** ( **double** )

        **Notifier signal:**

        void **bottomChanged** (double **bottom** )

        **See also** **setRange** ().
        """
        ...

    def setDecimals(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#decimals-prop

        **decimals : int**

        This property holds the validator's maximum number of digits after the
        decimal point

        By default, this property contains a value of 1000.

        **Access functions:**

        int **decimals** () const
        void **setDecimals** ( **int** )

        **Notifier signal:**

        void **decimalsChanged** (int **decimals** )

        **See also** **setRange** ().
        """
        ...

    def setTop(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#top-prop

        **top : double**

        This property holds the validator's maximum acceptable value

        By default, this property contains a value of infinity.

        **Access functions:**

        double **top** () const
        void **setTop** ( **double** )

        **Notifier signal:**

        void **topChanged** (double **top** )

        **See also** **setRange** ().

        **Member Function Documentation**
        """
        ...

    def setBottom(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#bottom-prop

        **bottom : double**

        This property holds the validator's minimum acceptable value

        By default, this property contains a value of -infinity.

        **Access functions:**

        double **bottom** () const
        void **setBottom** ( **double** )

        **Notifier signal:**

        void **bottomChanged** (double **bottom** )

        **See also** **setRange** ().
        """
        ...

    def setRange(self, minimum: float, maximum: float, decimals: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#setRange

        **[virtual] void QDoubleValidator::setRange(double minimum , double
        maximum , int decimals = 0)**

        Sets the validator to accept doubles from **minimum** to **maximum**
        inclusive, with at most **decimals** digits after the decimal point.
        """
        ...

    def validate(self, a0: str, a1: int) -> typing.Tuple[QValidator.State, str, int]:
        """
        https://doc.qt.io/qt-5/qdoublevalidator.html#validate

        **[override virtual] QValidator::State
        QDoubleValidator::validate(QString & input , int & pos ) const**

        Reimplements: **QValidator::validate** (QString &input, int &pos) const.

        Returns **Acceptable**  if the string **input** contains a double that
        is within the valid range and is in the correct format.

        Returns **Intermediate**  if **input** contains a double that is outside
        the range or is in the wrong format; e.g. is empty.

        Returns **Invalid**  if the **input** is not a double or with too many
        digits after the decimal point.

        Note: If the valid range consists of just positive doubles (e.g. 0.0 to
        100.0) and **input** is a negative double then **Invalid**  is returned.
        If **notation** () is set to **StandardNotation** , and the input
        contains more digits before the decimal point than a double in the valid
        range may have, **Invalid**  is returned. If **notation** () is
        **ScientificNotation** , and the input is not in the valid range,
        **Intermediate**  is returned. The value may yet become valid by
        changing the exponent.

        By default, the **pos** parameter is not used by this validator.
        """
        ...

    @property
    def bottomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def decimalsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def notationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def topChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
