"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QColorSpace(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qcolorspace.html

    **Detailed Description**

    Color values can be interpreted in different ways, and based on the
    interpretation can live in different spaces. We call this **color spaces**.

    QColorSpace provides access to creating several predefined color spaces and
    can generate QColorTransforms for converting colors from one color space to
    another.

    QColorSpace can also represent color spaces defined by ICC profiles or
    embedded in images, that do not otherwise fit the predefined color spaces.

    A color space can generally speaking be conceived as a combination of set of
    primary colors and a transfer function. The primaries defines the axes of
    the color space, and the transfer function how values are mapped on the
    axes. The primaries are defined by three primary colors that represent
    exactly how red, green, and blue look in this particular color space, and a
    white color that represents where and how bright pure white is. The range of
    colors expressable by the primary colors is called the gamut, and a color
    space that can represent a wider range of colors is also known as a wide-
    gamut color space.

    The transfer function or gamma curve determines how each component in the
    color space is encoded. These are used because human perception does not
    operate linearly, and the transfer functions try to ensure that colors will
    seem evenly spaced to human eyes.
    """

    class TransferFunction(int):
        Custom: QColorSpace = ...
        Linear: QColorSpace = ...
        Gamma: QColorSpace = ...
        SRgb: QColorSpace = ...
        ProPhotoRgb: QColorSpace = ...

    class Primaries(int):
        Custom: QColorSpace = ...
        SRgb: QColorSpace = ...
        AdobeRgb: QColorSpace = ...
        DciP3D65: QColorSpace = ...
        ProPhotoRgb: QColorSpace = ...

    class NamedColorSpace(int):
        SRgb: QColorSpace = ...
        SRgbLinear: QColorSpace = ...
        AdobeRgb: QColorSpace = ...
        DisplayP3: QColorSpace = ...
        ProPhotoRgb: QColorSpace = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#QColorSpace

        **QColorSpace::QColorSpace()**

        Creates a new colorspace object that represents an undefined and invalid
        colorspace.
        """
        ...

    @typing.overload
    def __init__(self, namedColorSpace: "QColorSpace.NamedColorSpace") -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#QColorSpace-1

        **QColorSpace::QColorSpace(QColorSpace::NamedColorSpace namedColorSpace
        )**

        Creates a new colorspace object that represents a **namedColorSpace**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        primaries: "QColorSpace.Primaries",
        fun: "QColorSpace.TransferFunction",
        gamma: float = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#QColorSpace-2

        **QColorSpace::QColorSpace(QColorSpace::Primaries primaries ,
        QColorSpace::TransferFunction fun , float gamma = 0.0f)**

        Creates a custom color space with the primaries **primaries** , using
        the transfer function **fun** and optionally **gamma**.
        """
        ...

    @typing.overload
    def __init__(self, primaries: "QColorSpace.Primaries", gamma: float) -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#QColorSpace-3

        **QColorSpace::QColorSpace(QColorSpace::Primaries primaries , float
        gamma )**

        Creates a custom color space with the primaries **primaries** , using a
        gamma transfer function of **gamma**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        whitePoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        redPoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        greenPoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        bluePoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        fun: "QColorSpace.TransferFunction",
        gamma: float = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#QColorSpace-4

        **QColorSpace::QColorSpace(const QPointF & whitePoint , const QPointF &
        redPoint , const QPointF & greenPoint , const QPointF & bluePoint ,
        QColorSpace::TransferFunction fun , float gamma = 0.0f)**

        Creates a custom colorspace with a primaries based on the chromaticities
        of the primary colors **whitePoint** , **redPoint** , **greenPoint** and
        **bluePoint** , and using the transfer function **fun** and optionally
        **gamma**.
        """
        ...

    @typing.overload
    def __init__(self, colorSpace: "QColorSpace") -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#QColorSpace

        **QColorSpace::QColorSpace()**

        Creates a new colorspace object that represents an undefined and invalid
        colorspace.
        """
        ...

    def transformationToColorSpace(
        self, colorspace: "QColorSpace"
    ) -> "QColorTransform":
        """
        https://doc.qt.io/qt-5/qcolorspace.html#transformationToColorSpace

        **QColorTransform QColorSpace::transformationToColorSpace(const
        QColorSpace & colorspace ) const**

        Generates and returns a color space transformation from this color space
        to **colorspace**.
        """
        ...

    def iccProfile(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#iccProfile

        **QByteArray QColorSpace::iccProfile() const**

        Returns an ICC profile representing the color space.

        If the color space was generated from an ICC profile, that profile is
        returned, otherwise one is generated.

        **Note:** Even invalid color spaces may return the ICC profile if they
        were generated from one, to allow applications to implement wider
        support themselves.

        **See also** **fromIccProfile** ().
        """
        ...

    @staticmethod
    def fromIccProfile(
        iccProfile: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> "QColorSpace":
        """
        https://doc.qt.io/qt-5/qcolorspace.html#fromIccProfile

        **[static] QColorSpace QColorSpace::fromIccProfile(const QByteArray &
        iccProfile )**

        Creates a **QColorSpace**  from ICC profile **iccProfile**.

        **Note:** Not all ICC profiles are supported. **QColorSpace**  only
        supports RGB-XYZ ICC profiles that are three-component matrix-based.

        If the ICC profile is not supported an invalid **QColorSpace**  is
        returned where you can still read the original ICC profile using
        **iccProfile** ().

        **See also** **iccProfile** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#isValid

        **bool QColorSpace::isValid() const**

        Returns `true` if the color space is valid.
        """
        ...

    @typing.overload
    def setPrimaries(self, primariesId: "QColorSpace.Primaries") -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#setPrimaries

        **void QColorSpace::setPrimaries(QColorSpace::Primaries primariesId )**

        Sets the primaries to those of the **primariesId** set.

        **See also** **primaries** ().
        """
        ...

    @typing.overload
    def setPrimaries(
        self,
        whitePoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        redPoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        greenPoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        bluePoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#setPrimaries-1

        **void QColorSpace::setPrimaries(const QPointF & whitePoint , const
        QPointF & redPoint , const QPointF & greenPoint , const QPointF &
        bluePoint )**

        Set primaries to the chromaticities of **whitePoint** , **redPoint** ,
        **greenPoint** and **bluePoint**.

        **See also** **primaries** ().
        """
        ...

    def withTransferFunction(
        self, transferFunction: "QColorSpace.TransferFunction", gamma: float = ...
    ) -> "QColorSpace":
        """
        https://doc.qt.io/qt-5/qcolorspace.html#withTransferFunction

        **QColorSpace
        QColorSpace::withTransferFunction(QColorSpace::TransferFunction
        transferFunction , float gamma = 0.0f) const**

        Returns a copy of this color space, except using the transfer function
        **transferFunction** and **gamma**.

        **See also** **transferFunction** (), **gamma** (), and
        **setTransferFunction** ().
        """
        ...

    def setTransferFunction(
        self, transferFunction: "QColorSpace.TransferFunction", gamma: float = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#setTransferFunction

        **void QColorSpace::setTransferFunction(QColorSpace::TransferFunction
        transferFunction , float gamma = 0.0f)**

        Sets the transfer function to **transferFunction** and **gamma**.

        **See also** **transferFunction** (), **gamma** (), and
        **withTransferFunction** ().
        """
        ...

    def gamma(self) -> float:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#gamma

        **float QColorSpace::gamma() const**

        Returns the gamma value of color spaces with `TransferFunction::Gamma`,
        an approximate gamma value for other predefined color spaces, or 0.0 if
        no approximate gamma is known.

        **See also** **transferFunction** ().
        """
        ...

    def transferFunction(self) -> "QColorSpace.TransferFunction":
        """
        https://doc.qt.io/qt-5/qcolorspace.html#transferFunction

        **QColorSpace::TransferFunction QColorSpace::transferFunction() const**

        Returns the predefined transfer function of the color space or
        `TransferFunction::Custom` if it doesn't match any of them.

        **See also** **gamma** (), **setTransferFunction** (), and
        **withTransferFunction** ().
        """
        ...

    def primaries(self) -> "QColorSpace.Primaries":
        """
        https://doc.qt.io/qt-5/qcolorspace.html#primaries

        **QColorSpace::Primaries QColorSpace::primaries() const**

        Returns the predefined primaries of the color space or
        `primaries::Custom` if it doesn't match any of them.

        **See also** **setPrimaries** ().
        """
        ...

    def swap(self, colorSpace: "QColorSpace") -> None:
        """
        https://doc.qt.io/qt-5/qcolorspace.html#swap

        **void QColorSpace::swap(QColorSpace & other )**

        Swaps color space **other** with this color space. This operation is
        very fast and never fails.
        """
        ...
