"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QClipboard(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qclipboard.html

    **Detailed Description**

    The clipboard offers a simple mechanism to copy and paste data between
    applications.

    QClipboard supports the same data types that **QDrag**  does, and uses
    similar mechanisms. For advanced clipboard usage read **Drag and Drop** .

    There is a single QClipboard object in an application, accessible as
    **QGuiApplication::clipboard** ().

    Example:

    QClipboard *clipboard = **QGuiApplication** ::clipboard();
        **QString**
    originalText = clipboard->text();
        ...
        clipboard->setText(newText);

    QClipboard features some convenience functions to access common data types:
    **setText** () allows the exchange of Unicode text and **setPixmap** () and
    **setImage** () allows the exchange of QPixmaps and QImages between
    applications. The **setMimeData** () function is the ultimate in
    flexibility: it allows you to add any **QMimeData**  into the clipboard.
    There are corresponding getters for each of these, e.g. **text** (),
    **image** () and **pixmap** (). You can clear the clipboard by calling
    **clear** ().

    A typical example of the use of these functions follows:

    void DropArea::paste()
        {
            const QClipboard *clipboard =
    **QApplication** ::clipboard();
            const **QMimeData**  *mimeData =
    clipboard->mimeData();

            if (mimeData->hasImage()) {
    setPixmap(qvariant_cast<**QPixmap** >(mimeData->imageData()));
            }
    else if (mimeData->hasHtml()) {
                setText(mimeData->html());
    setTextFormat(Qt::RichText);
            } else if (mimeData->hasText()) {
    setText(mimeData->text());
                setTextFormat(Qt::PlainText);
    } else {
                setText(tr("Cannot display data"));
            }

    **Notes for X11 Users**

    * The X11 Window System has the concept of a separate selection and
    clipboard. When text is selected, it is immediately available as the global
    mouse selection. The global mouse selection may later be copied to the
    clipboard. By convention, the middle mouse button is used to paste the
    global mouse selection.
      * X11 also has the concept of ownership; if you
    change the selection within a window, X11 will only notify the owner and the
    previous owner of the change, i.e. it will not notify all applications that
    the selection or clipboard data changed.
      * Lastly, the X11 clipboard is
    event driven, i.e. the clipboard will not function properly if the event
    loop is not running. Similarly, it is recommended that the contents of the
    clipboard are stored or retrieved in direct response to user-input events,
    e.g. mouse button or key presses and releases. You should not store or
    retrieve the clipboard contents in response to timer or non-user-input
    events.
      * Since there is no standard way to copy and paste files between
    applications on X11, various MIME types and conventions are currently in
    use. For instance, Nautilus expects files to be supplied with a
    `x-special/gnome-copied-files` MIME type with data beginning with the
    cut/copy action, a newline character, and the URL of the file.

    **Notes for macOS Users**

    macOS supports a separate find buffer that holds the current search string
    in Find operations. This find clipboard can be accessed by specifying the
    **FindBuffer**  mode.

    **Notes for Windows and macOS Users**

    * Windows and macOS do not support the global mouse selection; they only
    supports the global clipboard, i.e. they only add text to the clipboard when
    an explicit copy or cut is made.
      * Windows and macOS does not have the
    concept of ownership; the clipboard is a fully global resource so all
    applications are notified of changes.

    **Notes for Universal Windows Platform Users**

    * The Universal Windows Platform only allows to query the clipboard in case
    the application is active and an application window has focus. Accessing the
    clipboard data when in background will fail due to access denial.

    **See also** **QGuiApplication** .
    """

    class Mode(int):
        Clipboard: QClipboard = ...
        Selection: QClipboard = ...
        FindBuffer: QClipboard = ...

    def setPixmap(self, a0: QPixmap, mode: "QClipboard.Mode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qclipboard.html#setPixmap

        **void QClipboard::setPixmap(const QPixmap & pixmap , QClipboard::Mode
        mode = Clipboard)**

        Copies **pixmap** into the clipboard. Note that this is slower than
        **setImage** () because it needs to convert the **QPixmap**  to a
        **QImage**  first.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the pixmap
        is stored in the global clipboard. If **mode** is
        **QClipboard::Selection** , the pixmap is stored in the global mouse
        selection.

        **See also** **pixmap** (), **setImage** (), and **setMimeData** ().
        """
        ...

    def setImage(self, a0: "QImage", mode: "QClipboard.Mode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qclipboard.html#setImage

        **void QClipboard::setImage(const QImage & image , QClipboard::Mode mode
        = Clipboard)**

        Copies the **image** into the clipboard.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the image
        is stored in the global clipboard. If **mode** is
        **QClipboard::Selection** , the data is stored in the global mouse
        selection.

        This is shorthand for:

        **QMimeData**  *data = new **QMimeData** ;
        data->setImageData(image);
            clipboard->setMimeData(data, mode);

        **See also** **image** (), **setPixmap** (), and **setMimeData** ().
        """
        ...

    def pixmap(self, mode: "QClipboard.Mode" = ...) -> QPixmap:
        """
        https://doc.qt.io/qt-5/qclipboard.html#pixmap

        **QPixmap QClipboard::pixmap(QClipboard::Mode mode = Clipboard) const**

        Returns the clipboard pixmap, or null if the clipboard does not contain
        a pixmap. Note that this can lose information. For example, if the image
        is 24-bit and the display is 8-bit, the result is converted to 8 bits,
        and if the image has an alpha channel, the result just has a mask.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the pixmap
        is retrieved from the global clipboard. If **mode** is
        **QClipboard::Selection** , the pixmap is retrieved from the global
        mouse selection.

        **See also** **setPixmap** (), **image** (), **mimeData** (), and
        **QPixmap::convertFromImage** ().
        """
        ...

    def image(self, mode: "QClipboard.Mode" = ...) -> "QImage":
        """
        https://doc.qt.io/qt-5/qclipboard.html#image

        **QImage QClipboard::image(QClipboard::Mode mode = Clipboard) const**

        Returns the clipboard image, or returns a null image if the clipboard
        does not contain an image or if it contains an image in an unsupported
        image format.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the image
        is retrieved from the global clipboard. If **mode** is
        **QClipboard::Selection** , the image is retrieved from the global mouse
        selection.

        **See also** **setImage** (), **pixmap** (), **mimeData** (), and
        **QImage::isNull** ().
        """
        ...

    def setMimeData(
        self, data: QtCore.QMimeData, mode: "QClipboard.Mode" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qclipboard.html#setMimeData

        **void QClipboard::setMimeData(QMimeData * src , QClipboard::Mode mode =
        Clipboard)**

        Sets the clipboard data to **src**. Ownership of the data is transferred
        to the clipboard. If you want to remove the data either call **clear**
        () or call setMimeData() again with new data.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the data
        is stored in the global clipboard. If **mode** is
        **QClipboard::Selection** , the data is stored in the global mouse
        selection. If **mode** is **QClipboard::FindBuffer** , the data is
        stored in the search string buffer.

        The **setText** (), **setImage** () and **setPixmap** () functions are
        simpler wrappers for setting text, image and pixmap data respectively.

        **See also** **mimeData** ().
        """
        ...

    def mimeData(self, mode: "QClipboard.Mode" = ...) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-5/qclipboard.html#mimeData

        **const QMimeData *QClipboard::mimeData(QClipboard::Mode mode =
        Clipboard) const**

        Returns a pointer to a **QMimeData**  representation of the current
        clipboard data (can be `nullptr` if the given **mode** is not supported
        by the platform).

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the data
        is retrieved from the global clipboard. If **mode** is
        **QClipboard::Selection** , the data is retrieved from the global mouse
        selection. If **mode** is **QClipboard::FindBuffer** , the data is
        retrieved from the search string buffer.

        The **text** (), **image** (), and **pixmap** () functions are simpler
        wrappers for retrieving text, image, and pixmap data.

        **Note:** The pointer returned might become invalidated when the
        contents of the clipboard changes; either by calling one of the setter
        functions or externally by the system clipboard changing.

        **See also** **setMimeData** ().
        """
        ...

    def setText(self, a0: str, mode: "QClipboard.Mode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qclipboard.html#setText

        **void QClipboard::setText(const QString & text , QClipboard::Mode mode
        = Clipboard)**

        Copies **text** into the clipboard as plain text.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the text
        is stored in the global clipboard. If **mode** is
        **QClipboard::Selection** , the text is stored in the global mouse
        selection. If **mode** is **QClipboard::FindBuffer** , the text is
        stored in the search string buffer.

        **See also** **text** () and **setMimeData** ().
        """
        ...

    @typing.overload
    def text(self, mode: "QClipboard.Mode" = ...) -> str:
        """
        https://doc.qt.io/qt-5/qclipboard.html#text

        **QString QClipboard::text(QClipboard::Mode mode = Clipboard) const**

        Returns the clipboard text as plain text, or an empty string if the
        clipboard does not contain any text.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the text
        is retrieved from the global clipboard. If **mode** is
        **QClipboard::Selection** , the text is retrieved from the global mouse
        selection. If **mode** is **QClipboard::FindBuffer** , the text is
        retrieved from the search string buffer.

        **See also** **setText** () and **mimeData** ().
        """
        ...

    @typing.overload
    def text(
        self, subtype: str, mode: "QClipboard.Mode" = ...
    ) -> typing.Tuple[str, str]:
        """
        https://doc.qt.io/qt-5/qclipboard.html#text-1

        **QString QClipboard::text(QString & subtype , QClipboard::Mode mode =
        Clipboard) const**

        This is an overloaded function.

        Returns the clipboard text in subtype **subtype** , or an empty string
        if the clipboard does not contain any text. If **subtype** is null, any
        subtype is acceptable, and **subtype** is set to the chosen subtype.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , the text
        is retrieved from the global clipboard. If **mode** is
        **QClipboard::Selection** , the text is retrieved from the global mouse
        selection.

        Common values for **subtype** are "plain" and "html".

        Note that calling this function repeatedly, for instance from a key
        event handler, may be slow. In such cases, you should use the
        `dataChanged()` signal instead.

        **See also** **setText** () and **mimeData** ().
        """
        ...

    def ownsSelection(self) -> bool:
        """
        https://doc.qt.io/qt-5/qclipboard.html#ownsSelection

        **bool QClipboard::ownsSelection() const**

        Returns `true` if this clipboard object owns the mouse selection data;
        otherwise returns `false`.
        """
        ...

    def ownsFindBuffer(self) -> bool:
        """
        https://doc.qt.io/qt-5/qclipboard.html#ownsFindBuffer

        **bool QClipboard::ownsFindBuffer() const**

        Returns `true` if this clipboard object owns the find buffer data;
        otherwise returns `false`.

        This function was introduced in Qt 4.2.
        """
        ...

    def ownsClipboard(self) -> bool:
        """
        https://doc.qt.io/qt-5/qclipboard.html#ownsClipboard

        **bool QClipboard::ownsClipboard() const**

        Returns `true` if this clipboard object owns the clipboard data;
        otherwise returns `false`.
        """
        ...

    def supportsSelection(self) -> bool:
        """
        https://doc.qt.io/qt-5/qclipboard.html#supportsSelection

        **bool QClipboard::supportsSelection() const**

        Returns `true` if the clipboard supports mouse selection; otherwise
        returns `false`.
        """
        ...

    def supportsFindBuffer(self) -> bool:
        """
        https://doc.qt.io/qt-5/qclipboard.html#supportsFindBuffer

        **bool QClipboard::supportsFindBuffer() const**

        Returns `true` if the clipboard supports a separate search buffer;
        otherwise returns `false`.
        """
        ...

    def clear(self, mode: "QClipboard.Mode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qclipboard.html#clear

        **void QClipboard::clear(QClipboard::Mode mode = Clipboard)**

        Clear the clipboard contents.

        The **mode** argument is used to control which part of the system
        clipboard is used. If **mode** is **QClipboard::Clipboard** , this
        function clears the global clipboard contents. If **mode** is
        **QClipboard::Selection** , this function clears the global mouse
        selection contents. If **mode** is **QClipboard::FindBuffer** , this
        function clears the search string buffer.

        **See also** **QClipboard::Mode**  and **supportsSelection** ().
        """
        ...

    @property
    def changed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qclipboard.html#changed

        **[signal] void QClipboard::changed(QClipboard::Mode mode )**

        This signal is emitted when the data for the given clipboard **mode** is
        changed.

        This function was introduced in Qt 4.2.

        **See also** **dataChanged** (), **selectionChanged** (), and
        **findBufferChanged** ().
        """
        ...

    @property
    def dataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qclipboard.html#dataChanged

        **[signal] void QClipboard::dataChanged()**

        This signal is emitted when the clipboard data is changed.

        On macOS and with Qt version 4.3 or higher, clipboard changes made by
        other applications will only be detected when the application is
        activated.

        **See also** **findBufferChanged** (), **selectionChanged** (), and
        **changed** ().
        """
        ...

    @property
    def findBufferChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qclipboard.html#findBufferChanged

        **[signal] void QClipboard::findBufferChanged()**

        This signal is emitted when the find buffer is changed. This only
        applies to macOS.

        With Qt version 4.3 or higher, clipboard changes made by other
        applications will only be detected when the application is activated.

        This function was introduced in Qt 4.2.

        **See also** **dataChanged** (), **selectionChanged** (), and
        **changed** ().
        """
        ...

    @property
    def selectionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qclipboard.html#selectionChanged

        **[signal] void QClipboard::selectionChanged()**

        This signal is emitted when the selection is changed. This only applies
        to windowing systems that support selections, e.g. X11. Windows and
        macOS don't support selections.

        **See also** **dataChanged** (), **findBufferChanged** (), and
        **changed** ().
        """
        ...
