"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QBitmap(QPixmap):
    """
    https://doc.qt.io/qt-5/qbitmap.html

    **Detailed Description**

    The QBitmap class is a monochrome off-screen paint device used mainly for
    creating custom **QCursor**  and **QBrush**  objects, constructing
    **QRegion**  objects, and for setting masks for pixmaps and widgets.

    QBitmap is a **QPixmap**  subclass ensuring a depth of 1, except for null
    objects which have a depth of 0. If a pixmap with a depth greater than 1 is
    assigned to a bitmap, the bitmap will be dithered automatically.

    Use the **QColor**  objects **Qt::color0**  and **Qt::color1**  when drawing
    on a QBitmap object (or a **QPixmap**  object with depth 1).

    Painting with **Qt::color0**  sets the bitmap bits to 0, and painting with
    **Qt::color1**  sets the bits to 1. For a bitmap, 0-bits indicate background
    (or transparent pixels) and 1-bits indicate foreground (or opaque pixels).
    Use the **clear** () function to set all the bits to **Qt::color0** . Note
    that using the **Qt::black**  and **Qt::white**  colors make no sense
    because the QColor::pixel() value is not necessarily 0 for black and 1 for
    white.

    The QBitmap class provides the **transformed** () function returning a
    transformed copy of the bitmap; use the **QTransform**  argument to
    translate, scale, shear, and rotate the bitmap. In addition, QBitmap
    provides the static **fromData** () function which returns a bitmap
    constructed from the given `uchar` data, and the static **fromImage** ()
    function returning a converted copy of a **QImage**  object.

    Just like the **QPixmap**  class, QBitmap is optimized by the use of
    implicit data sharing. For more information, see the **Implicit Data
    Sharing**  documentation.

    **See also** **QPixmap** , **QImage** , **QImageReader** , and
    **QImageWriter** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap

        **QBitmap::QBitmap()**

        Constructs a null bitmap.

        **See also** **QPixmap::isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QBitmap") -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap-1

        **QBitmap::QBitmap(const QPixmap & pixmap )**

        Constructs a bitmap that is a copy of the given **pixmap**.

        If the pixmap has a depth greater than 1, the resulting bitmap will be
        dithered automatically.

        **See also** **QPixmap::depth** (), **fromImage** (), and **fromData**
        ().
        """
        ...

    @typing.overload
    def __init__(self, a0: QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap-2

        **QBitmap::QBitmap(int width , int height )**

        Constructs a bitmap with the given **width** and **height**. The pixels
        inside are uninitialized.

        **See also** **clear** ().
        """
        ...

    @typing.overload
    def __init__(self, w: int, h: int) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap-3

        **QBitmap::QBitmap(const QSize & size )**

        Constructs a bitmap with the given **size**. The pixels in the bitmap
        are uninitialized.

        **See also** **clear** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap-4

        **QBitmap::QBitmap(const QString & fileName , const char * format =
        nullptr)**

        Constructs a bitmap from the file specified by the given **fileName**.
        If the file does not exist, or has an unknown format, the bitmap becomes
        a null bitmap.

        The **fileName** and **format** parameters are passed on to the
        **QPixmap::load** () function. If the file format uses more than 1 bit
        per pixel, the resulting bitmap will be dithered automatically.

        **See also** **QPixmap::isNull** () and **QImageReader::imageFormat**
        ().
        """
        ...

    @typing.overload
    def __init__(self, fileName: str, format: typing.Optional[str] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap

        **QBitmap::QBitmap()**

        Constructs a null bitmap.

        **See also** **QPixmap::isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#QBitmap

        **QBitmap::QBitmap()**

        Constructs a null bitmap.

        **See also** **QPixmap::isNull** ().
        """
        ...

    def swap(self, other: "QBitmap") -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#swap

        **void QBitmap::swap(QBitmap & other )**

        Swaps bitmap **other** with this bitmap. This operation is very fast and
        never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    def transformed(self, matrix: "QTransform") -> "QBitmap":
        """
        https://doc.qt.io/qt-5/qbitmap.html#transformed

        **QBitmap QBitmap::transformed(const QTransform & matrix ) const**

        Returns a copy of this bitmap, transformed according to the given
        **matrix**.

        **See also** **QPixmap::transformed** ().
        """
        ...

    @staticmethod
    def fromData(
        size: QtCore.QSize, bits: bytes, format: "QImage.Format" = ...
    ) -> "QBitmap":
        """
        https://doc.qt.io/qt-5/qbitmap.html#fromData

        **[static] QBitmap QBitmap::fromData(const QSize & size , const uchar *
        bits , QImage::Format monoFormat = QImage::Format_MonoLSB)**

        Constructs a bitmap with the given **size** , and sets the contents to
        the **bits** supplied.

        The bitmap data has to be byte aligned and provided in in the bit order
        specified by **monoFormat**. The mono format must be either
        **QImage::Format_Mono**  or **QImage::Format_MonoLSB** . Use
        **QImage::Format_Mono**  to specify data on the XBM format.

        **See also** **fromImage** ().
        """
        ...

    @staticmethod
    def fromImage(
        image: "QImage",
        flags: typing.Union[
            QtCore.Qt.ImageConversionFlags, QtCore.Qt.ImageConversionFlag
        ] = ...,
    ) -> "QBitmap":
        """
        https://doc.qt.io/qt-5/qbitmap.html#fromImage

        **[static] QBitmap QBitmap::fromImage(const QImage & image ,
        Qt::ImageConversionFlags flags = Qt::AutoColor)**

        Returns a copy of the given **image** converted to a bitmap using the
        specified image conversion **flags**.

        **See also** **fromData** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qbitmap.html#clear

        **void QBitmap::clear()**

        Clears the bitmap, setting all its bits to **Qt::color0** .
        """
        ...
