"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QBackingStore(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qbackingstore.html

    **Detailed Description**

    QBackingStore enables the use of **QPainter**  to paint on a **QWindow**
    with type RasterSurface. The other way of rendering to a **QWindow**  is
    through the use of OpenGL with **QOpenGLContext** .

    A QBackingStore contains a buffered representation of the window contents,
    and thus supports partial updates by using **QPainter**  to only update a
    sub region of the window contents.

    QBackingStore might be used by an application that wants to use **QPainter**
    without OpenGL acceleration and without the extra overhead of using the
    **QWidget**  or **QGraphicsView**  UI stacks. For an example of how to use
    QBackingStore see the **Raster Window Example** .
    """

    def __init__(self, window: "QWindow") -> None:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#QBackingStore

        **QBackingStore::QBackingStore(QWindow * window )**

        Constructs an empty surface for the given top-level **window**.
        """
        ...

    def hasStaticContents(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#hasStaticContents

        **bool QBackingStore::hasStaticContents() const**

        Returns a boolean indicating if this window has static contents or not.
        """
        ...

    def staticContents(self) -> "QRegion":
        """
        https://doc.qt.io/qt-5/qbackingstore.html#staticContents

        **QRegion QBackingStore::staticContents() const**

        Returns a **QRegion**  representing the area of the window that has
        static contents.

        **See also** **setStaticContents** ().
        """
        ...

    def setStaticContents(self, region: "QRegion") -> None:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#setStaticContents

        **void QBackingStore::setStaticContents(const QRegion & region )**

        Set **region** as the static contents of this window.

        **See also** **staticContents** ().
        """
        ...

    def endPaint(self) -> None:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#endPaint

        **void QBackingStore::endPaint()**

        Ends painting.

        You should call this function after painting with the **paintDevice** ()
        has ended.

        **See also** **beginPaint** () and **paintDevice** ().
        """
        ...

    def beginPaint(self, a0: "QRegion") -> None:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#beginPaint

        **void QBackingStore::beginPaint(const QRegion & region )**

        Begins painting on the backing store surface in the given **region**.

        You should call this function before using the **paintDevice** () to
        paint.

        **See also** **endPaint** () and **paintDevice** ().
        """
        ...

    def scroll(self, area: "QRegion", dx: int, dy: int) -> bool:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#scroll

        **bool QBackingStore::scroll(const QRegion & area , int dx , int dy )**

        Scrolls the given **area** **dx** pixels to the right and **dy**
        downward; both **dx** and **dy** may be negative.

        Returns `true` if the area was scrolled successfully; false otherwise.
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#size

        **QSize QBackingStore::size() const**

        Returns the current size of the window surface.
        """
        ...

    def resize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#resize

        **void QBackingStore::resize(const QSize & size )**

        Sets the size of the window surface to **size**.

        **See also** **size** ().
        """
        ...

    def flush(
        self,
        region: "QRegion",
        window: typing.Optional["QWindow"] = ...,
        offset: QtCore.QPoint = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbackingstore.html#flush

        **void QBackingStore::flush(const QRegion & region , QWindow * window =
        nullptr, const QPoint & offset = QPoint())**

        Flushes the given **region** from the specified **window** onto the
        screen.

        The **window** must either be the top level window represented by this
        backingstore, or a non-transient child of that window. Passing `nullptr`
        falls back to using the backingstore's top level window.

        If the **window** is a child window, the **region** should be in child
        window coordinates, and the **offset** should be the child window's
        offset in relation to the backingstore's top level window.

        You should call this function after ending painting with **endPaint**
        ().
        """
        ...

    def paintDevice(self) -> "QPaintDevice":
        """
        https://doc.qt.io/qt-5/qbackingstore.html#paintDevice

        **QPaintDevice *QBackingStore::paintDevice()**

        Returns the paint device for this surface.

        **Warning:** The device is only valid between calls to **beginPaint** ()
        and **endPaint** (). You should not cache the returned value.
        """
        ...

    def window(self) -> "QWindow":
        """
        https://doc.qt.io/qt-5/qbackingstore.html#window

        **QWindow *QBackingStore::window() const**

        Returns a pointer to the top-level window associated with this surface.
        """
        ...
