"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtWidgets
from PyQt5 import QtCore
from PyQt5.QtDesigner import *


class QDesignerPropertyEditorInterface(QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html

    **Detailed Description**

    QDesignerPropertyEditorInterface contains a collection of functions that is
    typically used to query the property editor for its current state, and
    several slots manipulating it's state. The interface also provide a signal,
    **propertyChanged** (), which is emitted whenever a property changes in the
    property editor. The signal's arguments are the property that changed and
    its new value.

    For example, when implementing a custom widget plugin, you can connect the
    signal to a custom slot:

    **QDesignerPropertyEditorInterface**  *propertyEditor = 0;
    propertyEditor = formEditor->propertyEditor();
    connect(propertyEditor, SIGNAL(propertyChanged(**QString** ,**QVariant** )),
    this, SLOT(checkProperty(**QString** ,**QVariant** )));

    Then the custom slot can check if the new value is within the range we want
    when a specified property, belonging to a particular widget, changes:

    void checkProperty(**QString**  property, **QVariant**  value) {
    **QDesignerPropertyEditorInterface**  *propertyEditor = 0;
    propertyEditor = formEditor->propertyEditor();
    **QObject**  *object = propertyeditor->object();
    MyCustomWidget *widget = qobject_cast<MyCustomWidget>(object);
    if (widget && property == aProperty && value != expectedValue)
    {...}
                }

    The QDesignerPropertyEditorInterface class is not intended to be
    instantiated directly. You can retrieve an interface to **Qt Designer** 's
    property editor using the **QDesignerFormEditorInterface::propertyEditor**
    () function. A pointer to **Qt Designer** 's current
    **QDesignerFormEditorInterface**  object (`formEditor` in the examples
    above) is provided by the **QDesignerCustomWidgetInterface::initialize** ()
    function's parameter. When implementing a custom widget plugin, you must
    subclass the **QDesignerCustomWidgetInterface**  to expose your plugin to
    **Qt Designer**.

    The functions accessing the property editor are the **core** () function
    that you can use to retrieve an interface to the form editor, the
    **currentPropertyName** () function that returns the name of the currently
    selected property in the property editor, the **object** () function that
    returns the currently selected object in **Qt Designer** 's workspace, and
    the **isReadOnly** () function that returns true if the property editor is
    write proteced (otherwise false).

    The slots manipulating the property editor's state are the **setObject** ()
    slot that you can use to change the currently selected object in **Qt
    Designer** 's workspace, the **setPropertyValue** () slot that changes the
    value of a given property and the **setReadOnly** () slot that control the
    write protection of the property editor.

    **See also** **QDesignerFormEditorInterface** .
    """

    def __init__(
        self,
        parent: QtWidgets.QWidget,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#QDesignerPr
        opertyEditorInterface

        **QDesignerPropertyEditorInterface::QDesignerPropertyEditorInterface(QWi
        dget * parent , Qt::WindowFlags flags = Qt::WindowFlags())**

        Constructs a property editor interface with the given **parent** and the
        specified window **flags**.
        """
        ...

    def setReadOnly(self, readOnly: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#setReadOnly

        **[pure virtual slot] void
        QDesignerPropertyEditorInterface::setReadOnly(bool readOnly )**

        If **readOnly** is true, the property editor is made write protected;
        otherwise the write protection is removed.

        **See also** **isReadOnly** ().
        """
        ...

    def setPropertyValue(
        self, name: str, value: typing.Any, changed: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#setProperty
        Value

        **[pure virtual slot] void
        QDesignerPropertyEditorInterface::setPropertyValue(const QString & name
        , const QVariant & value , bool changed = true)**

        Sets the value of the property specified by **name** to **value**.

        In addition, the property is marked as **changed** in the property
        editor, i.e. its value is different from the default value.

        **See also** **currentPropertyName** () and **propertyChanged** ().
        """
        ...

    def setObject(self, object: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#setObject

        **[pure virtual slot] void
        QDesignerPropertyEditorInterface::setObject(QObject * object )**

        Changes the currently selected object in **Qt Designer** 's workspace,
        to **object**.

        **See also** **object** ().
        """
        ...

    def currentPropertyName(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#currentProp
        ertyName

        **[pure virtual] QString
        QDesignerPropertyEditorInterface::currentPropertyName() const**

        Returns the name of the currently selected property in the property
        editor.

        **See also** **setPropertyValue** ().
        """
        ...

    def object(self) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#object

        **[pure virtual] QObject *QDesignerPropertyEditorInterface::object()
        const**

        Returns the currently selected object in **Qt Designer** 's workspace.

        **See also** **setObject** ().
        """
        ...

    def isReadOnly(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#isReadOnly

        **[pure virtual] bool QDesignerPropertyEditorInterface::isReadOnly()
        const**

        Returns true if the property editor is write protected; otherwise false.

        **See also** **setReadOnly** ().
        """
        ...

    def core(self) -> QDesignerFormEditorInterface:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#core

        **[virtual] QDesignerFormEditorInterface
        *QDesignerPropertyEditorInterface::core() const**

        Returns a pointer to **Qt Designer** 's current
        **QDesignerFormEditorInterface**  object.
        """
        ...

    @property
    def propertyChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdesignerpropertyeditorinterface.html#propertyCha
        nged

        **[signal] void QDesignerPropertyEditorInterface::propertyChanged(const
        QString & name , const QVariant & value )**

        This signal is emitted whenever a property changes in the property
        editor. The property that changed and its new value are specified by
        **name** and **value** respectively.

        **See also** **setPropertyValue** ().
        """
        ...
