"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtWidgets
from PyQt5 import QtCore
from PyQt5.QtDesigner import *


class QDesignerFormWindowManagerInterface(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html

    **Detailed Description**

    QDesignerFormWindowManagerInterface is not intended to be instantiated
    directly. **Qt Designer** uses the form window manager to control the
    various form windows in its workspace. You can retrieve an interface to **Qt
    Designer** 's form window manager using the
    **QDesignerFormEditorInterface::formWindowManager** () function. For
    example:

    **QDesignerFormWindowManagerInterface**  *manager = 0;
    **QDesignerFormWindowInterface**  *formWindow = 0;

                manager
    = formEditor->formWindowManager();
                formWindow =
    manager->formWindow(0);
    manager->setActiveFormWindow(formWindow);

    When implementing a custom widget plugin, a pointer to **Qt Designer** 's
    current **QDesignerFormEditorInterface**  object (`formEditor` in the
    example above) is provided by the
    **QDesignerCustomWidgetInterface::initialize** () function's parameter. You
    must subclass the **QDesignerCustomWidgetInterface**  to expose your plugin
    to Qt Designer.

    The form window manager interface provides the **createFormWindow** ()
    function that enables you to create a new form window which you can add to
    the collection of form windows that the manager maintains, using the
    **addFormWindow** () slot. It also provides the **formWindowCount** ()
    function returning the number of form windows currently under the manager's
    control, the **formWindow** () function returning the form window associated
    with a given index, and the **activeFormWindow** () function returning the
    currently selected form window. The **removeFormWindow** () slot allows you
    to reduce the number of form windows the manager must maintain, and the
    **setActiveFormWindow** () slot allows you to change the form window focus
    in **Qt Designer** 's workspace.

    In addition, QDesignerFormWindowManagerInterface contains a collection of
    functions that enables you to intervene and control **Qt Designer** 's form
    editing actions. All these functions return the original action, making it
    possible to propagate the function further after intervention.

    Finally, the interface provides three signals which are emitted when a form
    window is added, when the currently selected form window changes, or when a
    form window is removed, respectively. All the signals carry the form window
    in question as their parameter.

    **See also** **QDesignerFormEditorInterface**  and
    **QDesignerFormWindowInterface** .
    """

    class ActionGroup(int):
        StyledPreviewActionGroup: QDesignerFormWindowManagerInterface = ...

    class Action(int):
        CutAction: QDesignerFormWindowManagerInterface = ...
        CopyAction: QDesignerFormWindowManagerInterface = ...
        PasteAction: QDesignerFormWindowManagerInterface = ...
        DeleteAction: QDesignerFormWindowManagerInterface = ...
        SelectAllAction: QDesignerFormWindowManagerInterface = ...
        LowerAction: QDesignerFormWindowManagerInterface = ...
        RaiseAction: QDesignerFormWindowManagerInterface = ...
        UndoAction: QDesignerFormWindowManagerInterface = ...
        RedoAction: QDesignerFormWindowManagerInterface = ...
        HorizontalLayoutAction: QDesignerFormWindowManagerInterface = ...
        VerticalLayoutAction: QDesignerFormWindowManagerInterface = ...
        SplitHorizontalAction: QDesignerFormWindowManagerInterface = ...
        SplitVerticalAction: QDesignerFormWindowManagerInterface = ...
        GridLayoutAction: QDesignerFormWindowManagerInterface = ...
        FormLayoutAction: QDesignerFormWindowManagerInterface = ...
        BreakLayoutAction: QDesignerFormWindowManagerInterface = ...
        AdjustSizeAction: QDesignerFormWindowManagerInterface = ...
        SimplifyLayoutAction: QDesignerFormWindowManagerInterface = ...
        DefaultPreviewAction: QDesignerFormWindowManagerInterface = ...
        FormWindowSettingsDialogAction: QDesignerFormWindowManagerInterface = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#QDesigne
        rFormWindowManagerInterface

        **QDesignerFormWindowManagerInterface::QDesignerFormWindowManagerInterfa
        ce(QObject * parent = nullptr)**

        Constructs an interface with the given **parent** for the form window
        manager.
        """
        ...

    def showPluginDialog(self) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#showPlug
        inDialog

        **[pure virtual slot] void
        QDesignerFormWindowManagerInterface::showPluginDialog()**

        Opens a dialog showing the plugins loaded by **Qt Designer** 's and its
        plugin load failures.

        This function was introduced in Qt 5.0.
        """
        ...

    def closeAllPreviews(self) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#closeAll
        Previews

        **[pure virtual slot] void
        QDesignerFormWindowManagerInterface::closeAllPreviews()**

        Close all currently open previews.

        This function was introduced in Qt 5.0.

        **See also** **showPreview** ().
        """
        ...

    def showPreview(self) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#showPrev
        iew

        **[pure virtual slot] void
        QDesignerFormWindowManagerInterface::showPreview()**

        Show a preview of the current form using the default parameters.

        This function was introduced in Qt 5.0.

        **See also** **closeAllPreviews** ().
        """
        ...

    def actionGroup(
        self, actionGroup: "QDesignerFormWindowManagerInterface.ActionGroup"
    ) -> QtWidgets.QActionGroup:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#actionGr
        oup

        **[pure virtual] QActionGroup *QDesignerFormWindowManagerInterface::acti
        onGroup(QDesignerFormWindowManagerInterface::ActionGroup actionGroup )
        const**

        Returns the action group specified by the enumeration value
        **actionGroup**.

        This function was introduced in Qt 5.0.
        """
        ...

    def action(
        self, action: "QDesignerFormWindowManagerInterface.Action"
    ) -> QtWidgets.QAction:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#action

        **[pure virtual] QAction *QDesignerFormWindowManagerInterface::action(QD
        esignerFormWindowManagerInterface::Action action ) const**

        Returns the action specified by the enumeration value **action**.

        Obsoletes the action accessors of Qt 4.X.

        This function was introduced in Qt 5.0.
        """
        ...

    def setActiveFormWindow(self, formWindow: QDesignerFormWindowInterface) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#setActiv
        eFormWindow

        **[pure virtual slot] void QDesignerFormWindowManagerInterface::setActiv
        eFormWindow(QDesignerFormWindowInterface * formWindow )**

        Sets the given **formWindow** to be the currently active form window in
        **Qt Designer** 's workspace.

        **See also** **activeFormWindow** () and **activeFormWindowChanged** ().
        """
        ...

    def removeFormWindow(self, formWindow: QDesignerFormWindowInterface) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#removeFo
        rmWindow

        **[pure virtual slot] void QDesignerFormWindowManagerInterface::removeFo
        rmWindow(QDesignerFormWindowInterface * formWindow )**

        Removes the given **formWindow** from the collection of windows that
        **Qt Designer** 's form window manager maintains.

        **See also** **formWindow** () and **formWindowRemoved** ().
        """
        ...

    def addFormWindow(self, formWindow: QDesignerFormWindowInterface) -> None:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#addFormW
        indow

        **[pure virtual slot] void QDesignerFormWindowManagerInterface::addFormW
        indow(QDesignerFormWindowInterface * formWindow )**

        Adds the given **formWindow** to the collection of windows that **Qt
        Designer** 's form window manager maintains.

        **See also** **formWindowAdded** ().
        """
        ...

    def core(self) -> QDesignerFormEditorInterface:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#core

        **[pure virtual] QDesignerFormEditorInterface
        *QDesignerFormWindowManagerInterface::core() const**

        Returns a pointer to **Qt Designer** 's current
        **QDesignerFormEditorInterface**  object.
        """
        ...

    def createFormWindow(
        self,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#createFo
        rmWindow

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowManagerInterface::createFormWindow(QWidget * parent
        = nullptr, Qt::WindowFlags flags = Qt::WindowFlags())**

        Creates a form window with the given **parent** and the given window
        **flags**.

        **See also** **addFormWindow** ().
        """
        ...

    def formWindow(self, index: int) -> QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#formWind
        ow

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowManagerInterface::formWindow(int index ) const**

        Returns the form window at the given **index**.

        **See also** **setActiveFormWindow** () and **removeFormWindow** ().
        """
        ...

    def formWindowCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#formWind
        owCount

        **[pure virtual] int
        QDesignerFormWindowManagerInterface::formWindowCount() const**

        Returns the number of form windows maintained by **Qt Designer** 's form
        window manager.
        """
        ...

    def activeFormWindow(self) -> QDesignerFormWindowInterface:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#activeFo
        rmWindow

        **[pure virtual] QDesignerFormWindowInterface
        *QDesignerFormWindowManagerInterface::activeFormWindow() const**

        Returns the currently active form window in **Qt Designer** 's
        workspace.

        **See also** **setActiveFormWindow** () and **removeFormWindow** ().
        """
        ...

    def actionSimplifyLayout(self) -> QtWidgets.QAction:
        ...

    def actionFormLayout(self) -> QtWidgets.QAction:
        ...

    @property
    def activeFormWindowChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#activeFo
        rmWindowChanged

        **[signal] void QDesignerFormWindowManagerInterface::activeFormWindowCha
        nged(QDesignerFormWindowInterface * formWindow )**

        This signal is emitted when the contents of the currently active form
        window in **Qt Designer** 's workspace changed. A pointer to the
        currently active **formWindow** is passed as an argument.

        **See also** **activeFormWindow** ().
        """
        ...

    @property
    def formWindowAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#formWind
        owAdded

        **[signal] void QDesignerFormWindowManagerInterface::formWindowAdded(QDe
        signerFormWindowInterface * formWindow )**

        This signal is emitted when a new form window is added to the collection
        of windows that **Qt Designer** 's form window manager maintains. A
        pointer to the new **formWindow** is passed as an argument.

        **See also** **addFormWindow** () and **setActiveFormWindow** ().
        """
        ...

    @property
    def formWindowRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#formWind
        owRemoved

        **[signal] void QDesignerFormWindowManagerInterface::formWindowRemoved(Q
        DesignerFormWindowInterface * formWindow )**

        This signal is emitted when a form window is removed from the collection
        of windows that **Qt Designer** 's form window manager maintains. A
        pointer to the removed **formWindow** is passed as an argument.

        **See also** **removeFormWindow** ().
        """
        ...

    @property
    def formWindowSettingsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdesignerformwindowmanagerinterface.html#formWind
        owSettingsChanged

        **[signal] void QDesignerFormWindowManagerInterface::formWindowSettingsC
        hanged(QDesignerFormWindowInterface * formWindow )**

        This signal is emitted when the settings of the form window change. It
        can be used to update window titles, etc. accordingly. A pointer to the
        **formWindow** is passed as an argument.

        **See also** **FormWindowSettingsDialogAction** .
        """
        ...
