"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtWidgets
from PyQt5 import QtCore
from PyQt5.QtDesigner import *


class QDesignerActionEditorInterface(QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-5/qdesigneractioneditorinterface.html

    **Detailed Description**

    The QDesignerActionEditorInterface class is not intended to be instantiated
    directly. You can retrieve an interface to **Qt Designer** 's action editor
    using the **QDesignerFormEditorInterface::actionEditor** () function.

    You can control which actions that are available in the action editor's
    window using the **manageAction** () and **unmanageAction** () functions. An
    action that is managed by **Qt Designer** is available in the action editor
    while an unmanaged action is ignored.

    QDesignerActionEditorInterface also provides the **core** () function that
    you can use to retrieve a pointer to **Qt Designer** 's current
    **QDesignerFormEditorInterface**  object, and the **setFormWindow** ()
    function that enables you to change the currently selected form window.

    **See also** **QDesignerFormEditorInterface**  and
    **QDesignerFormWindowInterface** .
    """

    def __init__(
        self,
        parent: QtWidgets.QWidget,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdesigneractioneditorinterface.html#QDesignerActi
        onEditorInterface

        **QDesignerActionEditorInterface::QDesignerActionEditorInterface(QWidget
        * parent , Qt::WindowFlags flags = Qt::WindowFlags())**

        Constructs an action editor interface with the given **parent** and the
        specified window **flags**.
        """
        ...

    def setFormWindow(self, formWindow: "QDesignerFormWindowInterface") -> None:
        """
        https://doc.qt.io/qt-5/qdesigneractioneditorinterface.html#setFormWindow

        **[pure virtual slot] void QDesignerActionEditorInterface::setFormWindow
        (QDesignerFormWindowInterface * formWindow )**

        Sets the currently selected form window to **formWindow**.
        """
        ...

    def unmanageAction(self, action: QtWidgets.QAction) -> None:
        """
        https://doc.qt.io/qt-5/qdesigneractioneditorinterface.html#unmanageActio
        n

        **[pure virtual] void
        QDesignerActionEditorInterface::unmanageAction(QAction * action )**

        Instructs **Qt Designer** to ignore the specified **action**. An
        unmanaged action is not available in the action editor.

        **See also** **manageAction** ().
        """
        ...

    def manageAction(self, action: QtWidgets.QAction) -> None:
        """
        https://doc.qt.io/qt-5/qdesigneractioneditorinterface.html#manageAction

        **[pure virtual] void
        QDesignerActionEditorInterface::manageAction(QAction * action )**

        Instructs **Qt Designer** to manage the specified **action**. An action
        that is managed by **Qt Designer** is available in the action editor.

        **See also** **unmanageAction** ().
        """
        ...

    def core(self) -> "QDesignerFormEditorInterface":
        """
        https://doc.qt.io/qt-5/qdesigneractioneditorinterface.html#core

        **[virtual] QDesignerFormEditorInterface
        *QDesignerActionEditorInterface::core() const**

        Returns a pointer to **Qt Designer** 's current
        **QDesignerFormEditorInterface**  object.
        """
        ...
